#!/bin/sh

######################################################################
# Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
#
#  This shell script assume system use /bin/bash
#
#  Source this script to get the following environment variables:
#    OPATCH_MAX_HEAP_MEMORY
#
######################################################################


### Declare Global Variables - Start ###

OPATCH_MAX_HEAP_MEMORY=3072
REQUIRED_HEAP=0

### Declare Global Variables - End ###

### Util Methods - Start ###
debugLog()
{
   if [ ! -z "${OPATCH_DEBUG}" ] && [ `echo "${OPATCH_DEBUG}" | tr "[A-Z]" "[a-z]"` = "true" ]; then
      echo $1
   fi
}

countCopyActions()
{
   totalCopyActions=0
   patch_location=$1
   if [ -d $patch_location ]
   then
      for actionXML in `find $patch_location -name actions.xml `
      do 
         files=`grep "<copy"  $actionXML | wc -l`
         totalCopyActions=`expr $totalCopyActions + $files`
      done
   fi
   echo "$totalCopyActions"
}

countCopyActionForPi()
{
   pi_copy_count=0
   if [ ! -z "$PH_BASE_FILE" ] && [ -f $PH_BASE_FILE ]; then
      for patch_dir in `cat $PH_BASE_FILE`
      do
         patch_dir="$(echo -e "${patch_dir}" | sed -e 's/^[[:space:]]*//')"
         patch_dir="$(echo -e "${patch_dir}" | sed -e 's/[[:space:]]*$//')" 
         temp_pi_copy_count=`countCopyActions $patch_dir`  
         pi_copy_count=`expr $pi_copy_count + $temp_pi_copy_count`
      done   
   elif [ ! -z "$PH_BASE_DIR" ] && [ -d $PH_BASE_DIR ]; then
      temp_pi_copy_count=`countCopyActions $PH_BASE_DIR`
      pi_copy_count=`expr $pi_copy_count + $temp_pi_copy_count`
   fi
   echo "$pi_copy_count"
}

calculateMemory()
{
   # Get Total copy count for OracleHome
   totalCopyCountPoh=`countCopyActions $OH/inventory/oneoffs/`
   debugLog "Copy Count for Oracle Home: $totalCopyCountPoh"

   totalCopyCountPi=`countCopyActionForPi`
   #totalCopyCountPi=25000 # This is buffering for temperory workaround.
   
   debugLog "Copy Count for Incoming Patches: $totalCopyCountPi"

   totalCopyCount=`expr $totalCopyCountPoh + $totalCopyCountPi` 
   debugLog "Total Copy Count: $totalCopyCount"

   # Apply formulat to Calculate required memroy  
   a=`expr $totalCopyCount - 130000`
   memory_mb=1536 
   if [ $a -gt 0 ]
   then
      b=`expr $a / 25000`
      c=`expr $b \* 90`      
      memory_mb=`expr $memory_mb + $c`
   fi
   REQUIRED_HEAP=$memory_mb
   debugLog "Calculated Heap Memory is : $REQUIRED_HEAP"   
}

verify_env_and_pick_memory()
{
   ## If opatch.properties is present and heap is configured there, use that value as default base value.
   if [ ! -f ${BASE}/config/opatch.properties ]; then
      debugLog "${BASE}/config/opatch.properties does not exist. Considering default value"
   else
      . ${BASE}/config/opatch.properties
   fi

   if [ ! "$OPATCH_HEAP_MEMORY" ]; then
      debugLog "OPATCH_HEAP_MEMORY not set in opatch.properties. Considering default value."
   else
      OPATCH_MAX_HEAP_MEMORY=$OPATCH_HEAP_MEMORY
      debugLog "Heap Memory configured in opatch.properties will considered default Heap. It is OPATCH_HEAP_MEMORY=${OPATCH_HEAP_MEMORY}"
   fi
   
   debugLog "Opatch Command: $OPATCH_COMMAND" 
   debugLog "Patch Home Base Directory: $PH_BASE_DIR" 
   debugLog "Patch Home Base File: $PH_BASE_FILE" 
  
   if [ "$OPATCH_COMMAND" = "napply" ] || [ "$OPATCH_COMMAND" = "apply" ] || [ "$OPATCH_COMMAND" = "prereq" ] || [ "$OPATCH_COMMAND" = "lsinv" ] || [ "$OPATCH_COMMAND" = "lsinventory" ] || [ "$OPATCH_COMMAND" = "getenv" ]; then 
      ## If calculated value in target environment is more than default base value, use calculated value.
      calculateMemory
      if [ $REQUIRED_HEAP -gt $OPATCH_MAX_HEAP_MEMORY ]
      then
         debugLog "Calculated Heap Memory is greater than default Heap Memory. So using calculated heap memory."
         OPATCH_MAX_HEAP_MEMORY=$REQUIRED_HEAP
      else
         debugLog "Calculated Heap Memory is less than default Heap Memory."
      fi
   else
         debugLog "Memory calculation not needed for this command."
   fi

   debugLog "OPATCH_MAX_HEAP_MEMORY=${OPATCH_MAX_HEAP_MEMORY}"   
}


### Util Methods - End ###

verify_env_and_pick_memory
debugLog "Max Heap set $OPATCH_MAX_HEAP_MEMORY"
export OPATCH_MAX_HEAP_MEMORY

