/*
 * Decompiled with CFR 0.152.
 */
package dbmodel.util;

import dbmodel.SystemInstance;
import dbmodel.bundle_xml.Action;
import dbmodel.bundle_xml.Advisory;
import dbmodel.bundle_xml.Automation;
import dbmodel.bundle_xml.Channel;
import dbmodel.bundle_xml.OS;
import dbmodel.bundle_xml.Pair;
import dbmodel.bundle_xml.PayloadFormat;
import dbmodel.bundle_xml.Product;
import dbmodel.bundle_xml.Release;
import dbmodel.bundle_xml.RpmFile;
import dbmodel.bundle_xml.Script;
import dbmodel.bundle_xml.Subpatch;
import dbmodel.bundle_xml.SystemPatchBundleXML;
import dbmodel.bundle_xml.SystemTargetType;
import dbmodel.bundle_xml.TargetType;
import dbmodel.bundle_xml.fvalue;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.EMtargetTypes;
import dbmodel.patchmodel.EngineeredSystemPatch;
import dbmodel.patchmodel.GenericPatch;
import dbmodel.patchmodel.PatchType;
import dbmodel.patchmodel.PatchingTool;
import dbmodel.util.BundleValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.Unmarshaller;

public class BundleXmlUtilBase {
    protected static Logger logger = null;
    protected static String xsdFileName = "dbmodel/xml/system_patch_bundle.xsd";
    protected static String xmlFileName = "dbmodel/util/test/system_patch_bundle.xml";
    protected static String xmlV3FileName = "dbmodel/util/test/system_patch_bundle_v3.xml";
    protected Unmarshaller unmarshaller = null;

    protected Class[] getClasses() {
        return new Class[]{SystemPatchBundleXML.class, Subpatch.class, SystemTargetType.class, TargetType.class, Product.class, Release.class, Automation.class, fvalue.class, PatchingTool.class, PatchType.class, EMtargetTypes.class, Channel.class, RpmFile.class, Action.class, Advisory.class, PayloadFormat.class, OS.class, Script.class, Pair.class};
    }

    public static Map<AbstractBaseTarget, List<GenericPatch>> getTargetPatchMap(SystemInstance config, EngineeredSystemPatch systemPatch) throws BundleValidationException {
        if (config == null || config.getEntities() == null || config.getEntities().isEmpty()) {
            throw new IllegalArgumentException(" System instance is empty");
        }
        if (systemPatch == null) {
            throw new IllegalArgumentException(" System Patch is null");
        }
        if (systemPatch.getSubPatches() == null || systemPatch.getSubPatches().isEmpty()) {
            throw new BundleValidationException(" system patch does not contain any subpatches");
        }
        SystemPatchBundleXML bundle = systemPatch.getSystemPatchBundleXML();
        if (bundle == null) {
            throw new BundleValidationException(" system patch does not contain SystemPatchBundleXML");
        }
        if (bundle.getSubpatches() == null || bundle.getSubpatches().isEmpty()) {
            throw new BundleValidationException(" system patch bundle does not contain any subpatch metadata");
        }
        HashMap<String, GenericPatch> subpatches = new HashMap<String, GenericPatch>();
        for (GenericPatch sub : systemPatch.getSubPatches()) {
            subpatches.put(sub.getUPI(), sub);
        }
        HashMap<AbstractBaseTarget, List<GenericPatch>> result = new HashMap<AbstractBaseTarget, List<GenericPatch>>();
        for (Subpatch patch : bundle.getSubpatches()) {
            if (patch.getTargetTypes() == null || patch.getTargetTypes().isEmpty()) continue;
            for (TargetType tt : patch.getTargetTypes()) {
                List<AbstractBaseTarget> targets = config.getTargetsOfEMTypeAndVersion(tt);
                if (targets == null || targets.isEmpty()) continue;
                for (AbstractBaseTarget target : targets) {
                    ArrayList patches = (ArrayList)result.get(target);
                    if (patches == null) {
                        patches = new ArrayList();
                        result.put(target, patches);
                    }
                    patches.add(subpatches.get(patch.getUniquePatchID()));
                }
            }
        }
        return result;
    }

    public static Map<AbstractBaseTarget, List<Subpatch>> getTargetPatchMap(SystemInstance config, SystemPatchBundleXML bundle) throws BundleValidationException {
        if (config == null || config.getEntities() == null || config.getEntities().isEmpty()) {
            throw new IllegalArgumentException(" System instance is empty");
        }
        if (bundle == null) {
            throw new BundleValidationException(" system patch does not contain SystemPatchBundleXML");
        }
        if (bundle.getSubpatches() == null || bundle.getSubpatches().isEmpty()) {
            throw new BundleValidationException(" system patch bundle does not contain any subpatch metadata");
        }
        HashMap<AbstractBaseTarget, List<Subpatch>> result = new HashMap<AbstractBaseTarget, List<Subpatch>>();
        for (Subpatch patch : bundle.getSubpatches()) {
            if (patch.getTargetTypes() == null || patch.getTargetTypes().isEmpty()) continue;
            for (TargetType tt : patch.getTargetTypes()) {
                List<AbstractBaseTarget> targets = config.getTargetsOfEMTypeAndVersion(tt);
                if (targets == null || targets.isEmpty()) continue;
                for (AbstractBaseTarget target : targets) {
                    ArrayList<Subpatch> patches = (ArrayList<Subpatch>)result.get(target);
                    if (patches == null) {
                        patches = new ArrayList<Subpatch>();
                        result.put(target, patches);
                    }
                    patches.add(patch);
                }
            }
        }
        return result;
    }

    public static void setRebootRequired(Subpatch subPatchXml, GenericPatch subpatch) {
        if (subPatchXml.getRebootRequired() != null && subPatchXml.getRebootRequired().trim().equalsIgnoreCase("true")) {
            subpatch.setRebootRequired(true);
        }
    }

    public static void setMetadata(Subpatch subPatchXml, GenericPatch subpatch) {
        BundleXmlUtilBase.setRebootRequired(subPatchXml, subpatch);
        subpatch.setScripts(subPatchXml.getScripts());
        subpatch.setOs(subPatchXml.getOs());
        subpatch.setAreRpmFilesPackaged(subPatchXml.getAreRpmFilesPackaged());
        subpatch.setDestinationRepoLocation(subPatchXml.getDestRepoLocation());
        if (PatchingTool.NONOPATCH.toString().equals(subpatch.getPatchTool())) {
            subpatch.setPatchTool(subPatchXml.getPatchingTool().toString());
        }
    }

    public void print(SystemPatchBundleXML top) {
        System.out.println(top.toString());
        System.out.println(" UniquePatchID=" + top.getUniquePatchID() + " PatchID=" + top.getPatchID() + " BundleType=" + (Object)((Object)top.getBundleType()) + " TypeVersion=" + top.getTypeVersion() + " PatchAbstract=" + top.getPatchAbstract());
        Automation auto = top.getAutomation();
        System.out.println("   automation: OplanVersion=" + auto.getOplanVersion() + " Hash=" + auto.getHash());
        fvalue f = top.getFvalue();
        System.out.println("   fvalue: MinOpatchVersion" + f.getMinOpatchVersion() + " Function=" + f.getFunction() + " Value=" + f.getValue());
        System.out.println("   system:" + this.targetTypetoString(top.getSystem()));
        System.out.println(this.scriptstoString(top.getScripts()));
        System.out.println("   subpatches:");
        for (Subpatch sub : top.getSubpatches()) {
            System.out.println(this.subpatchtoString(sub));
        }
    }

    public String scriptstoString(List<Script> scripts) {
        if (scripts == null || scripts.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer("Scripts: ");
        for (Script script : scripts) {
            sb.append(" Name= " + script.getName() + " Description= " + script.getDescription() + " Location= " + script.getLocation());
            if (script.getParams() != null) {
                for (Pair pair : script.getParams()) {
                    sb.append(" Param name= " + pair.getName() + " Param type= " + pair.getType());
                }
            }
            if (script.getTargetTypes() == null) continue;
            for (TargetType tt : script.getTargetTypes()) {
                sb.append(this.targetTypetoString(tt));
            }
        }
        return sb.toString();
    }

    public String targetTypetoString(TargetType tt) {
        StringBuffer sb = new StringBuffer("TargetType: type=").append((Object)tt.getType()).append(" version=").append(tt.getVersion()).append(" EM propery name=").append(tt.getPropertyName()).append(" EM property value=").append(tt.getPropertyValue()).append(this.productToString(tt.getProduct())).append(this.releaseToString(tt.getRelease()));
        if (tt instanceof SystemTargetType) {
            sb.append(" urm_component_id = ").append(((SystemTargetType)tt).getUrmComponentId());
        }
        return sb.toString();
    }

    public String productToString(Product product) {
        StringBuffer sb = new StringBuffer();
        sb.append(" Product").append(" name= ").append(product.getName()).append(" ARU ID= ").append(product.getAruID()).append(" QPart ID= ").append(product.getQpartID());
        return sb.toString();
    }

    public String releaseToString(Release release) {
        StringBuffer sb = new StringBuffer();
        sb.append(" Release").append(" name= ").append(release.getName()).append(" ARU ID= ").append(release.getAruID()).append(" URM ID= ").append(release.getUrmID());
        return sb.toString();
    }

    public String subpatchtoString(Subpatch sub) {
        StringBuffer sb = new StringBuffer("subpatch: Location=").append(sub.getLocation()).append(" patchID=").append(sub.getPatchID()).append(" PatchingTool=").append((Object)sub.getPatchingTool()).append(" PatchType=").append((Object)sub.getPatchType()).append(" Platform=").append(sub.getPlatform()).append(" Are rpm files packaged =").append(sub.getAreRpmFilesPackaged()).append(" getDestRepoLocation=").append(sub.getDestRepoLocation());
        Release releaseAfterPatching = sub.getReleaseAfterPatching();
        if (releaseAfterPatching != null) {
            System.out.println("   releaseAfterPatching=" + releaseAfterPatching.toString());
        }
        if (sub.getTargetTypes() != null) {
            for (TargetType tt : sub.getTargetTypes()) {
                sb.append("\n   ").append(this.targetTypetoString(tt));
            }
        }
        if (sub.getChannels() != null) {
            for (Channel channel : sub.getChannels()) {
                sb.append("\n   ").append(this.channelToString(channel));
            }
        }
        if (sub.getRpmFiles() != null) {
            for (RpmFile rpm : sub.getRpmFiles()) {
                sb.append("\n   ").append(this.rpmFiletoString(rpm));
            }
        }
        if (sub.getScripts() != null) {
            sb.append("\n   ").append(this.scriptstoString(sub.getScripts()));
        }
        if (sub.getOs() != null) {
            sb.append("\n   ").append(this.OStoString(sub.getOs()));
        }
        return sb.toString();
    }

    public String OStoString(OS os) {
        StringBuffer sb = new StringBuffer();
        sb.append(" OS ").append(" name= ").append(os.getName()).append(" version= ").append(os.getVersion()).append(" platform= ").append(os.getPlatform());
        return sb.toString();
    }

    public String channelToString(Channel channel) {
        StringBuffer sb = new StringBuffer();
        String isOptional = channel.getIsOptional() == null ? "" : channel.getIsOptional().toString();
        sb.append(" Channel ").append(" name= ").append(channel.getName()).append(" is optional= ").append(isOptional);
        if (channel.getAdvisories() != null) {
            sb.append(" Avisories:");
            for (Advisory advisory : channel.getAdvisories()) {
                sb.append(advisory.toString());
            }
        }
        if (channel.getExclusionList() != null) {
            sb.append("  exclusion list:");
            for (String exclude : channel.getExclusionList()) {
                sb.append(exclude.toString());
            }
        }
        return sb.toString();
    }

    public String rpmFiletoString(RpmFile rpm) {
        StringBuffer sb = new StringBuffer();
        sb.append(" RpmFile ").append(" name= ").append(rpm.getName()).append(" is optional= ").append(rpm.getIsOptional() == null ? " null " : rpm.getIsOptional().toString()).append(rpm.getAction() == null ? " no action " : " action=" + rpm.getAction().toString()).append(rpm.getSourceChannel() == null ? "no source channel" : " source channel=" + rpm.getSourceChannel().toString());
        return sb.toString();
    }
}

