/*
 * Decompiled with CFR 0.152.
 */
package dbmodel.util;

import dbmodel.bundle_xml.SystemPatchBundleXML;
import dbmodel.bundle_xml.TargetTypeOrder;
import dbmodel.patchmodel.DeployTargetOrder;
import dbmodel.patchmodel.EngineeredSystemPatch;
import dbmodel.util.BundleXmlUtilBase;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class BundleXmlUtil
extends BundleXmlUtilBase {
    public BundleXmlUtil() throws JAXBException, SAXException {
        logger = Logger.getLogger(this.getClass().getName());
        this.creatUnmarshaller();
    }

    private void creatUnmarshaller() throws JAXBException, SAXException {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(this.getClass().getResource("/" + xsdFileName));
        JAXBContext context = JAXBContext.newInstance((Class[])this.getClasses());
        this.unmarshaller = context.createUnmarshaller();
        this.unmarshaller.setSchema(schema);
    }

    public SystemPatchBundleXML readBundle(File xmlFile) throws JAXBException, SAXException {
        if (xmlFile == null) {
            throw new RuntimeException("xml file is null!");
        }
        xmlFileName = xmlFile.getAbsolutePath() + xmlFile.getName();
        return (SystemPatchBundleXML)this.unmarshaller.unmarshal(xmlFile);
    }

    public SystemPatchBundleXML readBundle(String xmlContent) throws JAXBException, SAXException {
        return (SystemPatchBundleXML)this.unmarshaller.unmarshal((Reader)new StringReader(xmlContent));
    }

    public SystemPatchBundleXML readBundle(InputStream xmlContent) throws JAXBException, SAXException {
        return (SystemPatchBundleXML)this.unmarshaller.unmarshal(xmlContent);
    }

    public static void populateDelpoyOrder(SystemPatchBundleXML esysBundle, EngineeredSystemPatch esysPatch) {
        List<TargetTypeOrder> orderxml;
        if (esysBundle.getIsDeployOrderRequired() != null && esysBundle.getIsDeployOrderRequired().trim().equalsIgnoreCase("true")) {
            esysPatch.setIsDeployOrderRequired(true);
        }
        if ((orderxml = esysBundle.getDeployorder()) != null && !orderxml.isEmpty()) {
            ArrayList<DeployTargetOrder> order = new ArrayList<DeployTargetOrder>();
            esysPatch.setDeployOrder(order);
            for (TargetTypeOrder ttxml : orderxml) {
                DeployTargetOrder tt = new DeployTargetOrder();
                order.add(tt);
                tt.setTargetType(ttxml.getType());
                tt.setVersion(ttxml.getVersion());
                tt.setOrder(ttxml.getOrder());
                tt.setPropertyName(ttxml.getPropertyName());
                tt.setPropertyValue(ttxml.getPropertyValue());
            }
        }
    }

    public static void main(String[] args) {
        try {
            BundleXmlUtil helper = new BundleXmlUtil();
            SystemPatchBundleXML obj = helper.readBundle(new File(xmlFileName));
            System.out.println("\n**********  BundleXmlUtil TESTING System Patch bundle xml V2: newly generated XSD (model/xml) with old test v2 XML  **************");
            helper.print(obj);
            System.out.println("**********************************************************\n");
        }
        catch (Throwable t) {
            System.out.println(" Exception = " + t.getMessage());
            t.printStackTrace();
        }
    }
}

