/*
 * Decompiled with CFR 0.152.
 */
package dbmodel.util;

import dbmodel.bundle_xml.SystemPatchBundleXML;
import dbmodel.util.BundleValidationException;
import dbmodel.util.BundleXmlException;
import dbmodel.util.BundleXmlUtilBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class BundleXmlHelper
extends BundleXmlUtilBase {
    public BundleXmlHelper() throws BundleXmlException {
        logger = Logger.getLogger(this.getClass().getName());
        this.creatUnmarshaller();
    }

    private void creatUnmarshaller() throws BundleXmlException {
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(this.getClass().getResource("/" + xsdFileName));
            JAXBContext context = JAXBContext.newInstance((Class[])this.getClasses());
            this.unmarshaller = context.createUnmarshaller();
            this.unmarshaller.setSchema(schema);
        }
        catch (JAXBException e) {
            String msg = "Failed to create JAXB context due to: " + BundleXmlHelper.digoutMessage(e);
            logger.log(Level.SEVERE, msg);
            throw new BundleXmlException(msg, e);
        }
        catch (SAXException e) {
            String msg = "The Bundle schema is invalid: " + BundleXmlHelper.digoutMessage(e);
            logger.log(Level.SEVERE, msg);
            throw new BundleXmlException(msg, e);
        }
    }

    public SystemPatchBundleXML readBundle(File xmlFile) throws BundleXmlException, BundleValidationException {
        if (xmlFile == null) {
            throw new BundleXmlException("xml file is null!");
        }
        xmlFileName = xmlFile.getAbsolutePath();
        try {
            return (SystemPatchBundleXML)this.unmarshaller.unmarshal((InputStream)new FileInputStream(xmlFileName));
        }
        catch (UnmarshalException e) {
            String msg = xmlFileName + " is not valid: " + BundleXmlHelper.digoutMessage(e) + " Schema is " + xsdFileName;
            logger.log(Level.SEVERE, msg);
            throw new BundleValidationException(msg, e);
        }
        catch (JAXBException e) {
            String msg = "Unexpected error " + BundleXmlHelper.digoutMessage(e) + " occured while unmarshalling " + xmlFileName;
            logger.log(Level.SEVERE, msg);
            throw new BundleXmlException(msg, e);
        }
        catch (FileNotFoundException e) {
            String msg = xmlFileName + " is not valid: " + BundleXmlHelper.digoutMessage(e) + " Schema is " + xsdFileName;
            logger.log(Level.SEVERE, msg);
            throw new BundleValidationException(msg, e);
        }
    }

    public SystemPatchBundleXML readBundle(String xmlContent) throws BundleValidationException, BundleXmlException {
        try {
            return (SystemPatchBundleXML)this.unmarshaller.unmarshal((Reader)new StringReader(xmlContent));
        }
        catch (UnmarshalException e) {
            String msg = " bundle.xml is not valid:" + BundleXmlHelper.digoutMessage(e) + ". xml is " + xmlContent + " Schema is " + xsdFileName;
            logger.log(Level.SEVERE, msg);
            throw new BundleValidationException(msg, e);
        }
        catch (JAXBException e) {
            String msg = "Unexpected error " + BundleXmlHelper.digoutMessage(e) + " occured while unmarshalling bundle.xml: " + xmlContent;
            logger.log(Level.SEVERE, msg);
            throw new BundleXmlException(msg, e);
        }
    }

    public SystemPatchBundleXML readBundle(InputStream xmlContent) throws BundleValidationException, BundleXmlException {
        try {
            return (SystemPatchBundleXML)this.unmarshaller.unmarshal(xmlContent);
        }
        catch (UnmarshalException e) {
            String msg = " bundle.xml is not valid:" + BundleXmlHelper.digoutMessage(e) + ". xml is " + xmlContent + " Schema is " + xsdFileName;
            logger.log(Level.SEVERE, msg);
            throw new BundleValidationException(msg, e);
        }
        catch (JAXBException e) {
            String msg = "Unexpected error " + BundleXmlHelper.digoutMessage(e) + " occured while unmarshalling bundle.xml: " + xmlContent;
            logger.log(Level.SEVERE, msg);
            throw new BundleXmlException(msg, e);
        }
    }

    public static void main(String[] args) {
        try {
            BundleXmlHelper helper = new BundleXmlHelper();
            SystemPatchBundleXML obj = helper.readBundle(new File(xmlFileName));
            System.out.println("\n**********  BundleXmlHelper: TESTING System Patch bundle xml: newly generated XSD (model/xml) with old test XML  **************");
            helper.print(obj);
            System.out.println("**********************************************************\n");
            System.out.println("\n**********  BundleXmlHelper: TESTING System Patch bundle V3 xml: newly generated XSD (model/xml) with old test v3 XML  **************");
            SystemPatchBundleXML bundleV3 = helper.readBundle(new File(xmlV3FileName));
            helper.print(bundleV3);
            System.out.println("**********************************************************\n");
        }
        catch (Throwable t) {
            System.out.println(" Exception = " + t.getMessage());
            t.printStackTrace();
        }
    }

    static String digoutMessage(Throwable t) {
        if (t.getMessage() != null && t.getMessage().trim().length() != 0) {
            return t.getMessage();
        }
        Throwable cause = t.getCause();
        if (cause == null) {
            return null;
        }
        return BundleXmlHelper.digoutMessage(cause);
    }
}

