/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class XorOutputStream
extends FilterOutputStream {
    private byte _mask = 0;

    public XorOutputStream(OutputStream out, byte mask) {
        super(out);
        this._mask = mask;
    }

    @Override
    public void write(int output) throws IOException {
        if (output < 0) {
            this.out.write(output);
        } else {
            this.out.write((byte)output ^ this._mask);
        }
    }

    @Override
    public void write(byte[] output, int offset, int length) throws IOException {
        byte[] coded = new byte[length];
        for (int i = 0; i < length; ++i) {
            coded[i] = (byte)(output[offset + i] ^ this._mask);
        }
        this.out.write(coded);
    }
}

