/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class RandomStringGenerator {
    private final List _charList = Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "1", "2", "3", "4", "5", "6", "7", "8", "9");
    private Random _random = new Random();
    private StringBuffer _sb = new StringBuffer();
    private int _charPoolSize = 34;

    public RandomStringGenerator() {
    }

    public RandomStringGenerator(int charPoolSize) {
        if (charPoolSize > 34 || charPoolSize < 1) {
            throw new IllegalArgumentException("Character pool size must be between 1 and 36 inclusive!");
        }
        this._charPoolSize = charPoolSize;
    }

    public String generate(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Generation string length must be greater than zero!");
        }
        this._sb.setLength(0);
        for (int i = 0; i < length; ++i) {
            this._sb.append(this._charList.get(this._random.nextInt(this._charPoolSize)));
        }
        return this._sb.toString();
    }

    public String syncGenerate(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Generation string length must be greater than zero!");
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            sb.append(this._charList.get(this._random.nextInt(this._charPoolSize)));
        }
        return sb.toString();
    }
}

