/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.common.util.ObjectStoreManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

public class ObjectStoreHelper {
    public static final String EXTENDED_LOGGING = "objectStore.extended.logging";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProperties(String namespace, String propertiesFile) throws IOException {
        if (namespace == null || "".equals(namespace)) {
            throw new IllegalArgumentException("namespace must be non-null!");
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(propertiesFile);
            ObjectStoreHelper.loadProperties(namespace, is);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProperties(String namespace, String propertiesFile, ClassLoader loader) throws IOException {
        if (namespace == null || "".equals(namespace)) {
            throw new IllegalArgumentException("namespace must be non-null!");
        }
        InputStream is = null;
        try {
            is = loader.getResourceAsStream(propertiesFile);
            ObjectStoreHelper.loadProperties(namespace, is);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void loadProperties(String namespace, InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        ObjectStoreManager.getObjectStore(namespace).storeAll(props);
    }

    public static void addKeyGroup(String namespace, String keyGroup) {
        if (namespace == null || "".equals(namespace)) {
            throw new IllegalArgumentException("namespace must be non-null!");
        }
        if (keyGroup == null || "".equals(keyGroup)) {
            throw new IllegalArgumentException("key group name must be non-null!");
        }
        IObjectStore os = ObjectStoreManager.getObjectStore(namespace);
        HashSet kg = (HashSet)os.retrieveObject(keyGroup);
        if (kg == null) {
            kg = new HashSet();
            os.storeObject(keyGroup, kg);
        }
    }

    public static void removeKeyGroup(String namespace, String keyGroup) {
        if (namespace == null || "".equals(namespace)) {
            throw new IllegalArgumentException("namespace must be non-null!");
        }
        if (keyGroup == null || "".equals(keyGroup)) {
            throw new IllegalArgumentException("key group name must be non-null!");
        }
        ObjectStoreManager.getObjectStore(namespace).removeObject(keyGroup);
    }

    public static void clearKeyGroup(String namespace, String keyGroup) {
        if (namespace == null || "".equals(namespace)) {
            throw new IllegalArgumentException("namespace must be non-null!");
        }
        if (keyGroup == null || "".equals(keyGroup)) {
            throw new IllegalArgumentException("key group name must be non-null!");
        }
        IObjectStore os = ObjectStoreManager.getObjectStore(namespace);
        Collection kg = (Collection)os.retrieveObject(keyGroup);
        if (kg != null) {
            Iterator it = kg.iterator();
            while (it.hasNext()) {
                os.removeObject(it.next());
            }
            ObjectStoreHelper.removeKeyGroup(namespace, keyGroup);
        }
    }

    public static void registerKeyGroupKey(String namespace, String keyGroup, String key) {
        if (namespace == null || "".equals(namespace)) {
            throw new IllegalArgumentException("namespace must be non-null!");
        }
        if (keyGroup == null || "".equals(keyGroup)) {
            throw new IllegalArgumentException("key group name must be non-null!");
        }
        if (key == null || "".equals(key)) {
            throw new IllegalArgumentException("key must be non-null!");
        }
        IObjectStore os = ObjectStoreManager.getObjectStore(namespace);
        Collection kg = (Collection)os.retrieveObject(keyGroup);
        kg.add(key);
    }
}

