/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Delete {
    private static int _time = 10;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java Delete <full_path_to_file_or_dir> -soft <time> -list <list_of_filenames> -preserve");
            System.out.println("This program will attempt to recursively delete the\n\tspecified file\\dir every 2 seconds for \"<time>\" seconds(10=default).");
            System.out.println("If the -soft flag is set it will only attempt a recursive\n\tdelete of the file\\dir ");
            System.out.println("If the -list flag is set a comma seperated list of files\n\tin the specified directory to delete must follow.");
            System.out.println("The -preserve is only used in conjunction with -list.\n\tIf set it will not attempt to delete the directory after the list of files.");
            return;
        }
        File file = new File(args[0]);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!file.exists()) {
            file.delete();
            return;
        }
        boolean soft = false;
        boolean list = false;
        boolean preserve = false;
        ArrayList<String> filenames = new ArrayList<String>();
        for (int x = 1; x < args.length; ++x) {
            if (args[x].equals("-soft")) {
                soft = true;
                continue;
            }
            if (args[x].equals("-list")) {
                list = true;
                if (args.length < x + 2) {
                    System.out.println("List of files not specified.");
                    return;
                }
                StringTokenizer toke = new StringTokenizer(args[++x], ",");
                while (toke.hasMoreTokens()) {
                    filenames.add(toke.nextToken());
                }
                continue;
            }
            if (args[x].equals("-preserve")) {
                preserve = true;
                continue;
            }
            try {
                _time = Integer.parseInt(args[x]);
                continue;
            }
            catch (NumberFormatException toke) {
                // empty catch block
            }
        }
        int time = 0;
        while (time < _time * 1000) {
            if (list) {
                if (!preserve && filenames.isEmpty()) {
                    file.delete();
                } else {
                    Iterator it = filenames.iterator();
                    while (it.hasNext()) {
                        File filename = new File(file, (String)it.next());
                        try {
                            filename = filename.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (soft) {
                            if (!filename.delete()) {
                                filename.deleteOnExit();
                            }
                        } else {
                            Delete.delete(filename);
                        }
                        if (filename.exists()) continue;
                        it.remove();
                    }
                }
            } else if (soft) {
                file.delete();
            } else {
                Delete.delete(file);
            }
            if (file.exists()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                time += 2000;
                continue;
            }
            time = _time * 1000;
        }
        if (!list && !preserve && file.exists() && !file.delete()) {
            file.deleteOnExit();
        }
    }

    public static boolean delete(File file) {
        return Delete.delete(file, null);
    }

    public static boolean delete(File file, boolean deleteOnExit) {
        return Delete.delete(file, null, deleteOnExit);
    }

    public static boolean delete(File file, FileFilter filter) {
        return Delete.delete(file, filter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(File file, FileFilter filter, boolean deleteOnExit) {
        File file2 = file;
        synchronized (file2) {
            if (file != null) {
                File[] files;
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!file.exists()) {
                    return file.delete();
                }
                if (file.isDirectory() && (files = file.listFiles(filter)) != null && files.length > 0) {
                    for (File file1 : files) {
                        Delete.delete(file1, filter, deleteOnExit);
                    }
                }
                if (!file.delete()) {
                    if (deleteOnExit) {
                        file.deleteOnExit();
                    }
                    return false;
                }
            }
        }
        return true;
    }
}

