/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.Wildcard;
import java.util.ArrayList;
import java.util.List;

public class ArchiveIncludeExclude {
    List<ArchiveIncludeExclude> _inners;
    protected String _regex;
    protected String _wildcard;
    protected String _dest;
    protected boolean _destSet;
    protected boolean _regexSet;
    protected boolean _wildcardSet;
    protected Wildcard _wildcardObj;

    public ArchiveIncludeExclude(String dest, String regex, String wildcard) {
        this._dest = dest;
        this._destSet = !StringUtil.isNullOrEmpty(this._dest, true);
        this._regex = regex;
        this._regexSet = !StringUtil.isNullOrEmpty(this._regex, true);
        this._wildcard = wildcard;
        this._wildcardSet = !StringUtil.isNullOrEmpty(this._wildcard, true);
    }

    public void setInners(List<ArchiveIncludeExclude> inners) {
        this._inners = inners;
    }

    public List<ArchiveIncludeExclude> getInners() {
        return this._inners;
    }

    public String getRegex() {
        return this._regex;
    }

    public void setRegex(String regex) {
        this._regex = regex;
        this._regexSet = !StringUtil.isNullOrEmpty(this._regex, true);
    }

    public String getWildcard() {
        return this._wildcard;
    }

    public void setWildcard(String wildcard) {
        this._wildcard = wildcard;
        this._wildcardSet = !StringUtil.isNullOrEmpty(this._wildcard, true);
    }

    public String getDest() {
        return this._dest;
    }

    public void setDest(String dest) {
        this._dest = dest;
        this._destSet = !StringUtil.isNullOrEmpty(this._dest, true);
    }

    public boolean matches(String value) {
        if (value == null) {
            return false;
        }
        if (this._destSet) {
            return value.equals(this.getDest());
        }
        if (this._regexSet) {
            return value.matches(this.getRegex().trim());
        }
        if (this._wildcardSet) {
            if (this._wildcardObj == null) {
                this._wildcardObj = new Wildcard(this.getWildcard());
            }
            return this._wildcardObj.matches(value);
        }
        return false;
    }

    public boolean isEmpty() {
        return StringUtil.isNullOrEmpty(this.getDest(), true) && StringUtil.isNullOrEmpty(this.getWildcard(), true) && StringUtil.isNullOrEmpty(this.getRegex(), true);
    }

    public int hashCode() {
        String name = this.getDest();
        String wildcard = this.getWildcard();
        String regex = this.getRegex();
        int result = regex != null ? regex.hashCode() : 0;
        result = 31 * result + (wildcard != null ? wildcard.hashCode() : 0);
        result = 31 * result + (name != null ? name.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !o.getClass().isAssignableFrom(this.getClass())) {
            return false;
        }
        ArchiveIncludeExclude baseSelect = (ArchiveIncludeExclude)o;
        String name = this.getDest();
        String theirName = baseSelect.getDest();
        String wildcard = this.getWildcard();
        String theirWildcard = baseSelect.getWildcard();
        String regex = this.getRegex();
        String theirRegex = baseSelect.getRegex();
        if (name != null && theirName != null && !name.equals(theirName)) {
            return false;
        }
        if (wildcard != null && theirWildcard != null && !wildcard.equals(theirWildcard)) {
            return false;
        }
        return regex == null || theirRegex == null || regex.equals(theirRegex);
    }

    public void add(ArchiveIncludeExclude inner) {
        if (this._inners == null) {
            this._inners = new ArrayList<ArchiveIncludeExclude>();
        }
        this._inners.add(inner);
    }

    public void add(List<ArchiveIncludeExclude> inner) {
        if (this._inners == null) {
            this._inners = new ArrayList<ArchiveIncludeExclude>();
        }
        this._inners.addAll(inner);
    }

    public String toString() {
        String name = StringUtil.isNullOrEmpty(this.getDest()) ? "" : this.getDest();
        String wildcard = StringUtil.isNullOrEmpty(this.getWildcard()) ? "" : this.getWildcard();
        String regex = StringUtil.isNullOrEmpty(this.getRegex()) ? "" : this.getRegex();
        return name + " " + wildcard + regex;
    }
}

