/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.comdev;

import com.oracle.cie.common.comdev.AbstractGraph;
import com.oracle.cie.common.comdev.Edge;
import com.oracle.cie.common.comdev.EmptyIterator;
import com.oracle.cie.common.comdev.Vertex;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AdjacencyListGraph
extends AbstractGraph {
    private boolean _isDirected;
    protected IdentityHashMap _adjacencyMap;
    private LinkedList _edges;

    public AdjacencyListGraph(boolean isDirected) {
        this._isDirected = isDirected;
        this._adjacencyMap = new IdentityHashMap();
        this._edges = new LinkedList();
    }

    @Override
    public Vertex insertVertex(Object key) {
        AbstractGraph.GraphVertex v = new AbstractGraph.GraphVertex(this, key);
        this._adjacencyMap.put(v, null);
        return v;
    }

    @Override
    public Vertex attachVertex(Vertex v0, Object vertexKey, Object edgeKey) {
        if (this.isDirected()) {
            throw new UnsupportedOperationException("not supported in DAG");
        }
        if (!this._adjacencyMap.containsKey(v0)) {
            return null;
        }
        LinkedList<Vertex> l = (LinkedList<Vertex>)this._adjacencyMap.get(v0);
        if (l == null) {
            l = new LinkedList<Vertex>();
            this._adjacencyMap.put(v0, l);
        }
        AbstractGraph.GraphVertex v1 = new AbstractGraph.GraphVertex(this, vertexKey);
        l.addLast(v1);
        l = new LinkedList();
        l.addLast(v0);
        this._adjacencyMap.put(v1, l);
        AbstractGraph.GraphEdge e = new AbstractGraph.GraphEdge(this, v0, v1, edgeKey);
        this._edges.addLast(e);
        return v1;
    }

    @Override
    public Vertex attachVertexFrom(Vertex origin, Object vertexKey, Object edgeKey) {
        if (!this.isDirected()) {
            throw new UnsupportedOperationException("only supported in DAG");
        }
        LinkedList<AbstractGraph.GraphVertex> l = (LinkedList<AbstractGraph.GraphVertex>)this._adjacencyMap.get(origin);
        if (l == null) {
            l = new LinkedList<AbstractGraph.GraphVertex>();
            this._adjacencyMap.put(origin, l);
        }
        AbstractGraph.GraphVertex dest = new AbstractGraph.GraphVertex(this, vertexKey);
        l.addLast(dest);
        this._adjacencyMap.put(dest, null);
        AbstractGraph.GraphEdge e = new AbstractGraph.GraphEdge(this, origin, dest, edgeKey);
        this._edges.addLast(e);
        return dest;
    }

    @Override
    public Vertex attachVertexTo(Vertex dest, Object vertexKey, Object edgeKey) {
        if (!this.isDirected()) {
            throw new UnsupportedOperationException("only supported in DAG");
        }
        AbstractGraph.GraphVertex origin = new AbstractGraph.GraphVertex(this, vertexKey);
        LinkedList<Vertex> l = new LinkedList<Vertex>();
        l.addLast(dest);
        this._adjacencyMap.put(origin, l);
        AbstractGraph.GraphEdge e = new AbstractGraph.GraphEdge(this, origin, dest, edgeKey);
        this._edges.addLast(e);
        return origin;
    }

    @Override
    public Edge insertEdge(Vertex v0, Vertex v1, Object key) {
        if (this.isDirected()) {
            throw new UnsupportedOperationException("not supported in DAG");
        }
        LinkedList<Vertex> l = (LinkedList<Vertex>)this._adjacencyMap.get(v0);
        if (l == null) {
            l = new LinkedList<Vertex>();
            this._adjacencyMap.put(v0, l);
        }
        l.addLast(v1);
        l = (LinkedList<Vertex>)this._adjacencyMap.get(v1);
        if (l == null) {
            l = new LinkedList<Vertex>();
            this._adjacencyMap.put(v1, l);
        }
        l.addLast(v0);
        AbstractGraph.GraphEdge e = new AbstractGraph.GraphEdge(this, v0, v1, key);
        this._edges.addLast(e);
        return e;
    }

    @Override
    public Edge insertDirectedEdge(Vertex origin, Vertex dest, Object key) {
        if (!this.isDirected()) {
            throw new UnsupportedOperationException("only supported in DAG");
        }
        LinkedList<Vertex> l = (LinkedList<Vertex>)this._adjacencyMap.get(origin);
        if (l == null) {
            l = new LinkedList<Vertex>();
            this._adjacencyMap.put(origin, l);
        }
        l.addLast(dest);
        AbstractGraph.GraphEdge e = new AbstractGraph.GraphEdge(this, origin, dest, key);
        this._edges.addLast(e);
        return e;
    }

    @Override
    public Object removeVertex(Vertex v) {
        if (!this._adjacencyMap.containsKey(v)) {
            return null;
        }
        this._adjacencyMap.remove(v);
        LinkedList<Edge> newList = new LinkedList<Edge>();
        for (Edge e : this._edges) {
            if (this.isDirected()) {
                if (e.getV1() == v) {
                    LinkedList l = (LinkedList)this._adjacencyMap.get(e.getV0());
                    l.remove(v);
                    continue;
                }
                if (e.getV0() == v) continue;
                newList.addLast(e);
                continue;
            }
            Vertex m = e.getMate(v);
            if (m != null) {
                LinkedList l = (LinkedList)this._adjacencyMap.get(m);
                l.remove(v);
                continue;
            }
            newList.addLast(e);
        }
        this._edges = null;
        this._edges = newList;
        return v.getKey();
    }

    @Override
    public Object removeEdge(Edge e) {
        if (!this._edges.remove(e)) {
            return null;
        }
        LinkedList l = (LinkedList)this._adjacencyMap.get(e.getV0());
        l.remove(e.getV1());
        if (!this.isDirected()) {
            l = (LinkedList)this._adjacencyMap.get(e.getV1());
            l.remove(e.getV0());
        }
        return e.getKey();
    }

    public Object removeEdge(Vertex origin, Vertex dest, Object key) {
        AbstractGraph.GraphEdge e = new AbstractGraph.GraphEdge(this, origin, dest, key);
        if (!this._edges.remove(e)) {
            return null;
        }
        LinkedList l = (LinkedList)this._adjacencyMap.get(e.getV0());
        l.remove(e.getV1());
        if (!this.isDirected()) {
            l = (LinkedList)this._adjacencyMap.get(e.getV1());
            l.remove(e.getV0());
        }
        return e.getKey();
    }

    @Override
    public Iterator getIncomingEdges(Vertex v) {
        ArrayList<Edge> col = new ArrayList<Edge>();
        Iterator it = this.getEdges();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            if (this.isDirected()) {
                if (e.getV1() != v) continue;
                col.add(e);
                continue;
            }
            if (e.getV0() != v && e.getV1() != v) continue;
            col.add(e);
        }
        return col.iterator();
    }

    @Override
    public Iterator getOutgoingEdges(Vertex v) {
        ArrayList<Edge> col = new ArrayList<Edge>();
        Iterator it = this.getEdges();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            if (this.isDirected()) {
                if (e.getV0() != v) continue;
                col.add(e);
                continue;
            }
            if (e.getV0() != v && e.getV1() != v) continue;
            col.add(e);
        }
        return col.iterator();
    }

    @Override
    public Iterator getIncomingVertices(Vertex v) {
        if (!this.isDirected()) {
            return this.getOutgoingVertices(v);
        }
        ArrayList<Vertex> col = new ArrayList<Vertex>();
        for (Edge e : this._edges) {
            if (e.getV1() != v) continue;
            col.add(e.getV0());
        }
        return col.iterator();
    }

    public List getIncomingVertexList(Vertex v) {
        if (!this.isDirected()) {
            return this.getOutgoingVertexList(v);
        }
        ArrayList<Vertex> col = new ArrayList<Vertex>();
        for (Edge e : this._edges) {
            if (e.getV1() != v) continue;
            col.add(e.getV0());
        }
        return col;
    }

    @Override
    public Iterator getOutgoingVertices(Vertex v) {
        LinkedList l = (LinkedList)this._adjacencyMap.get(v);
        return l == null ? EmptyIterator.getInstance() : l.iterator();
    }

    public List getOutgoingVertexList(Vertex v) {
        LinkedList l = (LinkedList)this._adjacencyMap.get(v);
        return l == null ? new LinkedList() : l;
    }

    @Override
    public int getNumberOfEdges() {
        return this._edges.size();
    }

    @Override
    public int getNumberOfVertices() {
        return this._adjacencyMap.size();
    }

    @Override
    public Vertex getVertex(Object key) {
        Iterator it = this.getVertices();
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            if (!v.getKey().equals(key)) continue;
            return v;
        }
        return null;
    }

    @Override
    public Edge getEdge(Object key) {
        Iterator it = this.getEdges();
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            if (!e.getKey().equals(key)) continue;
            return e;
        }
        return null;
    }

    @Override
    public Iterator getVertices() {
        return this._adjacencyMap.keySet().iterator();
    }

    public Set getVertexSet() {
        return this._adjacencyMap.keySet();
    }

    @Override
    public Iterator getEdges() {
        return this._edges.iterator();
    }

    @Override
    public boolean isDirected() {
        return this._isDirected;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Adacency List Graph\n");
        Iterator it = this.getVertices();
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            LinkedList l = (LinkedList)this._adjacencyMap.get(v);
            sb.append("\t").append(v).append(" = {");
            if (l == null) {
                sb.append("null");
            } else {
                Iterator it2 = l.iterator();
                while (it2.hasNext()) {
                    sb.append(it2.next()).append(", ");
                }
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

