/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common;

import com.oracle.cie.common.XPathProcessorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XPathProcessor {
    private DocumentBuilder parser = null;
    private Document doc = null;
    private String _xmlFileName = null;
    protected static transient Logger s_logger = Logger.getLogger(XPathProcessor.class.getName());

    public XPathProcessor(String xmlFileName) throws XPathProcessorException {
        if (xmlFileName == null) {
            throw new IllegalArgumentException("A filename must be provided!");
        }
        this._xmlFileName = xmlFileName;
        try {
            s_logger.fine("The file name processing is -" + this._xmlFileName);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.parser = dbf.newDocumentBuilder();
            this.parser.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            this.doc = this.parser.parse(this._xmlFileName);
        }
        catch (Exception x) {
            throw new XPathProcessorException("Unable to create xml parser", x);
        }
    }

    public XPathProcessor(InputStream is) throws XPathProcessorException {
        if (is == null) {
            throw new IllegalArgumentException("A file input stream must be provided!");
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.parser = dbf.newDocumentBuilder();
            this.parser.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            this.doc = this.parser.parse(is);
        }
        catch (Exception x) {
            throw new XPathProcessorException("Unable to create xml parser", x);
        }
    }

    public XPathProcessor(Document document) throws XPathProcessorException {
        if (document == null) {
            throw new IllegalArgumentException("The Document provided to the Xpath processor should be valid.");
        }
        this.doc = document;
    }

    public Object evaluateXPath(String rootElement, String xpathExp) {
        return this.evaluateXPath(rootElement, xpathExp, null, null);
    }

    public Object evaluateXPath(String rootElement, String xpathExp, String nameSpace, String prefix) {
        if (xpathExp != null) {
            try {
                NodeList nodes = (NodeList)this.getNodeListforXPath(rootElement, xpathExp, nameSpace, prefix);
                if (nodes != null) {
                    String[] array = new String[nodes.getLength()];
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node node = nodes.item(i).getFirstChild();
                        array[i] = node != null && node.getNodeType() == 3 ? node.getNodeValue() : nodes.item(i).getNodeValue();
                    }
                    if (array.length == 0) {
                        return null;
                    }
                    return array.length == 1 ? array[0] : array;
                }
            }
            catch (Exception e) {
                s_logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return null;
    }

    public void substituteXPath(String rootElement, String xpathExp, String value) {
        this.substituteXPath(rootElement, xpathExp, value, null, null);
    }

    public void substituteXPath(String rootElement, String xpathExp, String value, String nameSpace, String prefix) {
        if (xpathExp != null) {
            try {
                NodeList nodes = (NodeList)this.getNodeListforXPath(rootElement, xpathExp, nameSpace, prefix);
                if (nodes != null) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node node = nodes.item(i);
                        if (node.getNodeType() == 3) {
                            node.setNodeValue(value);
                            continue;
                        }
                        if (node.getFirstChild() != null) {
                            if (node.getFirstChild().getNodeType() != 3) continue;
                            node.getFirstChild().setNodeValue(value);
                            continue;
                        }
                        Text txtNode = this.doc.createTextNode(value);
                        node.appendChild(txtNode);
                    }
                }
            }
            catch (Exception e) {
                s_logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private Object getNodeListforXPath(String rootElement, String xpathExp, String nameSpace, String prefix) {
        try {
            String nsXpath = xpathExp.trim();
            XPath xpath = XPathFactory.newInstance().newXPath();
            if (nameSpace != null && !nameSpace.equals("") && prefix != null && !prefix.equals("")) {
                xpath.setNamespaceContext(new SimpleNamespaceContext(nameSpace, prefix));
            }
            XPathExpression expr = xpath.compile(nsXpath);
            Object result = null;
            if (rootElement != null) {
                NodeList nodes = this.doc.getElementsByTagName(rootElement);
                result = expr.evaluate(nodes.item(0), XPathConstants.NODESET);
            } else {
                result = expr.evaluate(this.doc, XPathConstants.NODESET);
            }
            return result;
        }
        catch (Exception ex) {
            s_logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    public void transformFile() throws TransformerException {
        this.transformXMLFile(new StreamResult(this._xmlFileName));
    }

    public void transformFile(OutputStream os) throws TransformerException {
        this.transformXMLFile(new StreamResult(os));
    }

    private void transformXMLFile(StreamResult result) throws TransformerException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.doc);
            transformer.setOutputProperty("indent", "yes");
            DocumentType doctype = this.doc.getDoctype();
            if (doctype != null) {
                if (doctype.getPublicId() != null) {
                    transformer.setOutputProperty("doctype-public", doctype.getPublicId());
                }
                if (doctype.getSystemId() != null) {
                    transformer.setOutputProperty("doctype-system", doctype.getSystemId());
                }
            }
            transformer.transform(source, result);
        }
        catch (TransformerException te) {
            throw new TransformerException("Unable to transform xml file", te);
        }
    }

    public class SimpleNamespaceContext
    implements NamespaceContext {
        private String _namespace;
        private String _prefix;

        public SimpleNamespaceContext(String namespace, String prefix) {
            this._namespace = namespace;
            this._prefix = prefix;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals(this._prefix)) {
                return this._namespace;
            }
            return "";
        }

        @Override
        public String getPrefix(String namespaceURI) {
            if (namespaceURI.equals(this._namespace)) {
                return this._prefix;
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            ArrayList<String> list = new ArrayList<String>();
            if (namespaceURI.equals(this._namespace)) {
                list.add(this._prefix);
            }
            return list.iterator();
        }
    }
}

