/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.action;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.CommonPatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionResultData;
import com.oracle.glcm.patch.auto.action.PatchReportResultData;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.product.ProductSupportManager;
import com.oracle.glcm.patch.auto.report.OPatchAutoReporting;
import com.oracle.glcm.patch.auto.report.OPatchAutoReportingManager;
import com.oracle.glcm.patch.auto.report.ReportingData;
import com.oracle.glcm.patch.auto.report.patches.PatchLevel;
import com.oracle.glcm.patch.auto.report.patches.PatchReportingData;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import oracle.opatchauto.core.binary.OPatchAutoBinary;
import oracle.opatchauto.core.binary.OPatchPatchInfo;
import oracle.opatchauto.core.binary.OracleTarget;
import oracle.opatchauto.core.binary.PatchLevelReportSessionResult;
import oracle.opatchauto.core.binary.PatchingSessionOptions;

public class PatchReportAction
extends CommonPatchAction {
    public PatchReportAction() {
        super(new Goal[]{InitPhase.Goal.init});
    }

    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = false;
        try {
            if (this.getPatchSession().getCommand().isReport() && this.getPatchSession().getOptions().getOption("type").getValue().equals("patches")) {
                isActionRequired = true;
            }
        }
        catch (OPatchAutoException e) {
            this._logger.log(Level.SEVERE, "check failed", e);
        }
        return isActionRequired;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public PatchActionResult execute(PatchTarget patchTarget) {
        String oracleHomePath = patchTarget.getHome().getLocation();
        PatchActionResult patchActionResult = null;
        try {
            OracleTarget ot = new OracleTarget(oracleHomePath);
            PatchingSessionOptions options = new PatchingSessionOptions(ot);
            OPatchAutoBinary binaryPatching = new OPatchAutoBinary(options);
            PatchLevelReportSessionResult result = (PatchLevelReportSessionResult)binaryPatching.getHomePatchLevels();
            PatchReportResultData resultData = new PatchReportResultData();
            resultData.setResult(result);
            patchActionResult = new PatchActionResult();
            patchActionResult.setResultData((PatchActionResultData)resultData);
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, "Patch reporting failed.", e);
            patchActionResult = new PatchActionResult((Throwable)e);
        }
        return patchActionResult;
    }

    public Set<String> getSupportedProductTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(ProductSupportManager.getDefaultProductType().getType());
        return types;
    }

    public void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult) throws OPatchAutoException {
        if (!this.getPatchSession().isActionSession()) {
            List patchInfo = ((PatchReportResultData)patchActionResult.getTypedResultData(PatchReportResultData.class)).getResult().getHomePatchLevel();
            ArrayList<PatchLevel> patchLevelList = new ArrayList<PatchLevel>();
            for (OPatchPatchInfo info : patchInfo) {
                patchLevelList.add(new PatchLevel(Integer.valueOf(info.getPatchID()).intValue(), Integer.valueOf(info.getUniquePatchID()).intValue(), Boolean.valueOf(info.isSQLPatch()).booleanValue()));
            }
            OPatchAutoReporting reportingHandler = OPatchAutoReportingManager.getInstance().getReportingHandler("patches");
            PatchReportingData data = new PatchReportingData();
            data.getReportingData().addAll(patchLevelList);
            reportingHandler.store(patchTarget, (ReportingData)data);
        }
    }
}

