/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.cie.remote.RemoteConnectionHost;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.action.CommonPatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.product.ProductSupport;
import com.oracle.glcm.patch.auto.product.ProductSupportManager;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;

public class ImageHomePatchAction
extends CommonPatchAction {
    private String _remoteImageLocation;

    public ImageHomePatchAction() {
        super(new Goal[]{OfflinePhase.Goal.finalize_binary_patching});
    }

    public Set<String> getSupportedProductTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(ProductSupportManager.getDefaultProductType().getType());
        return types;
    }

    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        return this.getPatchSession().isCreateImageEnabled();
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public PatchActionResult execute(PatchTarget patchTarget) {
        try {
            ProductSupport productSupport = this.getPatchSession().getProductSupportManager().getHomeCloningProductSupport(patchTarget);
            if (productSupport == null) {
                throw new PatchActionException("70014", new Object[]{patchTarget.getHome().getLocation()});
            }
            File sourceHome = new File(patchTarget.getHome().getLocation());
            String imageFilePath = this.getPatchSession().getImageLocation();
            if (StringUtil.isNullOrEmpty((String)imageFilePath, (boolean)true)) {
                throw new OPatchAutoException("70015", new Object[0]);
            }
            File imageFile = new File(imageFilePath);
            productSupport.imageHome(sourceHome, imageFile, patchTarget.getHome().getInvPtrLoc());
            patchTarget.setUsingHomeClone(false);
            if (this.getPatchSession().isOutOfPlacePatchingEnabled()) {
                productSupport.clearClonedHome(sourceHome);
            }
            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"ImageHomePatchAction.created.home.image", (Object[])new Object[]{imageFile}));
        }
        catch (Exception e) {
            return new PatchActionResult((Throwable)e);
        }
        return new PatchActionResult();
    }

    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        String opatchAutoTmp = container.getTempLocation();
        File localImageLocation = new File(this.getPatchSession().getImageLocation());
        this._remoteImageLocation = opatchAutoTmp + "/" + localImageLocation.getName();
        container.addPatchActionParameter("image.location", (Object)this._remoteImageLocation);
    }

    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        String imageLocation = (String)container.getPatchActionParameterValue("image.location");
        if (StringUtil.isNullOrEmpty((String)imageLocation, (boolean)true)) {
            throw new PatchActionException("70016", new Object[0]);
        }
        patchSession.setImageLocation(imageLocation);
    }

    public void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult) throws OPatchAutoException {
        if (patchActionResult.isSuccess() && patchTarget.isRemote()) {
            try {
                RemoteConnectionHandler handler = OPatchAutoHelper.getRemoteConnectionManager().getRemoteConnectionHandler((RemoteConnectionHost)patchTarget.getHost());
                Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"ImageHomePatchAction.retrieving.remote.image", (Object[])new Object[]{patchTarget.getHost().getHost(), this.getPatchSession().getImageLocation()}));
                handler.get(this._remoteImageLocation, new File(this.getPatchSession().getImageLocation()));
                handler.delete(this._remoteImageLocation);
            }
            catch (RemoteConnectionException e) {
                throw new OPatchAutoException("70017", new Object[]{patchTarget.getHost().getHost(), this.getPatchSession().getImageLocation()});
            }
        }
    }
}

