/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.CommonPatchAction;
import com.oracle.glcm.patch.auto.action.OPatchautoActionUtils;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.product.ProductSupport;
import com.oracle.glcm.patch.auto.product.ProductSupportManager;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import oracle.opatch.opatchsdk.OPatchContext;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatchauto.core.binary.OPatchAutoBinary;
import oracle.opatchauto.core.binary.OracleTarget;
import oracle.opatchauto.core.binary.PatchResult;
import oracle.opatchauto.core.binary.PatchingSessionOptions;
import oracle.opatchauto.core.binary.SessionPatches;
import oracle.opatchauto.core.binary.SessionResults;

public class BinaryPatchAction
extends CommonPatchAction {
    public BinaryPatchAction() {
        super(new Goal[]{OfflinePhase.Goal.binary_patching});
    }

    public Set<String> getSupportedProductTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(ProductSupportManager.getDefaultProductType().getType());
        return types;
    }

    public void updateOptions(OPatchAutoOptions options, Set<Goal> goals) throws OPatchAutoException {
        OPatchAutoOption applyImageOption = options.getOption("apply.image");
        if (applyImageOption.hasValue() && Boolean.parseBoolean(applyImageOption.getValue())) {
            OPatchAutoOption imageLocationOption = options.getOption("image.location");
            imageLocationOption.setRequired(true);
        }
    }

    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        if (this.getPatchSession().isApplyImageEnabled()) {
            return true;
        }
        return this.getPatchSession().getPatchLocation() != null || this.getPatchSession().getPatchBaseDirectory() != null || this.getPatchSession().getPatchId() != null;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    public boolean isAnalyzeSupported() {
        return true;
    }

    public String getDisplayName() {
        return OPatchAutoHelper.getLocalizedString((String)"BinaryPatchAction.display.name", (Object[])new Object[0]);
    }

    public boolean isRemoteOutOfPlaceRequired() {
        return this.getPatchSession().isApplyImageEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchActionResult execute(PatchTarget patchTarget) {
        PatchSession patchSession = this.getPatchSession();
        ProductSupportManager productSupportManager = this.getPatchSession().getProductSupportManager();
        if (this.getPatchSession().isApplyImageEnabled()) {
            try {
                if (patchSession.isAnalyze()) {
                    throw new OPatchAutoException("70002", new Object[0]);
                }
                ProductSupport productSupport = productSupportManager.getHomeCloningProductSupport(patchTarget);
                if (productSupport == null) {
                    throw new PatchActionException("70003", new Object[]{patchTarget.getHome().getLocation()});
                }
                if (this.getPatchSession().isRollback()) {
                    File currentHome = new File(patchTarget.getHome().getLocation());
                    File originalHome = new File(productSupportManager.getOptions().getOption("backup.location").getValue());
                    Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"BinaryPatchAction.rollback.home", (Object[])new Object[]{originalHome}));
                    productSupport.rollbackToOriginalHome(currentHome, originalHome, patchTarget.getHome().getInvPtrLoc());
                } else {
                    File destHome = new File(patchTarget.getHome().getLocation());
                    File backupLocation = new File(productSupportManager.getOptions().getOption("backup.location").getValue());
                    String imageFilePath = this.getPatchSession().getImageLocation();
                    if (StringUtil.isNullOrEmpty((String)imageFilePath, (boolean)true)) {
                        throw new OPatchAutoException("70004", new Object[0]);
                    }
                    File imageFile = new File(imageFilePath);
                    Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"BinaryPatchAction.applying.home.image", (Object[])new Object[]{imageFile, destHome}));
                    productSupport.applyHomeImage(imageFile, destHome, backupLocation, patchTarget.getHome().getInvPtrLoc());
                }
            }
            catch (Exception e) {
                return new PatchActionResult((Throwable)e);
            }
            return new PatchActionResult();
        }
        String oracleHomePath = patchTarget.getHome().getLocation();
        String invPtrLoc = patchTarget.getHome().getInvPtrLoc();
        String patchLocation = this.getPatchSession().getPatchLocation();
        String patchBaseDir = this.getPatchSession().getPatchBaseDirectory();
        boolean analyze = patchSession.isAnalyze();
        System.setProperty("OPatch.ORACLE_HOME", oracleHomePath);
        try {
            ArrayList skipped;
            boolean patchIdRollback;
            OracleTarget ot = new OracleTarget(oracleHomePath);
            PatchingSessionOptions options = new PatchingSessionOptions(ot);
            if (patchLocation != null && patchLocation.length() > 0) {
                options.setHasPatchLocn(true);
            }
            if (patchBaseDir != null && patchBaseDir.length() > 0) {
                options.setHasPatchDir(true);
            }
            SessionPatches patches = new SessionPatches();
            SessionResults addPatchResults = new SessionResults();
            boolean bl = patchIdRollback = patchSession.isRollback() && !StringUtil.isNullOrEmpty((String)patchSession.getPatchId(), (boolean)true);
            if (patchIdRollback) {
                String[] split;
                ArrayList<String> patchIds = new ArrayList<String>();
                String id = patchSession.getPatchId();
                for (String s : split = id.split(",")) {
                    if ((s = s.trim()).isEmpty()) continue;
                    patchIds.add(s);
                }
                patches.registerRollbackPatchIDs(patchIds);
            } else if (options.getHasPatchLocn()) {
                addPatchResults = patches.addPatch(patchLocation);
            } else if (options.getHasPatchDir()) {
                addPatchResults = patches.addParentLocn(patchBaseDir);
            }
            if (!patchIdRollback && addPatchResults.getSuccessfulPatches().size() < 1) {
                if (options.getHasPatchLocn()) {
                    throw new OPatchAutoException("70005", new Object[]{patchLocation, addPatchResults.collectSessionSummary()});
                }
                if (options.getHasPatchDir()) {
                    throw new OPatchAutoException("70006", new Object[]{patchBaseDir, addPatchResults.collectSessionSummary()});
                }
            }
            if (invPtrLoc != null) {
                options.setInvPtrLocn(invPtrLoc);
            }
            if (analyze) {
                options.setAnalyze(true);
            }
            if (productSupportManager.getOptions().getOption("force.conflict").isSwitchEnabled()) {
                options.setForceConflict(true);
            }
            if (productSupportManager.getOptions().getOption("skip.conflict").isSwitchEnabled()) {
                options.setSkipConflict(true);
            }
            if (productSupportManager.getOptions().getOption("no.relink").isSwitchEnabled()) {
                options.setNoRelink(true);
            }
            OPatchContext.destroyContextReference();
            OPatchAutoBinary binaryPatching = new OPatchAutoBinary(options);
            SessionResults binaryPatchingResults = patchSession.isRollback() ? binaryPatching.rollback(patches) : binaryPatching.apply(patches);
            ArrayList failed = binaryPatchingResults.getFailedPatches();
            if (failed != null && !failed.isEmpty()) {
                String operation = patchSession.isRollback() ? "rollback" : "apply";
                this._logger.warning("Binary patching failed to " + operation + " the following patches " + failed);
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)"70007", (Object[])new Object[0]) + "\n" + binaryPatchingResults.collectSessionSummary(), new Object[0]);
            }
            if (patchSession.isRollback() && (skipped = binaryPatchingResults.getSkippedPatches()) != null) {
                for (PatchResult result : skipped) {
                    Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"BinaryPatchAction.rollback.patch.skipped", (Object[])new Object[]{result.getPatchID(), result.getReason()}));
                }
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Binary patching summary:\n" + binaryPatchingResults.collectSessionSummary());
            }
        }
        catch (Throwable e) {
            this._logger.log(Level.SEVERE, "Binary patching failed.", e);
            PatchActionResult patchActionResult = new PatchActionResult(e);
            return patchActionResult;
        }
        finally {
            System.clearProperty("OPatch.ORACLE_HOME");
            try {
                OPatchContext.destroyContextReference();
            }
            catch (OPatchException e) {
                this._logger.log(Level.WARNING, "Failed to OPatch destroy context reference");
            }
        }
        return new PatchActionResult();
    }

    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        String opatchAutoTmp = container.getTempLocation();
        if (this.getPatchSession().isApplyImageEnabled()) {
            try {
                if (!this.getPatchSession().isRollback()) {
                    String remoteImageLocation = this.getPatchSession().getOptions().getOption("remote.image.location").getValue();
                    String tempHomeLocation = null;
                    if (StringUtil.isNullOrEmpty((String)remoteImageLocation)) {
                        String homeLoc = ((PatchTarget)container.getPatchTargets().iterator().next()).getHome(true).getLocation();
                        File localImageLocation = new File(this.getPatchSession().getImageLocation());
                        String[] remoteImageInfo = OPatchautoActionUtils.findTmpRemoteImagePath(homeLoc, localImageLocation.getName());
                        remoteImageLocation = remoteImageInfo[0];
                        tempHomeLocation = remoteImageInfo[1];
                    }
                    container.addPatchActionParameter("image.location", (Object)remoteImageLocation);
                    File localImageLocation = new File(this.getPatchSession().getImageLocation());
                    if (!OPatchautoActionUtils.isFileExistInRemoteHost(handler, this.getPatchSession().getImageLocation(), remoteImageLocation)) {
                        OPatchautoActionUtils.prepareRemoteLocationForFileTransfer(handler, remoteImageLocation);
                        this._logger.info("Pushing local image " + localImageLocation + " to location " + remoteImageLocation + " on remote host " + handler.getHost());
                        Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"BinaryPatchAction.pushing.remote.image", (Object[])new Object[]{handler.getHost().getHost(), remoteImageLocation}));
                        handler.put(remoteImageLocation, localImageLocation);
                    }
                    if (!StringUtil.isNullOrEmpty(tempHomeLocation)) {
                        handler.deleteOnClose(tempHomeLocation);
                    } else {
                        handler.deleteOnClose(remoteImageLocation);
                    }
                }
                container.addPatchActionParameter("backup.location", (Object)this.getPatchSession().getProductSupportManager().getOptions().getOption("backup.location").getValue());
            }
            catch (OPatchAutoException e) {
                throw new PatchActionException((Throwable)e);
            }
        } else if (this.getPatchSession().isRollback() && this.getPatchSession().getPatchId() != null) {
            container.addPatchActionParameter("id", (Object)this.getPatchSession().getPatchId());
        } else {
            String patchLocation = this.getPatchSession().getPatchLocation();
            String parameterKey = "patch.location";
            if (StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true)) {
                patchLocation = this.getPatchSession().getPatchBaseDirectory();
                parameterKey = "patch.base.directory";
            }
            if (StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true)) {
                throw new PatchActionException("70008", new Object[0]);
            }
            File localPatchLocation = new File(patchLocation);
            String remotePatchLocation = opatchAutoTmp + "/" + localPatchLocation.getName();
            container.addPatchActionParameter(parameterKey, (Object)remotePatchLocation);
            if (!handler.exists(remotePatchLocation)) {
                if (this._logger.isLoggable(Level.FINER)) {
                    this._logger.finer("Pushing local patch " + localPatchLocation + " to location " + remotePatchLocation + " on remote host " + handler.getHost());
                }
                handler.put(remotePatchLocation, localPatchLocation);
            }
            this.preparePatchingOptions(container);
        }
    }

    private void preparePatchingOptions(PatchActionExecutorContainer container) throws PatchActionException {
        try {
            ProductSupportManager productSupportManager = this.getPatchSession().getProductSupportManager();
            if (productSupportManager.getOptions().getOption("force.conflict").isSwitchEnabled()) {
                container.addPatchActionParameter("force.conflict", (Object)Boolean.TRUE.toString());
            }
            if (productSupportManager.getOptions().getOption("skip.conflict").isSwitchEnabled()) {
                container.addPatchActionParameter("skip.conflict", (Object)Boolean.TRUE.toString());
            }
            if (productSupportManager.getOptions().getOption("no.relink").isSwitchEnabled()) {
                container.addPatchActionParameter("no.relink", (Object)Boolean.TRUE.toString());
            }
        }
        catch (OPatchAutoException e) {
            throw new PatchActionException((Throwable)e);
        }
    }

    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        if (patchSession.isApplyImageEnabled()) {
            String backupLocationVal;
            if (!patchSession.isRollback()) {
                String imageLocation = (String)container.getPatchActionParameterValue("image.location");
                if (StringUtil.isNullOrEmpty((String)imageLocation, (boolean)true)) {
                    throw new PatchActionException("70009", new Object[0]);
                }
                patchSession.setImageLocation(imageLocation);
            }
            if (!StringUtil.isNullOrEmpty((String)(backupLocationVal = (String)container.getPatchActionParameterValue("backup.location")), (boolean)true)) {
                try {
                    patchSession.getProductSupportManager().getOptions().getOption("backup.location").setValue(backupLocationVal);
                }
                catch (OPatchAutoException e) {
                    throw new PatchActionException((Throwable)e);
                }
            }
        } else {
            String patchId = null;
            if (this.getPatchSession().isRollback()) {
                patchId = (String)container.getPatchActionParameterValue("id");
            }
            try {
                if (!StringUtil.isNullOrEmpty(patchId, (boolean)true)) {
                    patchSession.setPatchInfo(null, null, patchId);
                } else {
                    String patchLocation = (String)container.getPatchActionParameterValue("patch.location");
                    if (StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true)) {
                        patchLocation = (String)container.getPatchActionParameterValue("patch.base.directory");
                        if (StringUtil.isNullOrEmpty((String)patchLocation, (boolean)true)) {
                            throw new PatchActionException("70010", new Object[0]);
                        }
                        patchSession.setPatchInfo(null, patchLocation, null);
                    } else {
                        patchSession.setPatchInfo(patchLocation, null, null);
                    }
                }
                this.setUpPatchingOptions(patchSession, container);
            }
            catch (OPatchAutoException e) {
                throw new PatchActionException((Throwable)e);
            }
        }
    }

    private void setUpPatchingOptions(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws OPatchAutoException {
        String noRelinkVal;
        String skipConflictVal;
        String forceConflictVal = (String)container.getPatchActionParameterValue("force.conflict");
        ProductSupportManager productSupportManager = patchSession.getProductSupportManager();
        if (!StringUtil.isNullOrEmpty((String)forceConflictVal, (boolean)true)) {
            productSupportManager.getOptions().getOption("force.conflict").setValue(forceConflictVal);
        }
        if (!StringUtil.isNullOrEmpty((String)(skipConflictVal = (String)container.getPatchActionParameterValue("skip.conflict")), (boolean)true)) {
            productSupportManager.getOptions().getOption("skip.conflict").setValue(skipConflictVal);
        }
        if (!StringUtil.isNullOrEmpty((String)(noRelinkVal = (String)container.getPatchActionParameterValue("no.relink")), (boolean)true)) {
            productSupportManager.getOptions().getOption("no.relink").setValue(noRelinkVal);
        }
    }
}

