/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.validation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.OracleHome;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.resource.OPlanBundle;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriverException;
import oracle.osysmodel.validation.Cause;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.RuleSet;
import oracle.osysmodel.validation.ValidationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsConfigSupported
implements RuleSet {
    final Logger logger = Logger.getLogger(IsConfigSupported.class.getName());
    protected Set<String> platforms = new HashSet<String>();
    SystemInstance config;
    protected List<Rule> rulesToEvaluate = new ArrayList<Rule>();
    List<Cause> causes = null;
    ValidationResult result;

    public IsConfigSupported(SystemInstance config, ExecutionMode exeMode) throws ConfigValidationException {
        if (config == null) {
            throw new ConfigValidationException("SystemInstance given to the Validator is null");
        }
        this.config = config;
    }

    public Set<String> getPlatforms() {
        return this.platforms;
    }

    protected void addRuleToEvaluate(Rule rule) {
        if (null != rule) {
            this.rulesToEvaluate.add(rule);
        }
    }

    public ValidationResult invoke() throws ConfigValidationException {
        ArrayList<RuleResult> whatPassed = new ArrayList<RuleResult>();
        ArrayList<RuleResult> whatNotPassed = new ArrayList<RuleResult>();
        ArrayList<Rule> wasNotEvaluated = new ArrayList<Rule>();
        ArrayList<RuleResult> whatNulled = new ArrayList<RuleResult>();
        this.causes = new ArrayList<Cause>();
        boolean passed = true;
        for (Rule rule : this.rulesToEvaluate) {
            wasNotEvaluated.add(rule);
        }
        for (Rule rule : this.rulesToEvaluate) {
            wasNotEvaluated.remove(rule);
            RuleResult res = rule.invoke();
            if (res.passed == null) {
                whatNulled.add(res);
                continue;
            }
            if (res.passed.booleanValue()) {
                whatPassed.add(res);
                continue;
            }
            if (res.passed.booleanValue()) continue;
            whatNotPassed.add(res);
            for (Cause cause : res.getFailureCauses()) {
                this.causes.add(cause);
            }
            passed = false;
        }
        return new ValidationResult(new Boolean(passed), (RuleSet)this, "OPlanValidation", whatPassed, whatNotPassed, whatNulled, wasNotEvaluated);
    }

    public String parseWrongPlatformMessage(String cause) {
        List homes = this.config.getAllHomes();
        String aruId = ((OracleHome)homes.get(0)).getARUId();
        String message = null;
        try {
            message = OPlanBundle.getMessage(OPlan.class, "WRONG-PLATFORM-MESSAGE", aruId);
        }
        catch (MissingResourceException e) {
            message = "";
        }
        if (!this.platforms.contains(aruId)) {
            return message;
        }
        return cause;
    }

    public ValidationResult getOPlanRuleSetValidationResult() {
        if (this.result == null) {
            try {
                this.result = this.invoke();
            }
            catch (ConfigValidationException e) {
                throw new ProductDriverException((Throwable)e, ProductDriverException.Type.InvalidConfiguration);
            }
        }
        return this.result;
    }

    public List<Cause> getAllFailureCauses() {
        if (this.causes == null) {
            try {
                this.invoke();
            }
            catch (ConfigValidationException e) {
                throw new ProductDriverException((Throwable)e, ProductDriverException.Type.InvalidConfiguration);
            }
        }
        return this.causes;
    }
}

