/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.oplan;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import model.BaseClass;
import model.common.AbstractBaseTarget;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanInternalException;
import oracle.oplan.sdk.oplan.SystemModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableResolver {
    private Logger logger = Logger.getLogger(VariableResolver.class.getName());
    public static final Pattern PATTERN = Pattern.compile("%(@?)(\\w+)(\\.?)([^%]*)%");
    public static final Pattern GCOHPATTERN = Pattern.compile("(.*)(%ORACLE_HOME%)(.*)");
    public static final Pattern GCPHPATTERN = Pattern.compile("(.*)(%PATCH_LOCATION%)(.*)");

    public static String joinStrings(String sep, List<String> list) {
        StringBuffer buff = new StringBuffer();
        for (String s : list) {
            if (buff.length() != 0) {
                buff.append(sep);
            }
            buff.append(s);
        }
        return buff.toString();
    }

    public static String resolveTargetPropertyList(List<? extends BaseClass> targetList, String propName) {
        ArrayList<String> list = new ArrayList<String>();
        for (BaseClass baseClass : targetList) {
            String prop = SystemModelUtils.getTargetProperty(baseClass, propName).toString();
            list.add(prop);
        }
        return VariableResolver.joinStrings(",", list);
    }

    static String resolveTargetPropertyList(String targetName, String propName) {
        Class<? extends AbstractBaseTarget> c;
        ConfigGraph g = OPlan.getInstance().getConfigGraph();
        List<? extends AbstractBaseTarget> targets = g.getTargets(c = SystemModelUtils.getClassForType(targetName));
        String props = VariableResolver.resolveTargetPropertyList(targets, propName);
        if (props.length() == 0) {
            throw new OPlanInternalException("No targets of type " + targetName);
        }
        return props;
    }

    static String resolveGlobalVariable(String propName) {
        String property = OPlan.getInstance().getOPlanEnv().getProperty(propName);
        if (property == null) {
            throw new OPlanInternalException("Unable to resolve property " + propName);
        }
        return property;
    }

    static String resolveENVVariable(String targetName) {
        String value = System.getenv(targetName);
        if (value != null && value.length() > 0) {
            return value;
        }
        value = "%" + targetName + "%";
        return value;
    }

    public static String resolveVariable(String targetName, String propName, CommandContext context, boolean all, boolean fromEnv) {
        Logger logger = Logger.getLogger(VariableResolver.class.getName());
        if (targetName.equals("Global")) {
            return VariableResolver.resolveGlobalVariable(propName);
        }
        if (all) {
            return VariableResolver.resolveTargetPropertyList(targetName, propName);
        }
        if (fromEnv) {
            return VariableResolver.resolveENVVariable(targetName);
        }
        AbstractBaseTarget target = context.getFirstTarget(targetName);
        Object obj = SystemModelUtils.getTargetProperty((BaseClass)target, propName);
        if (obj == null) {
            throw new OPlanInternalException("Variable %" + targetName + "." + propName + "% resolved to null.");
        }
        return obj.toString();
    }

    public static String replaceContextProperties(String cmd, CommandContext context) {
        Matcher m = PATTERN.matcher(cmd);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            boolean all = m.group(1).length() == 1;
            String targetName = m.group(2);
            boolean fromEnv = false;
            if (m.group(3).length() == 0) {
                fromEnv = true;
            }
            String propName = m.group(4);
            String property = VariableResolver.resolveVariable(targetName, propName, context, all, fromEnv);
            property = Matcher.quoteReplacement(property);
            m.appendReplacement(sb, property);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String replaceGlobalGCContextProperties(String text) {
        String postText;
        String preText;
        if (null == text) {
            return null;
        }
        String oracleHomePath = VariableResolver.resolveGlobalVariable("OracleHome");
        String patchLocation = VariableResolver.resolveGlobalVariable("BundlePatchLocation");
        Matcher m = GCOHPATTERN.matcher(text);
        while (m.find()) {
            preText = m.group(1);
            postText = m.group(3);
            text = preText + oracleHomePath + postText;
            m = GCOHPATTERN.matcher(text);
        }
        m = GCPHPATTERN.matcher(text);
        while (m.find()) {
            preText = m.group(1);
            postText = m.group(3);
            text = preText + patchLocation + postText;
            m = GCPHPATTERN.matcher(text);
        }
        return text;
    }
}

