/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.oplan;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import model.SystemInstance;
import model.common.Host;
import oracle.opatch.system.automation.jaxb.Automation;
import oracle.oplan.core.automationselection.AutomationSelection;
import oracle.oplan.core.engine.SequencingEngine;
import oracle.oplan.core.oplan.CommandLineParsing;
import oracle.oplan.core.oplan.IOUtils;
import oracle.oplan.core.oplan.LogInfo;
import oracle.oplan.core.validation.IsPatchApplicable;
import oracle.oplan.core.validation.PatchValidationException;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.OPlanAccessOptParamKeys;
import oracle.oplan.sdk.OPlanException;
import oracle.oplan.sdk.cmdtranslator.CommandFactory;
import oracle.oplan.sdk.cookies.MakeCloneHome;
import oracle.oplan.sdk.exec.api.ExecutionPlan;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.intg.OPlanIntgFactory;
import oracle.oplan.sdk.oplan.OPlanEnv;
import oracle.oplan.sdk.oplan.OPlanInternalException;
import oracle.oplan.sdk.oplan.OPlanUserException;
import oracle.oplan.sdk.oplan.PlatformUtils;
import oracle.oplan.sdk.oplan.PreProcessor;
import oracle.oplan.sdk.oplan.configcompare.ConfigCompareException;
import oracle.oplan.sdk.oplan.configcompare.ConfigCompareHelper;
import oracle.oplan.sdk.oplan.configcompare.ConfigCompareResult;
import oracle.oplan.sdk.readme.ReadmeFactory;
import oracle.oplan.sdk.resource.OPlanBundle;
import oracle.oplan.sdk.util.OPlanUtils;
import oracle.oplan.sdk.validation.IsConfigSupported;
import oracle.osysmodel.driver.sdk.productdriver.DummyProductDriver;
import oracle.osysmodel.driver.sdk.productdriver.LocalInfo;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriver;
import oracle.osysmodel.driver.sdk.productdriver.ProductDriverException;
import oracle.osysmodel.validation.Cause;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.ValidPlatforms;
import oracle.osysmodel.validation.ValidationResult;
import oracle.osysmodel.validation.causes.WrongPlatform;

public class OPlan {
    Logger logger = Logger.getLogger(OPlan.class.getName());
    boolean runningStandalone = true;
    protected final ReadmeFactory readmeFactory = new ReadmeFactory();
    private Level intgConsoleLogLevel = null;
    private static ThreadLocal<OPlan> oplanThreadLocal = new ThreadLocal();
    OPlanLogger logs = new OPlanLogger();
    LogInfo logInfo = null;
    boolean logsSetup = false;
    OPlanEnv env = new OPlanEnv();
    CommandFactory cmdFactory = new CommandFactory();
    ProductDriver productDriver;
    MakeCloneHome cloneHomes;
    SystemInstance systemInstance;
    ConfigGraph configGraph;
    OPlanIntgFactory oplanIntgFactory = null;
    private LocalInfo localInfo = null;

    private OPlan() {
    }

    public static OPlan getInstance() {
        if (oplanThreadLocal.get() == null) {
            Logger.getLogger(OPlan.class.getName()).fine("OPlan instance is null, hence initializing new and keeping it in thread context");
            oplanThreadLocal.set(new OPlan());
        }
        return oplanThreadLocal.get();
    }

    public void restoreThreadContext() {
        this.logger.fine("Restoring thread context.");
        oplanThreadLocal.set(this);
    }

    public void cleanupThreadContext() {
        this.logger.fine("Cleaningup thread context.");
        oplanThreadLocal.set(null);
    }

    public void cleanup() {
        this.cleanupThreadContext();
        Logger rootLogger = Logger.getLogger("");
        for (Handler h : rootLogger.getHandlers()) {
            rootLogger.removeHandler(h);
        }
        this.intgConsoleLogLevel = null;
    }

    protected void finalize() {
        this.cleanup();
    }

    public OPlanLogger getLogger() {
        return this.logs;
    }

    public LogInfo getLogInfo() {
        return this.logInfo;
    }

    public OPlanEnv getOPlanEnv() {
        return this.env;
    }

    public CommandFactory getCommandFactory() {
        OPlanIntgFactory oplanIntgFactory = this.getOPlanIntgFactory();
        this.cmdFactory = oplanIntgFactory.getCommandFactory();
        return this.cmdFactory;
    }

    public ProductDriver getProductDriver() {
        if (null == this.productDriver) {
            if (this.env.hasConfigurationSnapshot()) {
                DummyProductDriver dummyProductDriver = this.getOPlanIntgFactory().getDummyProductDriver();
                dummyProductDriver.setDummyConfigFile(this.env.getConfigurationSnapshot());
                this.productDriver = dummyProductDriver;
                return dummyProductDriver;
            }
            this.productDriver = this.getOPlanIntgFactory().getProductDriver();
        }
        return this.productDriver;
    }

    public void setProductDriver(ProductDriver pd) {
        this.productDriver = pd;
    }

    public MakeCloneHome getMakeCloneHome() {
        if (this.cloneHomes == null) {
            this.cloneHomes = this.getOPlanIntgFactory().getMakeCloneHome(this.getConfigGraph(), this.getLocalInfo());
        }
        return this.cloneHomes;
    }

    public void tryWriteConfig(SystemInstance si, File configFile) {
        try {
            si.writeFile(configFile);
        }
        catch (FileNotFoundException e) {
            this.logger.log(Level.SEVERE, "Failed to write system configuration file", e);
        }
    }

    public void makeConfigSnapshot(File snapshotFile) {
        this.logs.setupLogs();
        this.logs.printProcessMessage();
        if (this.env.hasConfigurationSnapshot()) {
            DummyProductDriver dummyProductDriver = this.getOPlanIntgFactory().getDummyProductDriver();
            dummyProductDriver.setDummyConfigFile(this.env.getConfigurationSnapshot());
            this.productDriver = dummyProductDriver;
        } else {
            this.productDriver = this.getOPlanIntgFactory().getProductDriver();
        }
        SystemInstance si = this.productDriver.constructSystemInstance();
        this.tryWriteConfig(si, snapshotFile);
        this.logs.resetIntegrationLog();
    }

    public void setSystemInstance(SystemInstance si) {
        this.systemInstance = si;
        if (this.configGraph != null) {
            this.setConfigGraph(null);
        }
    }

    public boolean haveInitIntgFactory() {
        return this.oplanIntgFactory != null;
    }

    public SystemInstance getSystemInstance() {
        if (this.systemInstance == null) {
            this.productDriver = this.getProductDriver();
            try {
                this.systemInstance = this.productDriver.constructSystemInstance();
                if (this.configGraph != null) {
                    this.setConfigGraph(null);
                }
            }
            catch (OPlanUserException e) {
                throw e;
            }
            catch (ProductDriverException e) {
                e.printStackTrace();
                throw this.getResolvedProductDriverException(e);
            }
            catch (Exception e) {
                throw new OPlanUserException(e, "COULD_NOT_COLLECT_PRODUCT_INFO", e.getLocalizedMessage(), this.getLogInfo().getLogFile().getAbsolutePath());
            }
        }
        return this.systemInstance;
    }

    public void setConfigGraph(ConfigGraph cg) {
        this.configGraph = cg;
    }

    public ConfigGraph getConfigGraph(SystemInstance si) {
        if (this.configGraph == null) {
            this.logger.info("ConfigGraph is null, get config graph from system instance");
            assert (si != null);
            if (si == null) {
                throw new IllegalArgumentException("SystemInstance cannot be null");
            }
            Host localhost = null;
            if (this.localInfo != null) {
                localhost = this.localInfo.getLocalHost();
                this.logger.info("get localhost " + localhost != null ? localhost.getHostName() : "null");
            } else if (this.productDriver != null) {
                this.localInfo = this.productDriver.getLocalInfo();
                if (this.productDriver.getLocalInfo() != null) {
                    localhost = this.productDriver.getLocalInfo().getLocalHost();
                    this.logger.info("get localhost from product driver " + localhost != null ? localhost.getHostName() : "null");
                }
            }
            this.configGraph = this.getOPlanIntgFactory().getConfigGraph(si, localhost);
        }
        return this.configGraph;
    }

    public ConfigGraph getConfigGraph() {
        return this.getConfigGraph(this.getSystemInstance());
    }

    public void setOPlanInstgFactory(OPlanIntgFactory oplanIntgFactory) {
        this.oplanIntgFactory = oplanIntgFactory;
    }

    public void loadOPlanIntgFactory(String intgClass) {
        try {
            this.oplanIntgFactory = (OPlanIntgFactory)Class.forName(intgClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new OPlanException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new OPlanException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new OPlanException(e.getMessage(), e);
        }
    }

    public OPlanIntgFactory getOPlanIntgFactory() {
        if (this.oplanIntgFactory != null) {
            return this.oplanIntgFactory;
        }
        if (this.env.getProperty("IntgFactoryClass") != null) {
            this.loadOPlanIntgFactory(this.env.getProperty("IntgFactoryClass"));
            return this.oplanIntgFactory;
        }
        throw new OPlanException("Have not init OPlanIntgFactory object");
    }

    public void setLocalInfo(LocalInfo localInfo) {
        this.localInfo = localInfo;
    }

    public LocalInfo getLocalInfo() {
        if (this.localInfo != null) {
            return this.localInfo;
        }
        if (this.getProductDriver() != null) {
            this.logger.finest("The product driver is not null, so get local info from product driver.");
            this.localInfo = this.getProductDriver().getLocalInfo();
        }
        return this.localInfo;
    }

    public void configCompare(String firstConfigxml, String secondConfigxml, Properties planProps) throws ConfigCompareException {
        ProductDriver secondProductDriver;
        this.env.setProperties(planProps);
        this.logs.setupLogs();
        this.logs.printProcessMessage();
        DummyProductDriver firstProductDriver = this.getOPlanIntgFactory().getDummyProductDriver();
        firstProductDriver.setDummyConfigFile(new File(firstConfigxml).getAbsoluteFile());
        SystemInstance si1 = null;
        SystemInstance si2 = null;
        try {
            si1 = firstProductDriver.constructSystemInstance();
            this.setProductDriver((ProductDriver)firstProductDriver);
        }
        catch (ProductDriverException e) {
            throw this.getResolvedProductDriverException(e);
        }
        if (secondConfigxml != null) {
            DummyProductDriver secondDummyProductDriver = this.getOPlanIntgFactory().getDummyProductDriver();
            secondDummyProductDriver.setDummyConfigFile(new File(secondConfigxml).getAbsoluteFile());
            secondProductDriver = secondDummyProductDriver;
        } else {
            secondProductDriver = this.getOPlanIntgFactory().getProductDriver();
        }
        try {
            si2 = secondProductDriver.buildSystemInstance();
        }
        catch (ProductDriverException e) {
            throw this.getResolvedProductDriverException(e);
        }
        ConfigCompareHelper configCompareHelper = this.getOPlanIntgFactory().getConfigCompareHelper();
        ConfigCompareResult configDiffResult = configCompareHelper.compareIfSystemInstanceAreSame(si1, si2);
        if (configDiffResult.isDifferent()) {
            OPlan.print2Console(OPlanBundle.getMessage(OPlan.class, "CONFIGDIFFERENT", new Object[0]));
            this.logger.log(Level.INFO, "The two system configurations are different.");
            this.logger.log(Level.INFO, "Equivalent entitites in the two system configuration = " + configDiffResult.getEqualsMap());
            this.logger.log(Level.INFO, "Entities present in first system configuration not found in the second system onfiguration = " + configDiffResult.getSourceEntitiesNotFoundInDestination());
            this.logger.log(Level.INFO, "Entities present in second system configuration not found in the first system configuration = " + configDiffResult.getDestinationEntitiesNotFoundInSource());
        } else {
            OPlan.print2Console(OPlanBundle.getMessage(OPlan.class, "CONFIGSAME", new Object[0]));
            this.logger.log(Level.INFO, "The two system configurations are same.");
            this.logger.log(Level.INFO, "Equivalent entitites in the two system configuration = " + configDiffResult.getEqualsMap());
        }
        this.logs.resetIntegrationLog();
    }

    public void preProcess() {
        OPlanIntgFactory oplanIntgFactory = this.getOPlanIntgFactory();
        PreProcessor preProcess = oplanIntgFactory.getPreProcessor();
        if (preProcess != null) {
            preProcess.process();
        }
    }

    public void process(Properties planProps) {
        this.env.setProperties(planProps);
        this.env.setTargetOnWindows(PlatformUtils.isWindows());
        this.logs.setupLogs();
        this.logs.printProcessMessage();
        this.checkOpatch();
        if (this.env.getCustomLogPath() != null) {
            this.env.getOptionalParam().put(OPlanAccessOptParamKeys.opatchCustomLogDir, this.env.getCustomLogPath());
        }
        SystemInstance si = this.getSystemInstance();
        this.preProcess();
        this.logger.finest("Starting: Serialize config to xml.");
        this.tryWriteConfig(si, this.logInfo.getConfigXml());
        this.logger.finest("End: Serialize config to xml.");
        if (!"true".equalsIgnoreCase(this.env.getSkipConfigValidation())) {
            try {
                IsConfigSupported configValidation = this.getOPlanIntgFactory().getIsConfigSupported(si, ExecutionMode.STANDALONE);
                ValidationResult result = configValidation.invoke();
                if (!result.passed.booleanValue()) {
                    for (Cause cause : configValidation.getAllFailureCauses()) {
                        if (cause instanceof WrongPlatform) {
                            String message = configValidation.parseWrongPlatformMessage(cause.getMessage());
                            this.logger.severe(message);
                            OPlan.print2Console(message);
                            StringBuffer supportedPlatformMessage = new StringBuffer(OPlanBundle.getMessage(OPlan.class, "CURRENT_SUPPORT_PLATFORMS", new Object[0]));
                            for (String platformID : configValidation.getPlatforms()) {
                                String platform = "[" + platformID + "]\t" + ValidPlatforms.getDescription((int)Integer.valueOf(platformID));
                                supportedPlatformMessage.append("\n\t" + platform);
                            }
                            OPlan.print2Console(supportedPlatformMessage.toString());
                            continue;
                        }
                        this.logger.severe(cause.getMessage());
                        OPlan.print2Console(cause.getMessage());
                    }
                    throw new OPlanUserException("VALIDATION_FAILURE_MESSAGE", OPlan.getInstance().getLogInfo().getLogFile().getAbsolutePath());
                }
            }
            catch (ConfigValidationException e) {
                throw new OPlanUserException(e, "VALIDATION_FAILURE_MESSAGE", OPlan.getInstance().getLogInfo().getLogFile().getAbsolutePath());
            }
        }
        IsPatchApplicable patchApplicable = new IsPatchApplicable();
        try {
            boolean isPatchPlatformSameAsConfig = patchApplicable.isPlatformPatchSameAsRootPlatform();
        }
        catch (PatchValidationException e) {
            OPlan.print2Console(e.getMessage());
            throw new OPlanUserException(e, "VALIDATION_FAILURE_MESSAGE", OPlan.getInstance().getLogInfo().getLogFile().getAbsolutePath());
        }
        Map<Automation, URL> autos = AutomationSelection.selectAutomation();
        this.env.setAutomationFileMap(autos);
        ArrayList<ExecutionPlan> execPlans = new ArrayList<ExecutionPlan>();
        for (Automation auto : autos.keySet()) {
            this.logger.config("Generating execplan for " + OPlanUtils.getAutomationInfo(auto));
            SequencingEngine engine = new SequencingEngine(this.getConfigGraph(si), auto);
            ExecutionPlan execPlan = engine.getExecutionPlan();
            execPlans.add(execPlan);
        }
        this.logger.finest("Starting: generating readme(s) for the execution plan");
        ReadmeFactory.getInstance().generateReadme(execPlans, this.getConfigGraph(si));
        this.logger.finest("End: generating readme(s) for the execution plan");
        this.logs.resetIntegrationLog();
    }

    protected void printFileLocations() {
        this.logger.finest("Starting: printing plan summary");
        try {
            this.getLogInfo().printLogSummary();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Could not print summary", e);
        }
        this.logger.finest("End: printing plan summary");
    }

    public static String getVersionInfo() {
        InputStream is = OPlan.class.getClassLoader().getResourceAsStream("oracle/oplan/core/oplan/versioninfo.txt");
        BufferedReader b = new BufferedReader(new InputStreamReader(is));
        String prefix = "oplan version: ";
        try {
            String line = b.readLine();
            while (line != null) {
                if (line.startsWith(prefix)) {
                    return line.substring(prefix.length());
                }
                line = b.readLine();
            }
            throw new OPlanInternalException("OPlan Version not found in versioninfo.txt");
        }
        catch (IOException e) {
            throw new OPlanInternalException("Error reading versioninfo.txt", e);
        }
    }

    public void checkOpatch() {
        try {
            Class.forName("oracle.opatch.opatchsdk.OPatchPatch");
        }
        catch (ClassNotFoundException e) {
            System.out.println(OPlanBundle.getMessage(OPlan.class, "INVALID_OPATCH_VERSION", new Object[0]));
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        Logger logger = Logger.getLogger(OPlan.class.getName());
        CommandLineParsing cmdparser = new CommandLineParsing(args);
        try {
            cmdparser.parseCommandLine();
        }
        catch (Throwable e) {
            String mes = e.getMessage();
            System.out.println(OPlanBundle.getMessage(OPlan.class, "INVALID_ARGUMENT_ERROR", mes != null ? mes : ""));
            cmdparser.printHelp();
            return;
        }
        try {
            if (cmdparser.getCommandLineOptions() != null) {
                switch (cmdparser.getCommandLineOptions()) {
                    case HELP: {
                        cmdparser.printHelp();
                        return;
                    }
                    case VERSION: {
                        cmdparser.printVersionInfo();
                        return;
                    }
                }
            }
            OPlan oPlan = OPlan.getInstance();
            Properties planProps = new Properties();
            if (cmdparser.getPlanProps() != null) {
                planProps.putAll((Map<?, ?>)cmdparser.getPlanProps());
            }
            OPlan.addDefaultProperties(planProps);
            switch (cmdparser.getCommandLineAction()) {
                case SAVE_CONFIG: {
                    oPlan.saveConfigurationSnapshot(planProps, cmdparser);
                    break;
                }
                case CONFIGDIFF: {
                    String firstConfigxml = cmdparser.getConfigCompareFirstXML();
                    String secondConfigxml = cmdparser.getConfigCompareSecondXML();
                    oPlan.configCompare(firstConfigxml, secondConfigxml, planProps);
                    break;
                }
                case ALL_OPERATIONS: {
                    planProps.put("BundlePatchLocation", cmdparser.getBundlePatchLocation());
                    oPlan.generateApplySteps(planProps);
                    oPlan.generateRollBackSteps(planProps);
                    logger.fine("Printing instructions locations.");
                    oPlan.printFileLocations();
                    break;
                }
                case APPLY: {
                    planProps.put("BundlePatchLocation", cmdparser.getBundlePatchLocation());
                    oPlan.generateApplySteps(planProps);
                    logger.fine("Printing instructions locations.");
                    oPlan.printFileLocations();
                    break;
                }
                case ROLLBACK: {
                    planProps.put("BundlePatchLocation", cmdparser.getBundlePatchLocation());
                    oPlan.generateRollBackSteps(planProps);
                    logger.fine("Printing instructions locations.");
                    oPlan.printFileLocations();
                }
            }
            if (!PlatformUtils.isWindows()) {
                cmdparser.setFilePermissions(oPlan.getLogInfo().getLogDir());
            }
            System.exit(0);
        }
        catch (OPlanUserException e) {
            System.out.println(e.getLocalizedMessage());
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            System.exit(20);
        }
        catch (Throwable e) {
            if (e.getMessage() != null) {
                System.out.println("Caught exception: " + e.getMessage());
            } else {
                System.out.println("Caught exception: " + e.getClass().getName());
            }
            if (OPlan.getInstance().getLogInfo() != null) {
                System.out.println("Check " + OPlan.getInstance().getLogInfo().getLogFile() + " for details.");
            }
            logger.log(Level.SEVERE, "Terminated by exception", e);
            System.exit(100);
        }
    }

    private void saveConfigurationSnapshot(Properties planProps, CommandLineParsing cmdparser) {
        this.logger.fine("Writing configuration to XML: " + cmdparser.getSaveConfigurationXML());
        OPlan.getInstance().env.setProperties(planProps);
        OPlan.getInstance().makeConfigSnapshot(new File(cmdparser.getSaveConfigurationXML()));
        System.out.println();
        System.out.println(OPlanBundle.getMessage(OPlan.class, "WROTE_CONFIGURATION_TO_FILE", cmdparser.getSaveConfigurationXML()));
        System.out.println();
    }

    private void generateApplySteps(Properties planProps) {
        this.logger.fine("Starting: Generate apply instructions");
        planProps.put("Operation", "apply");
        OPlan.getInstance().process(planProps);
        this.logger.fine("End: Generate apply instructions");
    }

    private void generateRollBackSteps(Properties planProps) {
        this.logger.fine("Starting: Generate rollback instructions");
        planProps.put("Operation", "rollback");
        OPlan.getInstance().process(planProps);
        this.logger.fine("End: Generate rollback instructions");
    }

    protected static void addDefaultProperties(Properties planProps) {
        planProps.put("OracleHome", System.getenv("ORACLE_HOME"));
        planProps.put("OPlanVersion", OPlan.getVersionInfo());
    }

    public static void addVersion(Properties planProps) {
        planProps.put("OPlanVersion", OPlan.getVersionInfo());
    }

    public RuntimeException getResolvedProductDriverException(ProductDriverException e) {
        switch (e.getType()) {
            case IncompatibleProductVersion: {
                return new OPlanUserException(e, "IncompatibleProductVersion-PD-Exception", e.getMessage());
            }
            case ConfigurationNotSupported: {
                return new OPlanUserException(e, "ConfigurationNotSupported-PD-Exception", e.getMessage());
            }
        }
        return new OPlanUserException(e, "COULD_NOT_COLLECT_PRODUCT_INFO", e.getMessage(), this.getLogInfo().getLogFile().getAbsolutePath());
    }

    public ReadmeFactory getReadmeFactory() {
        return this.readmeFactory;
    }

    public boolean isRunningStandalone() {
        return this.runningStandalone;
    }

    public void setRunningStandalone(boolean runningStandalone) {
        this.runningStandalone = runningStandalone;
    }

    public static void print2Console(String message) {
        System.out.println(message);
    }

    public class OPlanLogger {
        private boolean processMessagePrinted = false;

        public void setupLogs(String logDir) {
            OPlan.this.env.setProperty("logDir", logDir);
            this.setupLogs();
        }

        public void resetIntegrationLog() {
            Logger rootLogger;
            if (OPlan.this.intgConsoleLogLevel != null && (rootLogger = Logger.getLogger("")).getHandlers().length >= 1 && rootLogger.getHandlers()[0] instanceof ConsoleHandler) {
                rootLogger.getHandlers()[0].setLevel(OPlan.this.intgConsoleLogLevel);
                OPlan.this.intgConsoleLogLevel = null;
            }
        }

        public void setupLogs() {
            Logger rootLogger = Logger.getLogger("");
            if (rootLogger.getHandlers().length >= 1 && rootLogger.getHandlers()[0] instanceof ConsoleHandler) {
                OPlan.this.intgConsoleLogLevel = rootLogger.getHandlers()[0].getLevel();
                rootLogger.getHandlers()[0].setLevel(OPlan.this.env.getConsoleLogLevel());
            }
            if (OPlan.this.logsSetup) {
                return;
            }
            Logger oplanLogger = Logger.getLogger("oracle.oplan");
            Logger osysLogger = Logger.getLogger("oracle.osysmodel");
            Logger modelLogger = Logger.getLogger("model");
            oplanLogger.setLevel(Level.ALL);
            osysLogger.setLevel(Level.ALL);
            modelLogger.setLevel(Level.ALL);
            try {
                File logDir = OPlan.this.env.getLogDir();
                if (logDir.equals(OPlan.this.env.getTargetHomeLogDir())) {
                    boolean created;
                    if (!logDir.exists() && !(created = logDir.mkdirs())) {
                        throw new OPlanUserException("DIRECTORY_CREATION_FAILED", logDir.getAbsolutePath());
                    }
                    IOUtils.chmodTo775(logDir);
                } else {
                    if (!logDir.exists()) {
                        logDir.mkdirs();
                    }
                    IOUtils.chmodTo775(logDir);
                }
                if (this.checkAndRemoveLogHandles(oplanLogger, osysLogger, modelLogger)) {
                    OPlan.this.logInfo = new LogInfo(logDir);
                    File logFile = OPlan.this.logInfo.getLogFile().getAbsoluteFile();
                    FileHandler fh = new FileHandler(logFile.getAbsolutePath());
                    fh.setFormatter(new SimpleFormatter());
                    fh.setLevel(OPlan.this.env.getLogFileLevel());
                    oplanLogger.addHandler(fh);
                    osysLogger.addHandler(fh);
                    modelLogger.addHandler(fh);
                }
            }
            catch (Exception e) {
                throw new OPlanUserException(e, "UNABLE_TO_CREATE_LOGS", e.getMessage());
            }
            OPlan.this.logsSetup = true;
        }

        private boolean checkAndRemoveLogHandles(Logger oplanLogger, Logger osysLogger, Logger modelLogger) {
            boolean haveRemovedHandle = false;
            if (oplanLogger.getHandlers().length == 0 || osysLogger.getHandlers().length == 0 || modelLogger.getHandlers().length == 0) {
                this.removeLogHandles(oplanLogger);
                this.removeLogHandles(osysLogger);
                this.removeLogHandles(modelLogger);
                haveRemovedHandle = true;
            }
            return haveRemovedHandle;
        }

        private void removeLogHandles(Logger logger) {
            Handler[] handles = logger.getHandlers();
            for (int i = 0; i < handles.length; ++i) {
                logger.removeHandler(handles[i]);
            }
        }

        protected void printProcessMessage() {
            if (this.processMessagePrinted) {
                return;
            }
            System.out.println("\n\n");
            System.out.println(OPlanBundle.getMessage(OPlan.class, "PROCESSING", new Object[0]));
            System.out.println("\n");
            System.out.println(OPlanBundle.getMessage(OPlan.class, "OPLAN_LOG_FILE_LOCATION", OPlan.this.logInfo.getLogFile().getAbsolutePath()) + "\n\n");
            this.processMessagePrinted = true;
        }
    }
}

