/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.graphlib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import model.BaseClass;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.common.OracleHome;
import oracle.opatch.system.automation.jaxb.Stripe;
import oracle.oplan.core.graphlib.AdjacencyListGraph;
import oracle.osysmodel.driver.sdk.productdriver.DummyProductDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigGraph {
    protected SystemInstance si;
    protected VertexComp c;
    protected AdjacencyListGraph<AbstractBaseTarget> adjacencyListGraph;

    protected ConfigGraph(VertexComp c, SystemInstance si) {
        this.si = si;
        this.c = c;
        this.adjacencyListGraph = new AdjacencyListGraph<AbstractBaseTarget>(c);
        this.constructConfigGraph();
    }

    public ConfigGraph(SystemInstance si, Host localHost) {
        this.si = si;
        this.c = this.getVertexCompInstance(this.initLocalHost(si, localHost));
        this.adjacencyListGraph = new AdjacencyListGraph<AbstractBaseTarget>(this.c);
        this.constructConfigGraph();
    }

    public Host initLocalHost(SystemInstance si, Host localHost) {
        if (localHost == null) {
            List hostList = si.getTargetsOfType(Host.class);
            Collections.sort(hostList, new DummyProductDriver.HostComparator());
            localHost = (Host)hostList.get(0);
        }
        return localHost;
    }

    public VertexComp getVertexCompInstance(Host localHost) {
        return new VertexComp(localHost);
    }

    public Host getLocalHost() {
        return this.c.getLocalHost();
    }

    public SystemInstance getSystemInstance() {
        return this.si;
    }

    public VertexComp getComparator() {
        return this.c;
    }

    public AbstractBaseTarget getRootVertex() {
        return this.si.getTop();
    }

    public void constructConfigGraph() {
        List entities = this.si.getEntities();
        for (BaseClass entity : entities) {
            this.adjacencyListGraph.insertVertex((AbstractBaseTarget)entity);
        }
        for (BaseClass entity : entities) {
            ArrayList<AbstractBaseTarget> outs = new ArrayList<AbstractBaseTarget>();
            for (List baseClasses : entity.getOutboundAssociations().values()) {
                for (BaseClass baseClass : baseClasses) {
                    outs.add((AbstractBaseTarget)baseClass);
                }
            }
            Collections.sort(outs, this.c);
            for (AbstractBaseTarget value : outs) {
                this.adjacencyListGraph.insertEdge((AbstractBaseTarget)entity, value);
            }
        }
    }

    public Iterable<AbstractBaseTarget> getVertices() {
        return this.adjacencyListGraph.getVertices();
    }

    public <T extends AbstractBaseTarget> List<T> getTargets(Class<T> type) {
        ArrayList<T> targets = new ArrayList<T>();
        for (AbstractBaseTarget v : this.adjacencyListGraph.getVertices()) {
            if (!type.isInstance(v)) continue;
            targets.add(type.cast(v));
        }
        return targets;
    }

    public <T extends AbstractBaseTarget> List<T> getTargets(Class<T> type, Stripe stripe) {
        ArrayList<T> targets = new ArrayList<T>();
        for (AbstractBaseTarget v : this.adjacencyListGraph.getVertices()) {
            if (!type.isInstance(v) || stripe != null && v instanceof OracleHome && !((OracleHome)v).getHomeType().equals(stripe.getTargetHome())) continue;
            targets.add(type.cast(v));
        }
        return targets;
    }

    public <T extends AbstractBaseTarget> List<T> getConnectedTargets(AbstractBaseTarget t, Class<T> type) {
        ArrayList<T> targets = new ArrayList<T>();
        if (this.adjacencyListGraph.getOutgoingVertices(t) != null) {
            for (AbstractBaseTarget v : this.adjacencyListGraph.getOutgoingVertices(t)) {
                if (!type.isInstance(v)) continue;
                targets.add(type.cast(v));
            }
        }
        if (targets.size() > 0) {
            return targets;
        }
        if (this.adjacencyListGraph.getIncomingVertices(t) != null) {
            for (AbstractBaseTarget v : this.adjacencyListGraph.getIncomingVertices(t)) {
                if (!type.isInstance(v)) continue;
                targets.add(type.cast(v));
            }
        }
        return targets;
    }

    public DefaultMutableTreeNode createTreeTable() {
        return new DefaultMutableTreeNode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VertexComp
    implements Comparator<AbstractBaseTarget> {
        protected Host localHost;

        public VertexComp(Host localHost) {
            this.localHost = localHost;
        }

        public Host getLocalHost() {
            return this.localHost;
        }

        public int compareTypes(AbstractBaseTarget t1, AbstractBaseTarget t2) {
            return t1.getClass().getName().compareTo(t2.getClass().getName());
        }

        public int compareNames(AbstractBaseTarget t1, AbstractBaseTarget t2) {
            if (t1.getName() == null && t2.getName() == null) {
                return 0;
            }
            if (t1.getName() == null && t2.getName() != null) {
                return 1;
            }
            if (t1.getName() != null && t2.getName() == null) {
                return -1;
            }
            return t1.getName().compareTo(t2.getName());
        }

        public int compareHosts(Host h1, Host h2) {
            if (h1 == h2) {
                return 0;
            }
            if (h1 == this.localHost) {
                return -1;
            }
            if (h2 == this.localHost) {
                return 1;
            }
            return this.compareNames((AbstractBaseTarget)h1, (AbstractBaseTarget)h2);
        }

        @Override
        public int compare(AbstractBaseTarget t1, AbstractBaseTarget t2) {
            Host h2;
            Host h1;
            int cmp = 0;
            if (t1 == t2) {
                return 0;
            }
            cmp = this.compareTypes(t1, t2);
            if (cmp != 0) {
                return cmp;
            }
            if (t1 instanceof Host) {
                return this.compareHosts((Host)t1, (Host)t2);
            }
            cmp = this.compareNames(t1, t2);
            if (cmp != 0) {
                return cmp;
            }
            if (t1 instanceof OracleHome && (cmp = this.compareHosts(h1 = (Host)((OracleHome)t1).getHosts().get(0), h2 = (Host)((OracleHome)t2).getHosts().get(0))) != 0) {
                return cmp;
            }
            return t1.getUniqueId().compareTo(t2.getUniqueId());
        }
    }
}

