/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.exec.api;

import java.util.ArrayList;
import java.util.List;
import model.common.Host;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.oplan.sdk.exec.api.ExecutionStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupBySimilarSteps {
    private final List<ExecutionStep> steps;
    private List<List<ExecutionStep>> stepGrouping = new ArrayList<List<ExecutionStep>>();
    private List<Host> hosts = new ArrayList<Host>();

    public GroupBySimilarSteps(List<ExecutionStep> steps) {
        this.steps = steps;
        this.makeGroup();
    }

    private void makeGroup() {
        ActionType prev = null;
        ArrayList<ExecutionStep> group = null;
        for (ExecutionStep step : this.steps) {
            this.add2Host(step.getHost());
            ActionType action = step.getAutomationAction();
            if (prev == null || prev != action) {
                group = new ArrayList<ExecutionStep>();
                this.stepGrouping.add(group);
                group.add(step);
                prev = action;
                continue;
            }
            group.add(step);
        }
    }

    public List<List<ExecutionStep>> getSimilarStepGrouping() {
        return this.stepGrouping;
    }

    public List<Host> getApplicableHosts() {
        return this.hosts;
    }

    private void add2Host(Host host) {
        if (!this.hosts.contains(host)) {
            this.hosts.add(host);
        }
    }
}

