/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.exec.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import oracle.opatch.system.automation.jaxb.DeploymentSubType;
import oracle.opatch.system.automation.jaxb.DeploymentType;
import oracle.opatch.system.automation.jaxb.Operation;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.exec.api.ExecutionPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExeuctionPlanUtil {
    Logger logger = Logger.getLogger(ExeuctionPlanUtil.class.getName());
    private static List<ExecutionPlan> EMPTY_LIST = Collections.emptyList();

    private static boolean empty(List<ExecutionPlan> plans) {
        return plans == null || plans.isEmpty();
    }

    public static List<ExecutionPlan> rollbacks(List<ExecutionPlan> plans) {
        if (ExeuctionPlanUtil.empty(plans)) {
            return EMPTY_LIST;
        }
        ArrayList<ExecutionPlan> res = ExeuctionPlanUtil.empty(plans) ? EMPTY_LIST : new ArrayList<ExecutionPlan>();
        for (ExecutionPlan plan : plans) {
            if (!Operation.ROLLBACK.equals((Object)plan.getAutomation().getOperation())) continue;
            res.add(plan);
        }
        return res;
    }

    public static List<ExecutionPlan> applys(List<ExecutionPlan> plans) {
        if (ExeuctionPlanUtil.empty(plans)) {
            return EMPTY_LIST;
        }
        ArrayList<ExecutionPlan> res = new ArrayList<ExecutionPlan>();
        for (ExecutionPlan plan : plans) {
            if (!Operation.APPLY.equals((Object)plan.getAutomation().getOperation())) continue;
            res.add(plan);
        }
        return res;
    }

    public static List<ExecutionPlan> switchbacks(List<ExecutionPlan> plans) {
        if (ExeuctionPlanUtil.empty(plans)) {
            return EMPTY_LIST;
        }
        ArrayList<ExecutionPlan> res = ExeuctionPlanUtil.empty(plans) ? EMPTY_LIST : new ArrayList<ExecutionPlan>();
        for (ExecutionPlan plan : plans) {
            if (!Operation.SWITCHBACK.equals((Object)plan.getAutomation().getOperation())) continue;
            res.add(plan);
        }
        return res;
    }

    public static List<ExecutionPlan> applyNswitchbacks(List<ExecutionPlan> plans) {
        if (ExeuctionPlanUtil.empty(plans)) {
            return EMPTY_LIST;
        }
        ArrayList<ExecutionPlan> res = ExeuctionPlanUtil.empty(plans) ? EMPTY_LIST : new ArrayList<ExecutionPlan>();
        for (ExecutionPlan plan : plans) {
            if (!Operation.SWITCHBACK.equals((Object)plan.getAutomation().getOperation()) && !Operation.APPLY.equals((Object)plan.getAutomation().getOperation())) continue;
            res.add(plan);
        }
        return res;
    }

    public static List<ExecutionPlan> applyNrollbacks(List<ExecutionPlan> plans) {
        if (ExeuctionPlanUtil.empty(plans)) {
            return EMPTY_LIST;
        }
        ArrayList<ExecutionPlan> res = ExeuctionPlanUtil.empty(plans) ? EMPTY_LIST : new ArrayList<ExecutionPlan>();
        for (ExecutionPlan plan : plans) {
            if (!Operation.ROLLBACK.equals((Object)plan.getAutomation().getOperation()) && !Operation.APPLY.equals((Object)plan.getAutomation().getOperation())) continue;
            res.add(plan);
        }
        return res;
    }

    public static List<ExecutionPlan> inplaces(List<ExecutionPlan> plans) {
        if (ExeuctionPlanUtil.empty(plans)) {
            return EMPTY_LIST;
        }
        ArrayList<ExecutionPlan> res = new ArrayList<ExecutionPlan>();
        for (ExecutionPlan plan : plans) {
            if (!DeploymentType.IN_PLACE.equals((Object)plan.getAutomation().getDeploymentType())) continue;
            res.add(plan);
        }
        return res;
    }

    public static List<ExecutionPlan> outofplaces(List<ExecutionPlan> plans) {
        if (ExeuctionPlanUtil.empty(plans)) {
            return EMPTY_LIST;
        }
        ArrayList<ExecutionPlan> res = new ArrayList<ExecutionPlan>();
        for (ExecutionPlan plan : plans) {
            if (!DeploymentType.OUT_OF_PLACE.equals((Object)plan.getAutomation().getDeploymentType())) continue;
            res.add(plan);
        }
        return res;
    }

    public static List<ExecutionPlan> rollings(List<ExecutionPlan> plans) {
        if (ExeuctionPlanUtil.empty(plans)) {
            return EMPTY_LIST;
        }
        ArrayList<ExecutionPlan> res = new ArrayList<ExecutionPlan>();
        for (ExecutionPlan plan : plans) {
            if (!DeploymentSubType.ROLLING_UPGRADE.equals((Object)plan.getAutomation().getDeploymentSubType())) continue;
            res.add(plan);
        }
        return res;
    }

    public static List<ExecutionPlan> nonrollings(List<ExecutionPlan> plans) {
        if (ExeuctionPlanUtil.empty(plans)) {
            return EMPTY_LIST;
        }
        ArrayList<ExecutionPlan> res = new ArrayList<ExecutionPlan>();
        for (ExecutionPlan plan : plans) {
            if (!DeploymentSubType.NON_ROLLING_UPGRADE.equals((Object)plan.getAutomation().getDeploymentSubType())) continue;
            res.add(plan);
        }
        return res;
    }

    public static List<ExecutionPlan> autos(List<ExecutionPlan> plans) {
        if (ExeuctionPlanUtil.empty(plans)) {
            return EMPTY_LIST;
        }
        ArrayList<ExecutionPlan> res = new ArrayList<ExecutionPlan>();
        for (ExecutionPlan plan : plans) {
            if (!Strategy.AUTO_PATCH.equals((Object)plan.getAutomation().getStrategy())) continue;
            res.add(plan);
        }
        return res;
    }

    public static List<ExecutionPlan> manuals(List<ExecutionPlan> plans) {
        if (ExeuctionPlanUtil.empty(plans)) {
            return EMPTY_LIST;
        }
        ArrayList<ExecutionPlan> res = new ArrayList<ExecutionPlan>();
        for (ExecutionPlan plan : plans) {
            if (!Strategy.MANUAL.equals((Object)plan.getAutomation().getStrategy())) continue;
            res.add(plan);
        }
        return res;
    }

    public static List<ExecutionPlan> dclis(List<ExecutionPlan> plans) {
        if (ExeuctionPlanUtil.empty(plans)) {
            return EMPTY_LIST;
        }
        ArrayList<ExecutionPlan> res = new ArrayList<ExecutionPlan>();
        for (ExecutionPlan plan : plans) {
            if (!Strategy.DCLI.equals((Object)plan.getAutomation().getStrategy())) continue;
            res.add(plan);
        }
        return res;
    }

    public static ExecutionPlan first(List<ExecutionPlan> plans) {
        if (ExeuctionPlanUtil.empty(plans)) {
            return null;
        }
        return plans.get(0);
    }
}

