/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import model.common.OracleHome;
import model.patchmodel.CompositePatch;
import model.patchmodel.GenericPatch;
import model.patchmodel.OPatchSingleton;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.OpatchAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.OPlanAccessOptParamKeys;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleShellCommand;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanEnv;
import oracle.oplan.sdk.oplan.OPlanInternalException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPatchPrereqCommand
extends SimpleShellCommand {
    String prereq_name = null;

    public OPatchPrereqCommand(ActionType automationAction, String prereq_name) {
        super(automationAction);
        this.prereq_name = prereq_name;
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        OPlanEnv env = OPlan.getInstance().getOPlanEnv();
        ExecutionMode exeMode = env.getExecutionMode();
        List<GenericPatch> patches = !exeMode.equals((Object)ExecutionMode.EM) ? env.getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(oh.getHomeType())) : CommandUtils.getPatchesByOHOwnerForEM(oh);
        List<GenericPatch> sortedPatches = CommandUtils.sortPatchesById(patches);
        CommandUtils.storePatchIDsInContext(context, sortedPatches);
        ArrayList<String> cmds = null;
        String invPtrOption = CommandUtils.getInvPtrOption(oh);
        String opatchPath = CommandUtils.getOPatchPath(oh);
        if (patches != null && patches.size() != 0) {
            cmds = new ArrayList<String>();
            for (GenericPatch patch : sortedPatches) {
                if (!(patch instanceof OPatchSingleton) && !(patch instanceof CompositePatch)) continue;
                String mkdirCmd = "";
                String customLogDirCmd = "";
                Map<OPlanAccessOptParamKeys, String> optParam = OPlan.getInstance().getOPlanEnv().getOptionalParam();
                if (optParam.containsKey((Object)OPlanAccessOptParamKeys.opatchCustomLogDir)) {
                    String customLogDirPath = CommandUtils.getCustomLogDir(optParam.get((Object)OPlanAccessOptParamKeys.opatchCustomLogDir), oh.getPath());
                    mkdirCmd = "mkdir -p " + customLogDirPath + " ; ";
                    customLogDirCmd = " -customLogDir " + customLogDirPath;
                }
                String cmd = mkdirCmd + opatchPath + " prereq " + this.prereq_name + " -ph " + patch.getPatchLocation() + invPtrOption + " -oh " + oh.getPath() + customLogDirCmd;
                if (ExecutionMode.EM == exeMode) {
                    String GREP_COMMAND = CommandUtils.getGrepCommand(oh);
                    cmd = cmd + " | " + GREP_COMMAND + " ZOP";
                    if (!env.isTargetOnWindows()) {
                        cmd = "tmp=$(" + cmd + ");test ! \"$tmp\"";
                    } else {
                        String user = oh.getOwner();
                        if (user == null || user.equals("")) {
                            user = "user";
                        }
                        String tmpFile = oh.getPath() + "\\.patch_storage\\OplanPre_" + user + ".tmp";
                        String emptyFile = oh.getPath() + "\\.patch_storage\\emptyfile_" + user;
                        String createEmptyFile = "type nul > " + emptyFile;
                        String fc = "fc " + tmpFile + " " + emptyFile + " > nul";
                        cmd = cmd + " > " + tmpFile + " & " + createEmptyFile + " & " + fc;
                    }
                }
                cmds.add(cmd);
            }
        }
        return cmds;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<OPatchPrereqCommand> {
        private String getPrereqName(OpatchAction oa) {
            for (OpatchAction.Parameter p : oa.getParameter()) {
                if (!p.getName().equals("PrereqName")) continue;
                return p.getValue();
            }
            throw new OPlanInternalException("opatch prereq with no PrereqName paramater");
        }

        @Override
        public OPatchPrereqCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof OpatchAction) || !a.getType().equals("prereq")) {
                return null;
            }
            OpatchAction oa = (OpatchAction)a;
            OPatchPrereqCommand com = new OPatchPrereqCommand(a, this.getPrereqName(oa));
            return com;
        }
    }
}

