/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.common.OracleHome;
import model.patchmodel.PatchPackage;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.cmdtranslator.Command;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cmdtranslator.commands.CommandActionType;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyPatch
extends Command {
    public CopyPatch(ActionType automationAction) {
        super(automationAction);
    }

    static String getMkdirCmd(File file) {
        return "mkdir -p " + file.getParentFile().getAbsolutePath();
    }

    static String getScpCmd(Host localhost, File file) {
        return "scp -r " + localhost.getHostName() + ":" + file.getAbsolutePath() + " " + file.getAbsolutePath();
    }

    public static List<Host> getRemoteHosts(ConfigGraph g) {
        Host localhost = g.getLocalHost();
        ArrayList<Host> hosts = new ArrayList<Host>(g.getTargets(Host.class));
        hosts.remove(localhost);
        return hosts;
    }

    public void addRemoteCommand(ExecutionStep step, ConfigGraph g, File file) {
        step.getCommand().add(new ExecutionStep.Command(CopyPatch.getMkdirCmd(file)));
        step.getCommand().add(new ExecutionStep.Command(CopyPatch.getScpCmd(g.getLocalHost(), file)));
    }

    @Override
    public List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        List<PatchPackage> patchFiles = OPlan.getInstance().getOPlanEnv().getPatchesBag().getBagContents();
        List<? extends AbstractBaseTarget> targets = actsOnlyOnTargets;
        ExecutionStep firstStep = CommandUtils.getStepWithContext(this.automationAction, g, targets.get(0));
        steps.add(firstStep);
        for (OracleHome oracleHome : targets.subList(1, targets.size())) {
            ExecutionStep step = CommandUtils.getStepWithContext(this.automationAction, g, (AbstractBaseTarget)oracleHome);
            for (PatchPackage pp : patchFiles) {
                File location = new File(pp.getPatchLocation());
                this.addRemoteCommand(step, g, location);
            }
            steps.add(step);
        }
        return steps;
    }

    @Override
    public boolean shouldIncludeStepInExecutionMode(ExecutionMode executionMode) {
        return !ExecutionMode.EM.equals((Object)executionMode);
    }

    @Override
    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        return g.getTargets(OracleHome.class, this.automationAction.getStripe());
    }

    @Override
    protected boolean includeTargetByVersion(ConfigGraph g, AbstractBaseTarget abt, ExecutionMode exeMode) {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DcliCommand
    extends Command {
        public DcliCommand(ActionType automationAction) {
            super(automationAction);
        }

        @Override
        public List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
            ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
            List<PatchPackage> patchFiles = OPlan.getInstance().getOPlanEnv().getPatchesBag().getBagContents();
            List<? extends AbstractBaseTarget> targets = actsOnlyOnTargets;
            ExecutionStep step = CommandUtils.getStepWithContext(this.automationAction, g, targets.get(0));
            String user = step.getUser().getValue();
            List<Host> hosts = CopyPatch.getRemoteHosts(g);
            for (PatchPackage patch : patchFiles) {
                File location = new File(patch.getPatchLocation());
                step.getCommand().add(new ExecutionStep.Command(CommandUtils.dcliPrefix(CopyPatch.getMkdirCmd(location), hosts, user)));
                step.getCommand().add(new ExecutionStep.Command(CommandUtils.dcliCopy(location, location, hosts, user, true)));
            }
            steps.add(step);
            return steps;
        }

        @Override
        protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
            return g.getTargets(OracleHome.class, this.automationAction.getStripe());
        }
    }

    public static class Builder
    implements CommandBuilder {
        public Command getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(CommandActionType.CopyPatch.toString())) {
                return null;
            }
            if (s.equals((Object)Strategy.DCLI)) {
                return new DcliCommand(a);
            }
            return new CopyPatch(a);
        }
    }
}

