/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.PatchingPhase;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Command {
    private final Logger logger = Logger.getLogger(Command.class.getName());
    protected ActionType automationAction;
    private PatchingPhase patchingPhase;

    public Command(ActionType automationAction) {
        this.automationAction = automationAction;
    }

    public List<ExecutionStep> getExecutionSteps(ConfigGraph g) {
        ExecutionMode exeMode = OPlan.getInstance().getOPlanEnv().getExecutionMode();
        if (!this.shouldIncludeStepInExecutionMode(exeMode)) {
            this.logger.fine("Command " + this.getClass().getName() + " will not be included in execution mode" + exeMode.toString());
            return Collections.emptyList();
        }
        if (!this.isCommandApplicableForPatchesInContext()) {
            this.logger.fine("Command " + this.getClass().getName() + " is not going to produce any patching steps for the given set of patches, " + "hence skipping.");
            return Collections.emptyList();
        }
        List<? extends AbstractBaseTarget> abts = this.getApplicableTargets(g);
        ArrayList<AbstractBaseTarget> actsOnOnly = new ArrayList<AbstractBaseTarget>();
        for (AbstractBaseTarget abstractBaseTarget : abts) {
            if (!this.includeTargetForPatching(g, abstractBaseTarget)) {
                this.logger.log(Level.CONFIG, "Skipping generating execution step: " + this.automationAction + " for:" + abstractBaseTarget + " as SkipTargetCookie has been set.");
                this.updatePatchingStatusOfOracleHome(abstractBaseTarget, "skipped");
                continue;
            }
            if (!this.includeTargetByVersion(g, abstractBaseTarget, exeMode)) {
                this.logger.log(Level.CONFIG, "Skipping generating execution step: " + this.automationAction + " for:" + abstractBaseTarget + " as its version does not match.");
                this.updatePatchingStatusOfOracleHome(abstractBaseTarget, "skipped");
                continue;
            }
            this.logger.log(Level.FINE, "Generating execution step: " + this.automationAction + " for:" + abstractBaseTarget);
            this.updatePatchingStatusOfOracleHome(abstractBaseTarget, "patched");
            actsOnOnly.add(abstractBaseTarget);
        }
        if (actsOnOnly.size() == 0) {
            this.logger.log(Level.FINE, "There are no targets to act on for step: " + this.automationAction + " hence returning emoty ExecutionSteps.");
            return Collections.emptyList();
        }
        this.logger.log(Level.FINE, "Going to act only on the targets:" + actsOnOnly + " for step: " + this.automationAction + " Some-targets-skipped(?)=" + (abts.size() != actsOnOnly.size()));
        return this.generateExecutionSteps(g, actsOnOnly);
    }

    private void updatePatchingStatusOfOracleHome(AbstractBaseTarget abt, String status) {
        if (abt instanceof OracleHome) {
            String path = ((OracleHome)abt).getPath();
            OPlan.getInstance().getOPlanEnv().getPatchingStatusOfOracleHome().put(path, status);
        }
    }

    public boolean shouldIncludeStepInExecutionMode(ExecutionMode executionMode) {
        return true;
    }

    public boolean isCommandApplicableForPatchesInContext() {
        return true;
    }

    protected abstract List<ExecutionStep> generateExecutionSteps(ConfigGraph var1, List<? extends AbstractBaseTarget> var2);

    protected abstract List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph var1);

    public ActionType getAutomationAction() {
        return this.automationAction;
    }

    protected final boolean includeTargetForPatching(ConfigGraph g, AbstractBaseTarget abt) {
        if (!OPlan.getInstance().getOPlanEnv().selectivePatchingEnabled()) {
            this.logger.log(Level.FINER, "Selective patching property disabled, hence always returning true.");
            return true;
        }
        if (this.isDoNotSkipTagSet()) {
            this.logger.log(Level.FINER, "do_not_skip tag is set on step: " + this.automationAction + ", hence always executing this step.");
            return true;
        }
        if (CommandUtils.isSkipTargetCookieSet(this, abt)) {
            if (this.automationAction.getWhilePatching() == null) {
                this.logger.log(Level.FINER, "SkipTargetCookie is set on target :" + abt + " and while-patching condition is empty for step: " + this.automationAction + " . Hence do not generate execution step for this target.");
                return false;
            }
            return OPlan.getInstance().getCommandFactory().decideBasedOnWhilePatchingTargetAttribute(this, g, abt);
        }
        if (this.automationAction.getWhilePatching() == null) {
            this.logger.log(Level.FINER, "SkipTargetCookie is NOT set on target :" + abt + " and while-patching condition is empty for step: " + this.automationAction + " . Hence generate execution step for this target.");
            return true;
        }
        this.logger.log(Level.FINER, "SkipTargetCookie is NOT set on target :" + abt + " and while-patching condition is set for step: " + this.automationAction + " . Hence going to decide based on the WhilePatchingAttribute.");
        return OPlan.getInstance().getCommandFactory().decideBasedOnWhilePatchingTargetAttribute(this, g, abt);
    }

    protected void setPatchingPhase(PatchingPhase patchingPhase) {
        this.patchingPhase = patchingPhase;
    }

    protected PatchingPhase getPatchingPhase() {
        return this.patchingPhase;
    }

    private boolean isDoNotSkipTagSet() {
        return "do_not_skip".equals(this.automationAction.getTag());
    }

    protected boolean includeTargetByVersion(ConfigGraph g, AbstractBaseTarget abt, ExecutionMode exeMode) {
        return OPlan.getInstance().getCommandFactory().includeTargetByVersion(g, abt, exeMode);
    }
}

