/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import model.SystemInstance;
import model.patchmodel.PatchPackage;
import oracle.opatch.system.automation.jaxb.DeploymentSubType;
import oracle.opatch.system.automation.jaxb.DeploymentType;
import oracle.opatch.system.automation.jaxb.Operation;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.OPlanAccessOptParamKeys;
import oracle.oplan.sdk.OPlanFacade;
import oracle.oplan.sdk.intg.OPlanIntgFactory;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.configcompare.ConfigCompareException;
import oracle.oplan.sdk.oplan.configcompare.ConfigCompareHelper;
import oracle.oplan.sdk.oplan.configcompare.ConfigCompareResult;
import oracle.oplan.sdk.patch.PatchPackagesBag;
import oracle.oplan.sdk.validation.IsConfigSupported;
import oracle.osysmodel.validation.Cause;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.ValidationResult;
import oracle.osysmodel.validation.causes.WrongPlatform;

public class OPlanAccess {
    Logger logger = Logger.getLogger(OPlanAccess.class.getName());
    private SystemInstance tobePatchedSystemInstance;
    private DeploymentType deploymentType;
    private DeploymentSubType subType;
    private Operation operation;
    private Strategy strategy;
    private ExecutionMode exeMode;
    private boolean switchbackAfterMigrate = false;
    private ConfigSupportResult configSupportResult;
    private PatchSupportResult patchSupportResult;
    private PatchPackagesBag patchesBag;
    private volatile OPlanFacade oplanFacade;
    private OPlanIntgFactory oplanIntgFactory;
    private SystemInstance firstInstance;
    private SystemInstance secondInstance;

    public OPlanAccess(OPlanIntgFactory oplanIntgFactory, SystemInstance tobePatchedSystemInstance, DeploymentType deploymentType, DeploymentSubType subType, Operation operation, Strategy strategy, ExecutionMode exeMode) {
        assert (tobePatchedSystemInstance != null);
        assert (deploymentType != null);
        assert (subType != null);
        assert (operation != null);
        assert (strategy != null);
        assert (exeMode != null);
        assert (oplanIntgFactory != null);
        this.tobePatchedSystemInstance = tobePatchedSystemInstance;
        this.deploymentType = deploymentType;
        this.subType = subType;
        this.operation = operation;
        this.strategy = strategy;
        this.exeMode = exeMode;
        this.oplanIntgFactory = oplanIntgFactory;
        if (ExecutionMode.EM.equals((Object)exeMode) && Operation.SWITCHBACK.equals((Object)operation)) {
            this.switchbackAfterMigrate = true;
        }
    }

    private OPlanAccess(OPlanIntgFactory oplanIntgFactory, SystemInstance firstInstance, SystemInstance secondInstance) {
        assert (oplanIntgFactory != null);
        assert (firstInstance != null);
        assert (secondInstance != null);
        this.oplanIntgFactory = oplanIntgFactory;
        this.firstInstance = firstInstance;
        this.secondInstance = secondInstance;
    }

    public void setSwitchbackAfterMigrate(boolean switchbackAfterMigrate) {
        this.switchbackAfterMigrate = switchbackAfterMigrate;
    }

    public void setPatches(PatchPackagesBag patchBag) {
        this.patchesBag = patchBag;
    }

    public void setTargetOnWindows(boolean isTargetOnWindows) {
        OPlan.getInstance().getOPlanEnv().setTargetOnWindows(isTargetOnWindows);
    }

    public void setOptionalParamForPatching(OPlanAccessOptParamKeys key, String value) {
        OPlan.getInstance().getOPlanEnv().getOptionalParam().put(key, value);
    }

    public ConfigSupportResult isConfigSupported() {
        if (this.configSupportResult != null) {
            return this.configSupportResult;
        }
        this.configSupportResult = new ConfigSupportResult();
        this.configSupportResult.result = true;
        try {
            IsConfigSupported configValidation = this.oplanIntgFactory.getIsConfigSupported(this.tobePatchedSystemInstance, this.exeMode);
            ValidationResult result = configValidation.invoke();
            if (!result.passed.booleanValue()) {
                this.configSupportResult.result = false;
                this.configSupportResult.failureCauses = configValidation.getAllFailureCauses();
                this.logger.severe("System instance did not pass validation because of the below reasons: \n############");
                for (Cause cause : this.configSupportResult.failureCauses) {
                    if (cause instanceof WrongPlatform) {
                        this.logger.severe(configValidation.parseWrongPlatformMessage(cause.getMessage()));
                        continue;
                    }
                    this.logger.severe(cause.getMessage());
                }
                this.logger.severe("############");
            }
        }
        catch (ConfigValidationException e) {
            this.configSupportResult = null;
            throw new RuntimeException("Exception while validating the system instance.", e);
        }
        return this.configSupportResult;
    }

    public PatchSupportResult isPatchSupported() {
        if (this.patchSupportResult != null) {
            return this.patchSupportResult;
        }
        this.patchSupportResult = new PatchSupportResult();
        this.patchSupportResult.result = true;
        this.patchSupportResult.unsupportedPatches = new HashMap<PatchPackage, String>();
        return this.patchSupportResult;
    }

    public boolean isSupported() throws ConfigSupportValidationException, PatchSupportValidationException {
        if (!this.isConfigSupported().getResult()) {
            throw new ConfigSupportValidationException("This config is not supported by oplan", null, this.isConfigSupported());
        }
        if (!this.isPatchSupported().getResult()) {
            throw new PatchSupportValidationException("Patch not supported by oplan", null, this.isPatchSupported());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPlanFacade getOplanFacade() throws ConfigSupportValidationException, PatchSupportValidationException {
        if (this.oplanFacade != null) {
            return this.oplanFacade;
        }
        OPlanAccess oPlanAccess = this;
        synchronized (oPlanAccess) {
            if (this.oplanFacade != null) {
                return this.oplanFacade;
            }
            this.oplanFacade = new OPlanFacade(this.oplanIntgFactory, this.tobePatchedSystemInstance, this.patchesBag, this.deploymentType, this.subType, this.operation, this.strategy, this.switchbackAfterMigrate, this.exeMode, this);
        }
        return this.oplanFacade;
    }

    public OPlanIntgFactory getOPlanIntgFactory() {
        return this.oplanIntgFactory;
    }

    public static OPlanAccess getOPlanAccessForConfigCompare(OPlanIntgFactory oplanIntgFactory, SystemInstance firstInstance, SystemInstance secondInstance) {
        return new OPlanAccess(oplanIntgFactory, firstInstance, secondInstance);
    }

    public ConfigCompareResult configurationCompare() throws ConfigCompareException {
        this.logger.fine("Enter configurationCompare");
        ConfigCompareHelper configCompareHelper = this.oplanIntgFactory.getConfigCompareHelper();
        ConfigCompareResult configCompareResult = configCompareHelper.compareIfSystemInstanceAreSame(this.firstInstance, this.secondInstance);
        this.logger.info("isDifferent: " + configCompareResult.isDifferent());
        return configCompareResult;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConfigSupportResult {
        private boolean result;
        private List<Cause> failureCauses;

        public boolean getResult() {
            return this.result;
        }

        public List<Cause> getFailureCauses() {
            return this.failureCauses;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PatchSupportResult {
        boolean result;
        Map<PatchPackage, String> unsupportedPatches;

        public boolean getResult() {
            return this.result;
        }

        public Map<PatchPackage, String> getUnsupportedPatches2Reason() {
            return this.unsupportedPatches;
        }
    }

    public class PatchSupportValidationException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final PatchSupportResult v;

        public PatchSupportValidationException(Throwable throwable, PatchSupportResult v) {
            super(throwable);
            this.v = v;
        }

        public PatchSupportValidationException(String string, Throwable throwable, PatchSupportResult v) {
            super(string, throwable);
            this.v = v;
        }

        public PatchSupportValidationException(String string, PatchSupportResult v) {
            super(string);
            this.v = v;
        }

        public PatchSupportResult getPatchSupportResult() {
            return this.v;
        }
    }

    public class ConfigSupportValidationException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final ConfigSupportResult v;

        public ConfigSupportValidationException(Throwable throwable, ConfigSupportResult v) {
            super(throwable);
            this.v = v;
        }

        public ConfigSupportValidationException(String string, Throwable throwable, ConfigSupportResult v) {
            super(string, throwable);
            this.v = v;
        }

        public ConfigSupportValidationException(String string, ConfigSupportResult v) {
            super(string);
            this.v = v;
        }

        public ConfigSupportResult getConfigSupportResult() {
            return this.v;
        }
    }
}

