/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.common.OracleHome;
import model.patchmodel.GenericPatch;
import oracle.oplan.core.validation.PatchValidationException;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.osysmodel.validation.ValidPlatforms;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsPatchApplicable {
    static Logger logger = Logger.getLogger(IsPatchApplicable.class.getName());
    static List<String> genericPlatformIDList = new ArrayList<String>();

    public boolean isPlatformPatchSameAsRootPlatform() throws PatchValidationException {
        List<GenericPatch> patches = OPlan.getInstance().getOPlanEnv().getPatchesBag().getAllPatches();
        for (GenericPatch patch : patches) {
            if (patch.getSupportedPlatforms() == null || patch.getSupportedPlatforms().isEmpty()) {
                logger.log(Level.WARNING, "The patch " + patch.getPatchID() + "doesn't have supported platforms set.");
                return true;
            }
            if (genericPlatformIDList.contains(patch.getSupportedPlatforms().get(0))) {
                logger.log(Level.INFO, "The patch " + patch.getPatchID() + "can be applied on any platform.");
                continue;
            }
            List ohs = OPlan.getInstance().getSystemInstance().getTargetsOfType(OracleHome.class);
            for (OracleHome oh : ohs) {
                String platform = oh.getARUId();
                if (platform == null || patch.getSupportedPlatforms().contains(platform)) continue;
                Integer platformId = Integer.decode(platform);
                throw new PatchValidationException("The oracle home " + oh.getPath() + " has a platform " + ValidPlatforms.getDescription((int)platformId) + " that is not one of the " + "supported platform for the given patch: " + this.getDescription(patch.getSupportedPlatforms()));
            }
        }
        return true;
    }

    private List<String> getDescription(List<String> platformIds) {
        ArrayList<String> platforms = new ArrayList<String>();
        for (String platform : platformIds) {
            platforms.add(ValidPlatforms.getDescription((int)Integer.decode(platform)));
        }
        return platforms;
    }

    static {
        genericPlatformIDList.add("0");
        genericPlatformIDList.add("289");
        genericPlatformIDList.add("2000");
    }
}

