/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.readme;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.common.OracleHome;
import model.db_crs.RACDatabase;
import oracle.opatch.system.automation.jaxb.DeploymentType;
import oracle.opatch.system.automation.jaxb.Operation;
import oracle.oplan.core.readme.ReadmeDecorator;
import oracle.oplan.core.readme.ReadmeGeneratorBase;
import oracle.oplan.core.ui.tree.TextTreeGenerator;
import oracle.oplan.sdk.exec.api.ExecutionPhase;
import oracle.oplan.sdk.exec.api.ExecutionPlan;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.exec.api.ExeuctionPlanUtil;
import oracle.oplan.sdk.exec.api.GroupByHost;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanEnv;
import oracle.oplan.sdk.readme.ReadmeFactory;
import oracle.oplan.sdk.resource.OPlanBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextReadmeGenerator
extends ReadmeGeneratorBase {
    private static final Class c = TextReadmeGenerator.class;
    static Logger logger = Logger.getLogger(TextReadmeGenerator.class.getName());
    protected static final String TAB_CHAR = "   ";
    private String li = "\n   * ";
    protected String textTree;
    protected boolean subReadmeFile = true;

    public TextReadmeGenerator(ReadmeFactory rf) {
        super(rf);
        this.setDecoratorContext(new ReadmeDecorator());
    }

    @Override
    public List<File> generateReadme() throws IOException {
        ArrayList<File> readmeList = new ArrayList<File>();
        List<Set<String>> splitHostList = this.rf.getSplitHostList();
        for (int i = 0; i < splitHostList.size(); ++i) {
            Set<String> filterHosts = splitHostList.get(i);
            this.setCurrentFilterHosts(filterHosts);
            File readme = null;
            readme = this.rf.isSplit() ? this.getReadmeFile(i + 1) : this.getReadmeFile();
            assert (!readme.isFile());
            this.generateConfigImageFile();
            this.writeOnePlan(readme, this.rf.getSingleExecutionPlan());
            readmeList.add(readme);
        }
        return readmeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeOnePlan(File readme, ExecutionPlan plan) throws IOException {
        FileWriter fw = new FileWriter(readme);
        try {
            this.writeProductName(fw);
            this.writeTitle(fw, plan);
            this.writeTraditionalReadmeNotice(fw);
            this.writeUseHTML(fw, readme);
            this.writePlanBlurb(fw, plan, true, false);
            this.writePlanNote(fw, plan);
            fw.write("\n\n");
            this.writeConfigImage(fw, plan);
            this.writeTOC(fw, plan);
            this.writeBody(fw, plan);
            this.writeCopyRight(fw);
        }
        finally {
            fw.close();
        }
    }

    @Override
    protected File getReadmeFile() {
        return OPlan.getInstance().getLogInfo().getReadmeTxt();
    }

    protected File getReadmeFile(int index) {
        return OPlan.getInstance().getLogInfo().getReadmeTxt(index);
    }

    protected void generateConfigImageFile() {
        this.textTree = this.getConfigTextTree();
    }

    protected void writeConfigImage(FileWriter fw, ExecutionPlan plan) throws IOException {
        String str = OPlanBundle.getReadmeMessage("CONFIG_IMAGE_HEADER", new Object[0]);
        fw.write(str + "\n" + TextReadmeGenerator.underline(str));
        fw.write("\n");
        fw.write(OPlanBundle.getReadmeMessage("CONFIG_IMAGE_DESCRIPTION", "*", "*", ""));
        fw.write("\n\n");
        this.writeStatMessage(fw, plan);
        fw.write(this.textTree);
        this.writeWarningMessage(fw);
        fw.write("\n");
    }

    protected String getConfigTextTree() {
        logger.finest("Starting: generate config tree text.");
        TextTreeGenerator tg = new TextTreeGenerator();
        TextTreeGenerator.TreeNodeLabelResolver res = new TextTreeGenerator.TreeNodeLabelResolver(){

            public String getLabel(DefaultMutableTreeNode node) {
                AbstractBaseTarget abt;
                AbstractBaseTarget abstractBaseTarget = abt = node.getUserObject() instanceof AbstractBaseTarget ? (AbstractBaseTarget)node.getUserObject() : null;
                if (abt == null) {
                    return "unknown entity";
                }
                String prefix = OPlan.getInstance().getOPlanIntgFactory().getSystemInstance2UI().getDisplayString(abt);
                prefix = prefix == null ? abt.getClass().getSimpleName() + ": " : prefix + ": ";
                String str = abt instanceof OracleHome ? ((OracleHome)abt).getPath() + " (" + ((OracleHome)abt).getDescription() + ")" : abt.getDisplayName();
                str = prefix + str;
                return str;
            }
        };
        tg.setTreeNodeLabelResolver(res);
        String tree = tg.getTreeText(this.rf.getConfigTree());
        logger.finest("End: generate config tree text.");
        return tree;
    }

    protected void writeTitle(FileWriter fw, ExecutionPlan plan) throws IOException {
        DateFormat date = DateFormat.getDateTimeInstance(0, 0);
        String created = date.format(new Date(System.currentTimeMillis()));
        OPlanEnv env = this.getOplanEnv();
        fw.write("\n\n");
        String msg = "";
        if (this.subReadmeFile) {
            msg = "DETAILED_" + ReadmeFactory.getOperationBundlePropertySuffixKey(plan) + "_STEPS_HEADER";
            msg = OPlanBundle.getPrefixedMessage(TextReadmeGenerator.class, this.rf.getBundleMessagePrefix(plan), msg, new Object[0]);
            msg = OPlanBundle.getPrefixedMessage(TextReadmeGenerator.class, this.rf.getBundleMessagePrefix(plan), "SUB_README_TITLE", msg, "'" + env.getPatchesBag().getPatchesListAsString() + "'", "'" + this.getTargetName(plan) + "'");
        } else {
            msg = OPlanBundle.getPrefixedMessage(TextReadmeGenerator.class, ReadmeFactory.getOperationBundlePropertySuffixKey(plan), "README_TITLE", "'" + env.getPatchesBag().getPatchesListAsString() + "'", "'" + this.getTargetName(plan) + "'");
        }
        fw.write(msg + "\n" + TextReadmeGenerator.underline(msg));
        fw.write("\n");
        fw.write(OPlanBundle.getReadmeMessage("README_GEN_STATS", created, "'" + System.getProperty("user.name") + "'", "'" + env.getLocalHost() + "'", "'" + env.getOperation().value() + "'", env.getOPlanVersion()));
        fw.write("\n\n");
    }

    protected void writeStatMessage(FileWriter fw, ExecutionPlan plan) throws IOException {
        fw.write(OPlanBundle.getReadmeMessage("README_CONTENT_STATS", "'" + this.rf.getSystemInstanceEntityCount() + "'", "'" + this.getTargetName(plan) + "'"));
        fw.write("\n\n");
    }

    protected void writeUseHTML(FileWriter fw, File readme) throws IOException {
        String readmeFileName = readme.getName();
        String fileNameWithoutPostfix = readmeFileName.split("\\.")[0];
        String[] fileNameArray = fileNameWithoutPostfix.split("_");
        int fileIndex = -1;
        if (fileNameArray != null && fileNameArray.length == 2) {
            fileIndex = Integer.valueOf(fileNameArray[1]);
        }
        if (OPlan.getInstance().getLogInfo() != null) {
            if (fileIndex > 0) {
                fw.write(OPlanBundle.getReadmeMessage("USE_HTML_MESSAGE", OPlan.getInstance().getLogInfo().getReadmeHtml(fileIndex).getAbsolutePath()));
            } else {
                fw.write(OPlanBundle.getReadmeMessage("USE_HTML_MESSAGE", OPlan.getInstance().getLogInfo().getReadmeHtml().getAbsolutePath()));
            }
        }
    }

    protected void writeTOC(FileWriter fw, ExecutionPlan plan) throws IOException {
        String operation = ReadmeFactory.getOperationBundlePropertySuffixKey(plan);
        String msg = OPlanBundle.getPrefixedMessage(TextReadmeGenerator.class, this.rf.getBundleMessagePrefix(plan), "PATCH_" + operation + "_SUMMARY_HEADER", new Object[0]);
        fw.write(msg + "\n" + TextReadmeGenerator.underline(msg));
        fw.write("\n\n");
        int phaseNo = 1;
        Set<String> filterHosts = this.getCurrentFilterHosts();
        this.rf.changeHostOfPostPhase(plan);
        for (ExecutionPhase phase : plan.getExecutionPhase()) {
            GroupByHost hgrp = GroupByHost.getInstance(phase, filterHosts);
            if (hgrp.getHostGrouping().size() != 0) {
                String phaseName = this.getPhaseTitle(phase);
                String downtime = this.getDowntime(phase);
                fw.write(TAB_CHAR + this.STEP + phaseNo + ": " + phaseName + downtime + "\n");
                if (hgrp.isWorthGrouping()) {
                    int group = 1;
                    for (GroupByHost.HostGroup hostGroup : hgrp.getHostGrouping()) {
                        Host host = hostGroup.getHost();
                        String hostName = host == null ? "$HOST_NAME" : host.getDisplayName();
                        fw.write("      " + this.STEP + phaseNo + "." + group + ": " + phaseName + " on " + hostName + "\n");
                        this.writeTOCTitleMessages(fw, hostGroup.getExecSteps(), "         " + this.STEP + phaseNo + "." + group);
                        ++group;
                        fw.write("\n");
                    }
                } else {
                    this.writeTOCTitleMessages(fw, phase.getExecutionStep(), "      " + this.STEP + phaseNo);
                }
                ++phaseNo;
            }
            fw.write("\n");
        }
    }

    protected void writeTOCTitleMessages(FileWriter fw, List<ExecutionStep> steps, String stepPrefix) throws IOException {
        int stepNo = 1;
        for (ExecutionStep step : steps) {
            fw.write(stepPrefix + "." + stepNo + ": " + this.getTitle(step) + "\n");
            ++stepNo;
        }
    }

    protected void writeMessageBody(FileWriter fw, List<ExecutionStep> steps, String stepPrefix, int indent) throws IOException {
        int stepNo = 1;
        for (ExecutionStep step : steps) {
            List<ExecutionStep.Command> shellCommands;
            fw.write(this.indt(indent) + stepPrefix + "." + stepNo + ": " + this.getTitle(step) + "\n\n");
            if (this.getMessage(step) != null) {
                fw.write(this.indt(indent + 1) + this.getMessage(step) + "\n\n");
            }
            if ((shellCommands = step.getCommand()) != null) {
                String userName = "";
                if (step.getUser() != null && step.getUser().getValue() != null) {
                    userName = step.getUser().getValue();
                }
                String prefix = shellCommands.size() > 1 ? "COMMANDS_USER_HOST_INFO" : "COMMAND_USER_HOST_INFO";
                prefix = OPlanBundle.getReadmeMessage(prefix, userName, step.getHost().getDisplayName(), "'", "'");
                boolean haveWritten = false;
                String ind = this.indt(indent + 2);
                for (ExecutionStep.Command cmd : shellCommands) {
                    if (cmd == null || cmd.getValue() == null || cmd.getValue().trim().equals("")) continue;
                    if (!haveWritten) {
                        fw.write(ind + prefix);
                        fw.write("\n\n");
                        haveWritten = true;
                    }
                    if (cmd.getType().isNonShellPrompt()) {
                        fw.write(ind + cmd.getType().getPrompt(step) + " ");
                    } else {
                        fw.write(ind + "[" + userName + "@" + step.getHost().getDisplayName() + "]" + cmd.getType().getPrompt(step) + " ");
                    }
                    fw.write("\n");
                    fw.write(ind + cmd.getValue() + "\n\n");
                    String error = this.getCommandErrorMessage(cmd, step);
                    if (error == null) continue;
                    fw.write(ind + error + "\n");
                }
            }
            fw.write("\n");
            if (this.getTroubleshoot(step) != null) {
                fw.write(this.indt(indent + 1) + this.TROUBLE + ":" + this.getTroubleshoot(step) + "\n\n\n");
            }
            ++stepNo;
        }
    }

    protected String indt(int i) {
        StringBuilder sb = new StringBuilder();
        while (i > 0) {
            sb.append(TAB_CHAR);
            --i;
        }
        return sb.toString();
    }

    protected void writeBody(FileWriter fw, ExecutionPlan plan) throws IOException {
        String operation = ReadmeFactory.getOperationBundlePropertySuffixKey(plan);
        fw.write("\n\n");
        String msg = OPlanBundle.getPrefixedMessage(TextReadmeGenerator.class, this.rf.getBundleMessagePrefix(plan), "DETAILED_" + operation + "_STEPS_HEADER", new Object[0]);
        fw.write(msg + "\n" + TextReadmeGenerator.underline(msg));
        fw.write("\n\n");
        int phaseNo = 1;
        Set<String> filterHosts = this.getCurrentFilterHosts();
        this.rf.changeHostOfPostPhase(plan);
        for (ExecutionPhase phase : plan.getExecutionPhase()) {
            GroupByHost hgrp = GroupByHost.getInstance(phase, filterHosts);
            if (hgrp.getHostGrouping().size() == 0) continue;
            String phaseName = this.getPhaseTitle(phase);
            String downtime = this.getDowntime(phase);
            fw.write(this.STEP + phaseNo + ": " + phaseName + downtime + "\n\n");
            if (hgrp.isWorthGrouping()) {
                int group = 1;
                for (GroupByHost.HostGroup host : hgrp.getHostGrouping()) {
                    String hostName = host.getHost() == null ? "$HOST_NAME" : host.getHost().getDisplayName();
                    fw.write(TAB_CHAR + this.STEP + phaseNo + "." + group + ": " + phaseName + " on '" + hostName + "'\n\n");
                    this.writeMessageBody(fw, host.getExecSteps(), this.STEP + phaseNo + "." + group, 2);
                    ++group;
                }
            } else {
                this.writeMessageBody(fw, phase.getExecutionStep(), this.STEP + phaseNo, 1);
            }
            ++phaseNo;
        }
    }

    public static String underline(String msg) {
        if (msg == null || msg.equals("")) {
            return "";
        }
        return TextReadmeGenerator.underline(msg.length());
    }

    public static String underline(int len) {
        StringBuilder buffer = new StringBuilder();
        for (int i = len; i >= 0; --i) {
            buffer.append("-");
        }
        buffer.append("\n");
        return buffer.toString();
    }

    protected void writePlanBlurb(FileWriter fw, ExecutionPlan plan, boolean writeDTIntro, boolean writeReferToSec) throws IOException {
        String mesg;
        if (plan.getAutomation().getOperation().equals((Object)Operation.SWITCHBACK)) {
            this.writeSwitchbackBlurb(fw, plan, true, writeReferToSec);
            return;
        }
        String prefix = this.rf.getBundleMessagePrefix(plan);
        fw.write("\n");
        String title = OPlanBundle.getPrefixedMessage(c, prefix, "TITLE", "", "");
        fw.write(title + ":\n");
        fw.write(TextReadmeGenerator.underline(title));
        if (writeDTIntro) {
            for (String str : this.getPlanDescriptions(plan)) {
                fw.write(this.li + str);
            }
        }
        if ((mesg = OPlanBundle.getPrefixedMessage(c, prefix, "MESSAGE", "", "")) != null && !mesg.trim().equals("")) {
            fw.write(this.li);
            fw.write(mesg);
        }
        fw.write("\n");
        fw.write(this.li);
        fw.write(OPlanBundle.getPrefixedMessage(c, prefix, "THIS_STRATEGY_IS_OPT_FOR", "", ""));
        fw.write(OPlanBundle.getPrefixedMessage(c, prefix, "OPT", "", ""));
        fw.write(this.li);
        fw.write(OPlanBundle.getPrefixedMessage(c, prefix, "THIS_STRATEGY_IS_NOT_OPT_FOR", "", ""));
        fw.write(OPlanBundle.getPrefixedMessage(c, prefix, "NOPT", "", ""));
        this.writePlanStats(fw, plan);
        if (writeReferToSec) {
            fw.write("\n\n   ");
            fw.write(OPlanBundle.getReadmeMessage("REFER_TO_DETAILED", title, this.rf.getFileForTxtInstructions(plan).getAbsolutePath()));
        }
        fw.write("\n\n");
    }

    protected void writeSwitchbackBlurb(FileWriter fw, ExecutionPlan plan, boolean writeNewline, boolean writeReferToSec) throws IOException {
        String prefix = this.rf.getBundleMessagePrefix(plan);
        if (writeNewline) {
            fw.write("\n");
        }
        String title = OPlanBundle.getPrefixedMessage(c, prefix, "TITLE", "", "");
        fw.write(TAB_CHAR + OPlanBundle.getPrefixedMessage(c, prefix, "MESSAGE", new Object[0]));
        if (writeReferToSec) {
            fw.write("\n\n   ");
            fw.write(OPlanBundle.getReadmeMessage("REFER_TO_DETAILED", title, this.rf.getFileForTxtInstructions(plan).getAbsolutePath()));
        }
        fw.write("\n\n");
    }

    private void writePlanNote(FileWriter fw, ExecutionPlan plan) throws IOException {
        String prefix = this.rf.getBundleMessagePrefix(plan);
        String global = OPlanBundle.getMessageNE(c, "GLOBAL_PLAN_NOTE", " * ", "", "'", "'");
        String local = OPlanBundle.getPrefixedMessageNE(c, prefix, "PLAN_NOTE", " * ", "", "'", "'");
        boolean writeSwitchbackNote = false;
        ExecutionPlan sbplan = ExeuctionPlanUtil.first(ExeuctionPlanUtil.switchbacks(this.rf.getPlans()));
        if (DeploymentType.OUT_OF_PLACE.equals((Object)plan.getAutomation().getDeploymentType()) && Operation.APPLY.equals((Object)plan.getAutomation().getOperation()) && sbplan != null) {
            writeSwitchbackNote = true;
            local = null;
        }
        if (global != null || local != null || writeSwitchbackNote) {
            String str = OPlanBundle.getReadmeMessage("IMPORTANT_NOTE", new Object[0]);
            fw.write(str + "\n");
            fw.write(TextReadmeGenerator.underline(str));
            fw.write("\n");
            if (global != null) {
                fw.write(global);
                fw.write("\n");
            }
            if (local != null) {
                fw.write(local);
                fw.write("\n");
            }
            if (writeSwitchbackNote) {
                String tmp = OPlanBundle.getPrefixedMessageNE(c, prefix, "OplaceApplyRolling-SWITCHBACK-PLAN_NOTE", " * ", "", "'", "'");
                fw.write(tmp);
                fw.write(" * ");
                this.writeSwitchbackBlurb(fw, sbplan, false, true);
            }
        }
    }

    protected void writeCopyRight(FileWriter fw) throws IOException {
        fw.write("\n");
        fw.write(TextReadmeGenerator.underline(100));
        fw.write(OPlanBundle.getReadmeMessage("COPY_RIGHT_MESSAGE_TEXT", new Object[0]));
    }

    protected void writeProductName(FileWriter fw) throws IOException {
        String prod = OPlanBundle.getReadmeMessage("PRODUCT_NAME", new Object[0]);
        fw.write(prod);
        fw.write("\n");
    }

    protected void writePlanStats(FileWriter fw, ExecutionPlan plan) throws IOException {
        List<String> strs = this.rf.getStepsStats(plan, "", "");
        assert (strs.size() > 1);
        fw.write(this.li);
        fw.write(strs.get(0));
        for (int i = 1; i < strs.size(); ++i) {
            fw.write("\n      * ");
            fw.write(strs.get(i));
        }
    }

    protected String getDowntime(ExecutionPhase phase) {
        String downtime = this.rf.getDowntime(phase);
        return " (" + downtime + ")";
    }

    protected void writeTraditionalReadmeNotice(FileWriter fw) throws IOException {
        fw.write("\n");
        if (this.rf.getPatchReadme() != null) {
            fw.write(OPlanBundle.getReadmeMessage("REFER_TO_PATCH_README", "patch README located at " + this.rf.getPatchReadme().getAbsolutePath() + " ", "*", "*"));
        } else {
            fw.write(OPlanBundle.getReadmeMessage("REFER_TO_PATCH_README", "patch README ", "*", "*"));
        }
        fw.write("\n");
    }

    private void writeWarningMessage(FileWriter fw) throws IOException {
        fw.write("\n");
        if (OPlan.getInstance().getOPlanEnv().getSkippedTargetMap().get(RACDatabase.class) != null && OPlan.getInstance().getOPlanEnv().getSkippedTargetMap().get(RACDatabase.class).size() > 0) {
            List<String> skipedRacs = OPlan.getInstance().getOPlanEnv().getSkippedTargetMap().get(RACDatabase.class);
            StringBuffer skipedRacStr = null;
            for (String skipedRac : skipedRacs) {
                if (skipedRacStr == null) {
                    skipedRacStr = new StringBuffer(skipedRac);
                    continue;
                }
                skipedRacStr.append("," + skipedRac);
            }
            fw.write(OPlanBundle.getReadmeMessage("SKIP_TARGET_WARNING", "RAC Database " + skipedRacStr.toString(), "Oracle Cluster", "*", "*"));
        }
        fw.write("\n");
    }
}

