/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.readme;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.oplan.sdk.exec.api.ExecutionPhase;
import oracle.oplan.sdk.exec.api.ExecutionPlan;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.exec.api.GroupByHost;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanEnv;
import oracle.oplan.sdk.readme.ReadmeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cmds2Script {
    private static ReadmeFactory rf = ReadmeFactory.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> cmds2ScriptFile(ExecutionPlan plan) throws IOException {
        ArrayList<File> scriptFileList = new ArrayList<File>();
        if (Cmds2Script.splitHost()) {
            List<Set<String>> splitHostList = rf.getSplitHostList();
            for (int i = 0; i < splitHostList.size(); ++i) {
                OutputStreamWriter fw = null;
                try {
                    HashSet filterHosts = (HashSet)splitHostList.get(i);
                    File ret = Cmds2Script.getScriptFile(plan, i + 1);
                    fw = new FileWriter(ret);
                    Cmds2Script.writeCmds((FileWriter)fw, plan, filterHosts);
                    scriptFileList.add(ret);
                    continue;
                }
                finally {
                    fw.close();
                }
            }
        } else {
            OutputStreamWriter fw = null;
            try {
                File ret = Cmds2Script.getScriptFile(plan);
                fw = new FileWriter(ret);
                Cmds2Script.writeCmds((FileWriter)fw, plan);
                scriptFileList.add(ret);
            }
            finally {
                fw.close();
            }
        }
        return scriptFileList;
    }

    public static void cmds2ScriptFile(File file, ExecutionPlan plan) throws IOException {
        FileWriter fw = new FileWriter(file);
        try {
            Cmds2Script.writeCmds(fw, plan);
        }
        finally {
            fw.close();
        }
    }

    protected static boolean splitHost() {
        OPlanEnv env = OPlan.getInstance().getOPlanEnv();
        return env.getProperty("NodeNumberPerReadme") != null && Integer.valueOf(env.getProperty("NodeNumberPerReadme")) > 0;
    }

    private static File getScriptFile(ExecutionPlan plan) {
        return new File(OPlan.getInstance().getLogInfo().getHiddenFilesDir(), ReadmeFactory.getInstance().getBundleMessagePrefix(plan) + ".tmp");
    }

    private static File getScriptFile(ExecutionPlan plan, int index) {
        return new File(OPlan.getInstance().getLogInfo().getHiddenFilesDir(), ReadmeFactory.getInstance().getBundleMessagePrefix(plan) + "_" + index + ".tmp");
    }

    private static void writeCmds(FileWriter fw, ExecutionPlan plan, Set<String> filterHosts) throws IOException {
        int phaseNo = 1;
        rf.changeHostOfPostPhase(plan);
        for (ExecutionPhase phase : plan.getExecutionPhase()) {
            GroupByHost hgrp = GroupByHost.getInstance(phase, filterHosts);
            if (hgrp.getHostGrouping().size() == 0) continue;
            fw.write("_:\n");
            if (hgrp.isWorthGrouping()) {
                int group = 1;
                for (GroupByHost.HostGroup hostGroup : hgrp.getHostGrouping()) {
                    fw.write("_._:\n");
                    Cmds2Script.writeCmds(fw, hostGroup.getExecSteps(), "_._");
                    ++group;
                }
            } else {
                Cmds2Script.writeCmds(fw, phase.getExecutionStep(), "_");
            }
            ++phaseNo;
        }
    }

    private static void writeCmds(FileWriter fw, ExecutionPlan plan) throws IOException {
        int phaseNo = 1;
        for (ExecutionPhase phase : plan.getExecutionPhase()) {
            fw.write("_:\n");
            GroupByHost hgrp = GroupByHost.getInstance(phase);
            if (hgrp.isWorthGrouping()) {
                int group = 1;
                for (GroupByHost.HostGroup hostGroup : hgrp.getHostGrouping()) {
                    fw.write("_._:\n");
                    Cmds2Script.writeCmds(fw, hostGroup.getExecSteps(), "_._");
                    ++group;
                }
            } else {
                Cmds2Script.writeCmds(fw, phase.getExecutionStep(), "_");
            }
            ++phaseNo;
        }
    }

    private static void writeCmds(FileWriter fw, List<ExecutionStep> steps, String stepPrefix) throws IOException {
        int stepNo = 1;
        for (ExecutionStep step : steps) {
            fw.write(stepPrefix + "._:\n");
            fw.write("## " + step.getUser().getValue() + "@" + step.getHost().getHostName() + "\n");
            for (ExecutionStep.Command cmd : step.getCommand()) {
                if (cmd == null || cmd.getValue() == null || cmd.getValue().trim().equals("")) continue;
                fw.write(cmd.getValue().trim() + "\n");
            }
            ++stepNo;
        }
    }
}

