/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.patch;

import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import oracle.oplan.sdk.patch.Patchmd;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class PatchInventory {
    private final String OH_VAR_NAME = "ORACLE_HOME";
    public final String OH_VAR = "$ORACLE_HOME";
    Logger logger = Logger.getLogger(Patchmd.class.getName());
    private String xmlContent;
    private boolean init = false;
    private Document doc;
    private XPath xpath;
    private String patchID;
    private String constituentID;
    private String minimumOPatchVersion;
    Boolean rollingPatch;
    Boolean instanceShutdownPatch;
    Boolean sqlPatch;
    Boolean sqlPatchInUpgradeMode = false;
    Boolean sqlPatchMigrate = false;

    public PatchInventory(String xmlContent) {
        this.xmlContent = xmlContent;
    }

    private void init() throws PatchInventoryException {
        if (this.init) {
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(this.xmlContent));
            this.doc = builder.parse(is);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            this.xpath = xPathfactory.newXPath();
            this.initPathcID();
            this.initConstituentID();
            this.initMinimumOPatchVersion();
            this.initInstanceShutdownPatch();
            this.initSqlPatch();
            this.initRollingPatch();
            this.initSqlPatchInUpgradeMode();
            this.initSqlPatchMigrate();
            this.doc = null;
            this.xpath = null;
            this.xmlContent = null;
            this.init = true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception while parsing patchmd.xml.", e);
            throw new PatchInventoryException(e);
        }
    }

    private void initPathcID() throws XPathExpressionException, PatchInventoryException {
        XPathExpression getPatchID = this.xpath.compile("/oneoff_inventory/patch_id/@number");
        this.patchID = getPatchID.evaluate(this.doc);
        if (this.patchID == null || this.patchID.length() == 0) {
            getPatchID = this.xpath.compile("/oneoff_inventory/reference_id/@number");
            this.patchID = getPatchID.evaluate(this.doc);
        }
        if (this.patchID == null || this.patchID.length() == 0) {
            throw new PatchInventoryException("Patch number not found in the inventory.xml");
        }
    }

    private void initConstituentID() throws XPathExpressionException, PatchInventoryException {
        XPathExpression getConstituentID = this.xpath.compile("/oneoff_inventory/constituent/@active");
        this.constituentID = getConstituentID.evaluate(this.doc);
        if (this.constituentID == null || this.constituentID.length() == 0) {
            getConstituentID = this.xpath.compile("/oneoff_inventory/constituent/@active");
            this.constituentID = getConstituentID.evaluate(this.doc);
        }
    }

    private void initMinimumOPatchVersion() throws XPathExpressionException, PatchInventoryException {
        XPathExpression getMinimumOPatchVersion = this.xpath.compile("/oneoff_inventory/minimum_opatch_version");
        this.minimumOPatchVersion = getMinimumOPatchVersion.evaluate(this.doc);
    }

    private void initInstanceShutdownPatch() throws XPathExpressionException {
        String instanceShutdownElement = "/oneoff_inventory/instance_shutdown";
        String instanceShutdown = this.getElementValueByXPath(instanceShutdownElement);
        if (instanceShutdown == null || instanceShutdown.length() == 0) {
            this.instanceShutdownPatch = true;
        }
        this.instanceShutdownPatch = Boolean.parseBoolean(instanceShutdown);
    }

    private void initSqlPatch() throws XPathExpressionException {
        String sqlPatchElement = "/oneoff_inventory/sql_patch";
        String sqlPatchValue = this.getElementValueByXPath(sqlPatchElement);
        if (sqlPatchValue == null || sqlPatchValue.length() == 0) {
            this.sqlPatch = true;
        }
        this.sqlPatch = Boolean.parseBoolean(sqlPatchValue);
    }

    private void initSqlPatchInUpgradeMode() throws XPathExpressionException {
        String sqlPatchElement = "/oneoff_inventory/sql_patch_database_startup_mode";
        String sqlPatchValue = this.getElementValueByXPath(sqlPatchElement);
        this.sqlPatchInUpgradeMode = sqlPatchValue != null && sqlPatchValue.equalsIgnoreCase("upgrade") ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    private void initSqlPatchMigrate() throws XPathExpressionException {
        String sqlPatchElement = "/oneoff_inventory/sql_migrate";
        String sqlPatchValue = this.getElementValueByXPath(sqlPatchElement);
        this.sqlPatchMigrate = sqlPatchValue != null && sqlPatchValue.equalsIgnoreCase("true") ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    private void initRollingPatch() throws XPathExpressionException {
        String rollingPatchElement = "/oneoff_inventory/online_rac_installable";
        String rollingPatchValue = this.getElementValueByXPath(rollingPatchElement);
        if (rollingPatchValue == null || rollingPatchValue.length() == 0) {
            this.rollingPatch = true;
        }
        this.rollingPatch = Boolean.parseBoolean(rollingPatchValue);
    }

    private String getElementValueByXPath(String pathExpression) throws XPathExpressionException {
        XPathExpression xpathExpression = this.xpath.compile(pathExpression);
        String value = xpathExpression.evaluate(this.doc);
        return value;
    }

    public boolean isInstanctShutdownPatch() {
        this.init();
        return this.instanceShutdownPatch;
    }

    public boolean isSqlPatch() {
        this.init();
        return this.sqlPatch;
    }

    public boolean issqlPatchInUpgradeMode() {
        this.init();
        return this.sqlPatchInUpgradeMode;
    }

    public boolean issqlPatchMigrate() {
        this.init();
        return this.sqlPatchMigrate;
    }

    public boolean isRollingPatch() {
        this.init();
        return this.rollingPatch;
    }

    public String getPatchID() throws PatchInventoryException {
        this.init();
        return this.patchID;
    }

    public String getConstituentID() throws PatchInventoryException {
        this.init();
        return this.constituentID;
    }

    public String getMinimumOPatchVersion() throws PatchInventoryException {
        this.init();
        return this.minimumOPatchVersion;
    }

    public static class PatchInventoryException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PatchInventoryException(Throwable t) {
            super(t);
        }

        private PatchInventoryException(String string) {
            super(string);
        }
    }
}

