/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.patch;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import model.patchmodel.OPatchSingleton;
import model.patchmodel.PatchPackage;
import model.patchmodel.PatchingTool;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchPlatform;
import oracle.opatch.opatchsdk.SQLPatchStartupMode;
import oracle.oplan.core.oplan.IOUtils;
import oracle.oplan.core.patch.PatchInventory;
import oracle.oplan.core.patch.PatchUtils;
import oracle.oplan.sdk.intg.OPlanIntgFactory;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.osysmodel.patchsdk.PatchPackageException;
import oracle.osysmodel.patchsdk.PatchValidatorAndGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPatchSingletonPatchValidatorAndGenerator
implements PatchValidatorAndGenerator {
    static Logger logger = Logger.getLogger(OPatchSingletonPatchValidatorAndGenerator.class.getName());
    private final String INV_XML = "etc" + File.separator + "config" + File.separator + "inventory.xml";
    private final String PATCHMD_XML = "patchmd.xml";
    private final String AUTOMATIONXML_FOLDER = "automation";
    private final String BUNDLE_XML = "bundle.xml";
    private final String RESOURCE_BUNDLE = "messages.properties";
    public static final String INV_XML_NAME = "inventory.xml";

    public boolean isPatchValid(String patchLocation) throws PatchPackageException {
        assert (patchLocation != null);
        File patchDir = new File(patchLocation);
        if (!patchDir.exists()) {
            throw new PatchPackageException("Patch Location " + patchLocation + " does not exist.");
        }
        if (!patchDir.isDirectory()) {
            throw new PatchPackageException("Patch Location " + patchLocation + " does not represent a directory");
        }
        StringBuffer inventoryXMLLoc = new StringBuffer(patchLocation);
        inventoryXMLLoc.append(File.separator);
        inventoryXMLLoc.append(this.INV_XML);
        File invxml = new File(inventoryXMLLoc.toString());
        if (invxml.exists()) {
            logger.log(Level.INFO, "inventory.xml found at " + inventoryXMLLoc.toString() + " which implies it is an OPatch Singleton patch");
            return true;
        }
        return false;
    }

    public boolean isMethodValid(Class className, String method, Class[] parameterTypes) {
        try {
            className.getMethod(method, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    public PatchPackage generate(String patchLocation) throws PatchPackageException {
        File automationXmlFolderLocation;
        assert (patchLocation != null);
        File patchDir = new File(patchLocation);
        if (!patchDir.exists()) {
            throw new PatchPackageException("The given patchLocation " + patchLocation + " does not exist");
        }
        if (!patchDir.isDirectory()) {
            throw new PatchPackageException("The given patchLocation " + patchLocation + " does not represent a directory");
        }
        OPatchSingleton patch = new OPatchSingleton();
        try {
            OPatchPatch[] opatchPatches = OPatchPatch.getPatchesNoSymbolResolve((String)patchLocation);
            OPatchPatch opatchPatch = opatchPatches[0];
            patch.setPatchLocation(patchLocation);
            patch.setPatchTool(this.getPatchTool());
            patch.setPatchID(opatchPatch.getPatchId());
            if (opatchPatch.getMinimumOPatchVersion() != null) {
                patch.setMinimumOPatchVersion(opatchPatch.getMinimumOPatchVersion().getVerString());
            }
            patch.setRollingPatch(Boolean.valueOf(opatchPatch.isRollingPatch()));
            patch.setInstanceShutdownPatch(Boolean.valueOf(opatchPatch.isInstanceShutdownPatch()));
            if (this.isMethodValid(opatchPatch.getClass(), "isSqlPatch", null)) {
                patch.setSqlPatch(Boolean.valueOf(opatchPatch.isSqlPatch()));
            } else {
                patch.setSqlPatch(Boolean.valueOf(true));
            }
            if (opatchPatch.isSqlPatch()) {
                SQLPatchStartupMode mode = opatchPatch.getSqlPatchDatabaseStartupMode();
                if (mode.equals((Object)SQLPatchStartupMode.UPGRADE)) {
                    patch.setSqlPatchUpgradeMode(Boolean.valueOf(true));
                } else {
                    patch.setSqlPatchUpgradeMode(Boolean.valueOf(false));
                }
            } else {
                patch.setSqlPatchUpgradeMode(Boolean.valueOf(false));
            }
            ArrayList<String> supportedPlatforms = new ArrayList<String>();
            OPatchPlatform[] platformList = opatchPatch.getPlatforms();
            if (platformList != null && platformList.length > 0) {
                for (int i = 0; i < platformList.length; ++i) {
                    supportedPlatforms.add(platformList[i].getID());
                }
            }
            patch.setSupportedPlatforms(supportedPlatforms);
        }
        catch (OPatchException e) {
            throw new PatchPackageException(e.getMessage(), (Throwable)e);
        }
        File patchmdxml = new File(patchDir, "patchmd.xml");
        if (patchmdxml.isFile()) {
            try {
                patch.setPatchMDxml(IOUtils.getContent(new FileInputStream(patchmdxml)).toString());
            }
            catch (IOException e) {
                throw new PatchPackageException("Exception while reading patchmd.xml", (Throwable)e);
            }
        }
        File postinstall = new File(patchDir, "postinstall.sql");
        File postdeinstall = new File(patchDir, "postdeinstall.sql");
        if (postinstall.exists() && postinstall.isFile() && postdeinstall.exists() && postdeinstall.isFile()) {
            patch.setWrapperSqlPath(patchDir.getName());
        }
        if ((automationXmlFolderLocation = new File(patchDir, "automation")).exists()) {
            if (!automationXmlFolderLocation.isDirectory()) {
                throw new PatchPackageException(automationXmlFolderLocation.getAbsolutePath() + " exists but is not a folder");
            }
            if (automationXmlFolderLocation.listFiles() == null || automationXmlFolderLocation.listFiles().length == 0) {
                throw new PatchPackageException(automationXmlFolderLocation.getAbsolutePath() + " exists but does not contain any automationXmls.");
            }
            ArrayList<String> automationXmls = new ArrayList<String>();
            patch.setAutomationXmlLocation(automationXmlFolderLocation.getAbsolutePath());
            for (File file : automationXmlFolderLocation.listFiles()) {
                if (!file.isFile()) continue;
                try {
                    if ("messages.properties".equals(file.getName())) {
                        patch.setResourceBundle(IOUtils.getContent(new FileInputStream(file)).toString());
                        continue;
                    }
                    automationXmls.add(IOUtils.getContent(new FileInputStream(file)).toString());
                }
                catch (IOException e) {
                    throw new PatchPackageException("Couldn't read the file from automation folder", (Throwable)e);
                }
            }
            patch.setAutoXmls(automationXmls);
        } else {
            patch.setAutomationXmlLocation(null);
        }
        ArrayList applicableTargets = new ArrayList();
        patch.setApplicableTargets(applicableTargets);
        return patch;
    }

    public OPatchSingleton generate(String patchLocation, List<String> applicableTargets) throws PatchPackageException {
        OPatchSingleton patch = (OPatchSingleton)this.generate(patchLocation);
        patch.setApplicableTargets(OPlan.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
        return patch;
    }

    public OPatchSingleton generate(String patchID, String patchLocation, List<String> applicableTargets) throws PatchPackageException {
        OPatchSingleton patch = new OPatchSingleton();
        patch.setPatchLocation(patchLocation);
        patch.setPatchID(patchID);
        patch.setApplicableTargets(OPlan.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
        patch.setPatchTool(this.getPatchTool());
        return patch;
    }

    public static OPatchSingleton addApplicabilityTargets(OPatchSingleton patch, List<String> applicableTargets) throws PatchPackageException {
        patch.setApplicableTargets(OPlan.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
        return patch;
    }

    public String getPatchTool() {
        return PatchingTool.OPATCH.toString();
    }

    public boolean isPatchValid(Map map) {
        HashMap invMap = (HashMap)map.get("INVENTORY_XMLS");
        HashMap actionMap = (HashMap)map.get("ACTION_XMLS");
        int invNum = invMap.size();
        int actionNum = actionMap.size();
        if (invNum == 1 && actionNum == 1) {
            String invPath = (String)invMap.keySet().toArray()[0];
            String actionPath = (String)actionMap.keySet().toArray()[0];
            Pattern invPartern = Pattern.compile("\\d+/etc/config/inventory\\.xml");
            Pattern actionPartern = Pattern.compile("\\d+/etc/config/actions\\.xml");
            Matcher invMatcher = invPartern.matcher(invPath);
            Matcher actionMatcher = actionPartern.matcher(actionPath);
            if (!invMatcher.matches()) {
                return false;
            }
            return actionMatcher.matches();
        }
        return false;
    }

    public PatchPackage generate(Map map) throws PatchPackageException {
        OPatchSingleton patch = new OPatchSingleton();
        patch.setPatchTool(this.getPatchTool());
        PatchInventory[] PatchInventoryList = PatchUtils.getPatchInventoryFromZipMap(map);
        patch.setPatchMDxml(PatchUtils.getPatchmdFromZipMap(map));
        PatchUtils.setSingletonPatchInfoByPatchInventory(patch, PatchInventoryList[0]);
        patch.setPatchLocation((String)map.get("TOP_DIR_NAME"));
        this.setApplicableTargetForSingletonPatch(patch);
        patch.setAutoXmls(PatchUtils.getAutoXmlsFromZipStreamMap(map));
        patch.setResourceBundle(PatchUtils.getMessagePropertyFromZipStreamMap(map));
        patch.setWrapperSqlPath((String)map.get("WRAPPER_SQLS"));
        return patch;
    }

    private void setApplicableTargetForSingletonPatch(OPatchSingleton patch) throws PatchPackageException {
        ArrayList<String> applicableTarget = new ArrayList<String>(1);
        OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
        applicableTarget.add(oplanIntgFactory.getApplicabilityTarget().getDefaultApplicableTarget());
        patch.setApplicableTargets(oplanIntgFactory.getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTarget));
    }
}

