/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.patch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import model.patchmodel.GenericSingletonPatch;
import model.patchmodel.OPatchSingleton;
import model.patchmodel.PatchPackage;
import model.patchmodel.PatchType;
import model.patchmodel.PatchingTool;
import oracle.oplan.sdk.intg.OPlanIntgFactory;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.osysmodel.patchsdk.PatchPackageException;
import oracle.osysmodel.patchsdk.PatchValidatorAndGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExapatchPatchValidatorAndGenerator
implements PatchValidatorAndGenerator {
    static Logger logger = Logger.getLogger(ExapatchPatchValidatorAndGenerator.class.getName());

    public boolean isPatchValid(String patchLocation) throws PatchPackageException {
        assert (patchLocation != null);
        return true;
    }

    public boolean isMethodValid(Class className, String method, Class[] parameterTypes) {
        try {
            className.getMethod(method, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    public PatchPackage generate(String patchLocation) throws PatchPackageException {
        assert (patchLocation != null);
        File patchDir = new File(patchLocation);
        if (!patchDir.exists()) {
            throw new PatchPackageException("The given patchLocation " + patchLocation + " does not exist");
        }
        if (!patchDir.isDirectory()) {
            throw new PatchPackageException("The given patchLocation " + patchLocation + " does not represent a directory");
        }
        GenericSingletonPatch patch = new GenericSingletonPatch();
        patch.setPatchType(PatchType.EXALOGIC_ONEOFF);
        patch.setPatchTool(PatchingTool.EXAPATCH.toString());
        patch.setPatchLocation(patchLocation);
        return patch;
    }

    public GenericSingletonPatch generate(String patchLocation, List<String> applicableTargets) throws PatchPackageException {
        GenericSingletonPatch patch = (GenericSingletonPatch)this.generate(patchLocation);
        patch.setApplicableTargets(OPlan.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
        return patch;
    }

    public GenericSingletonPatch generate(String patchID, String patchLocation, List<String> applicableTargets) throws PatchPackageException {
        GenericSingletonPatch patch = new GenericSingletonPatch();
        patch.setPatchLocation(patchLocation);
        patch.setPatchID(patchID);
        patch.setApplicableTargets(OPlan.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
        patch.setPatchTool(this.getPatchTool());
        return patch;
    }

    public static GenericSingletonPatch addApplicabilityTargets(OPatchSingleton patch, List<String> applicableTargets) throws PatchPackageException {
        patch.setApplicableTargets(OPlan.getInstance().getOPlanIntgFactory().getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTargets));
        return patch;
    }

    public String getPatchTool() {
        return PatchingTool.EXAPATCH.toString();
    }

    public boolean isPatchValid(Map map) {
        return true;
    }

    public PatchPackage generate(Map map) throws PatchPackageException {
        GenericSingletonPatch patch = new GenericSingletonPatch();
        patch.setPatchType(PatchType.EXALOGIC_ONEOFF);
        patch.setPatchTool(PatchingTool.EXAPATCH.toString());
        return patch;
    }

    private void setApplicableTargetForSingletonPatch(OPatchSingleton patch) throws PatchPackageException {
        ArrayList<String> applicableTarget = new ArrayList<String>(1);
        OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
        applicableTarget.add(oplanIntgFactory.getApplicabilityTarget().getDefaultApplicableTarget());
        patch.setApplicableTargets(oplanIntgFactory.getApplicabilityTarget().makeOPlanRecognizedApplicableTargetsList(applicableTarget));
    }
}

