/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.core.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.Host;
import oracle.opatch.system.automation.AutomationHelper;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.Automation;
import oracle.opatch.system.automation.jaxb.DeploymentMode;
import oracle.opatch.system.automation.jaxb.DeploymentSubType;
import oracle.opatch.system.automation.jaxb.DeploymentType;
import oracle.opatch.system.automation.jaxb.PatchingPhase;
import oracle.opatch.system.automation.jaxb.PhaseType;
import oracle.opatch.system.automation.jaxb.ServiceStatus;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.cmdtranslator.Command;
import oracle.oplan.sdk.cmdtranslator.CommandFactory;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.exec.api.ExecutionPhase;
import oracle.oplan.sdk.exec.api.ExecutionPlan;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.exec.api.Target;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.intg.OPlanIntgFactory;
import oracle.oplan.sdk.oplan.OPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencingEngine {
    static Logger logger = Logger.getLogger(SequencingEngine.class.getName());
    ConfigGraph configGraph;
    Automation automation;
    CommandFactory commandFactory;

    public SequencingEngine(ConfigGraph configGraph, Automation automation) {
        this.configGraph = configGraph;
        this.automation = automation;
        this.commandFactory = OPlan.getInstance().getCommandFactory();
    }

    public void expandAutomationPhaseAllHosts(PatchingPhase auto_phase, ExecutionPhase exec_phase, Strategy strategy) {
        List<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        for (ActionType action : AutomationHelper.getActions((PatchingPhase)auto_phase)) {
            if (!this.includeAction(action)) continue;
            Command command = this.commandFactory.getCommand(action, strategy, auto_phase);
            steps.addAll(command.getExecutionSteps(this.configGraph));
        }
        OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
        logger.info("automation.getGroupStepsByActsontarget(): " + this.automation.getGroupStepsByActsontarget());
        if ("true".equalsIgnoreCase(this.automation.getGroupStepsByActsontarget())) {
            steps = oplanIntgFactory.getSequencingEngineUtils().sortStepsByActsOntarget(steps);
        }
        steps = oplanIntgFactory.getSequencingEngineUtils().sortStepsForNonrollingPhase(steps, auto_phase);
        exec_phase.getExecutionStep().addAll(steps);
    }

    public void expandRollingPhase(PatchingPhase auto_phase, ExecutionPhase exec_phase) {
        HashMap steps = new HashMap();
        OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
        List<Host> hostList = oplanIntgFactory.getSequencingEngineUtils().sortHosts(this.configGraph.getTargets(Host.class), auto_phase);
        for (Host host : hostList) {
            steps.put(host, new ArrayList());
        }
        for (ActionType action : AutomationHelper.getActions((PatchingPhase)auto_phase)) {
            if (!this.includeAction(action)) continue;
            Command command = this.commandFactory.getCommand(action, Strategy.MANUAL, auto_phase);
            List<ExecutionStep> allSteps = command.getExecutionSteps(this.configGraph);
            for (ExecutionStep step : allSteps) {
                if (steps.get(step.getHost()) != null) {
                    ((List)steps.get(step.getHost())).add(step);
                    continue;
                }
                hostList.add(step.getHost());
                steps.put(step.getHost(), new ArrayList());
                ((List)steps.get(step.getHost())).add(step);
            }
        }
        for (Host host : hostList) {
            List<ExecutionStep> stepsOnHost = (List<ExecutionStep>)steps.get(host);
            if ("true".equalsIgnoreCase(this.automation.getGroupStepsByActsontarget())) {
                stepsOnHost = oplanIntgFactory.getSequencingEngineUtils().sortStepsByActsOntarget(stepsOnHost);
            }
            stepsOnHost = oplanIntgFactory.getSequencingEngineUtils().sortStepsForRollingPhase(stepsOnHost, auto_phase);
            exec_phase.getExecutionStep().addAll(stepsOnHost);
        }
    }

    public Map<PatchingPhase, ExecutionPhase> generatePhaseMap(ExecutionPlan executionPlan, List<PatchingPhase> automationPhases) {
        HashMap<PatchingPhase, ExecutionPhase> exec_phases = new HashMap<PatchingPhase, ExecutionPhase>();
        if (this.automation.getPrePatchApplication() != null) {
            automationPhases.add(this.automation.getPrePatchApplication());
            ExecutionPhase prePatchExecPhase = new ExecutionPhase(this.automation.getPrePatchApplication(), ExecutionPhase.PhaseType.PRE_PATCH, ServiceStatus.UP, executionPlan);
            exec_phases.put(this.automation.getPrePatchApplication(), prePatchExecPhase);
        }
        if (this.automation.getPatchApplication() != null) {
            automationPhases.add(this.automation.getPatchApplication());
            ExecutionPhase patchExecPhase = new ExecutionPhase(this.automation.getPatchApplication(), ExecutionPhase.PhaseType.PATCH, ServiceStatus.DOWN, executionPlan);
            exec_phases.put(this.automation.getPatchApplication(), patchExecPhase);
        }
        if (this.automation.getPostPatchApplication() != null) {
            automationPhases.add(this.automation.getPostPatchApplication());
            ExecutionPhase postPatchExecPhase = new ExecutionPhase(this.automation.getPostPatchApplication(), ExecutionPhase.PhaseType.POST_PATCH, ServiceStatus.UP, executionPlan);
            exec_phases.put(this.automation.getPostPatchApplication(), postPatchExecPhase);
        }
        if (this.automation.getPostPatchGiApplication() != null) {
            automationPhases.add(this.automation.getPostPatchGiApplication());
            ExecutionPhase postPatchGiExecPhase = new ExecutionPhase(this.automation.getPostPatchGiApplication(), ExecutionPhase.PhaseType.POST_PATCH_GI, ServiceStatus.LIMITED, executionPlan);
            exec_phases.put(this.automation.getPostPatchGiApplication(), postPatchGiExecPhase);
        }
        if (this.automation.getPostPatchRacApplication() != null) {
            automationPhases.add(this.automation.getPostPatchRacApplication());
            ExecutionPhase postPatchRacExecPhase = new ExecutionPhase(this.automation.getPostPatchRacApplication(), ExecutionPhase.PhaseType.POST_PATCH_RAC, ServiceStatus.DOWN, executionPlan);
            exec_phases.put(this.automation.getPostPatchRacApplication(), postPatchRacExecPhase);
        }
        if (this.automation.getPhase() != null) {
            for (PatchingPhase aphase : this.automation.getPhase()) {
                automationPhases.add(aphase);
                ExecutionPhase execPhase = new ExecutionPhase(aphase, null, aphase.getServiceStatus(), executionPlan);
                exec_phases.put(aphase, execPhase);
            }
        }
        return exec_phases;
    }

    public boolean isRollingPhase(DeploymentSubType deploymentSubType, PatchingPhase phase) {
        DeploymentMode deploymentMode = phase.getDeploymentMode();
        return deploymentMode != null && deploymentMode == DeploymentMode.ROLLING || deploymentMode == null && deploymentSubType == DeploymentSubType.ROLLING_UPGRADE;
    }

    public void setServiceStatusForRollingPhase(ExecutionPhase exec_phase) {
        if (DeploymentType.IN_PLACE.equals((Object)exec_phase.getExecutionPlan().getAutomation().getDeploymentType()) && ExecutionPhase.PhaseType.PATCH.equals((Object)exec_phase.getPhaseType())) {
            exec_phase.setServiceStatus(ServiceStatus.LIMITED);
        }
        if (DeploymentType.OUT_OF_PLACE.equals((Object)exec_phase.getExecutionPlan().getAutomation().getDeploymentType()) && ExecutionPhase.PhaseType.PATCH.equals((Object)exec_phase.getPhaseType())) {
            exec_phase.setServiceStatus(ServiceStatus.UP);
        }
    }

    public void setServiceStatusForNonRollingPhase(ExecutionPhase exec_phase) {
        if (DeploymentType.IN_PLACE.equals((Object)exec_phase.getExecutionPlan().getAutomation().getDeploymentType()) && PhaseType.APPLY.equals((Object)exec_phase.getAutomationPatchingPhase().getPhaseType())) {
            exec_phase.setServiceStatus(ServiceStatus.DOWN);
        }
        if (DeploymentType.IN_PLACE.equals((Object)exec_phase.getExecutionPlan().getAutomation().getDeploymentType()) && PhaseType.ROLLBACK.equals((Object)exec_phase.getAutomationPatchingPhase().getPhaseType())) {
            exec_phase.setServiceStatus(ServiceStatus.DOWN);
        }
    }

    public void expandPhases(List<PatchingPhase> automationPhases, Map<PatchingPhase, ExecutionPhase> exec_phases) {
        DeploymentSubType deploymentSubType = this.automation.getDeploymentSubType();
        if (deploymentSubType == null) {
            deploymentSubType = DeploymentSubType.NON_ROLLING_UPGRADE;
        }
        Strategy strategy = this.automation.getStrategy();
        OPlan.getInstance().getOPlanEnv().setProperty("autoDeploymentSubType", deploymentSubType.toString());
        for (PatchingPhase phase : automationPhases) {
            ExecutionPhase exec_phase;
            if (this.isRollingPhase(deploymentSubType, phase)) {
                exec_phase = exec_phases.get(phase);
                this.expandRollingPhase(phase, exec_phase);
                this.setServiceStatusForRollingPhase(exec_phase);
                continue;
            }
            exec_phase = exec_phases.get(phase);
            this.expandAutomationPhaseAllHosts(phase, exec_phase, strategy);
            this.setServiceStatusForNonRollingPhase(exec_phase);
        }
    }

    public ExecutionPlan getExecutionPlan() {
        ExecutionPlan executionPlan = new ExecutionPlan(this.automation);
        ArrayList<PatchingPhase> automationPhases = new ArrayList<PatchingPhase>();
        Map<PatchingPhase, ExecutionPhase> exec_phases = this.generatePhaseMap(executionPlan, automationPhases);
        this.expandPhases(automationPhases, exec_phases);
        for (PatchingPhase phase : automationPhases) {
            if (exec_phases.get(phase).getExecutionStep().size() == 0) continue;
            executionPlan.getExecutionPhase().add(exec_phases.get(phase));
        }
        AbstractBaseTarget root = this.configGraph.getRootVertex();
        executionPlan.getApplyTarget().add(new Target(root.getDisplayName()));
        return executionPlan;
    }

    private boolean includeAction(ActionType action) {
        if ("do_not_skip".equals(action.getTag())) {
            return true;
        }
        if (this.hasPatchForTargetTypeFromStripe(action)) {
            return true;
        }
        OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
        return oplanIntgFactory.getSequencingEngineUtils().includeAction(action);
    }

    private boolean hasPatchForTargetTypeFromStripe(ActionType action) {
        return action.getStripe() == null || !OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(action.getStripe().getTargetHome())).isEmpty();
    }
}

