/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.reporting.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.oracle.cie.common.util.reporting.jackson.messages.CompletionMixIn;
import com.oracle.cie.common.util.reporting.jackson.messages.InitiationMixIn;
import com.oracle.cie.common.util.reporting.jackson.messages.MessageMixIn;
import com.oracle.cie.common.util.reporting.jackson.messages.ProgressMixIn;
import com.oracle.cie.common.util.reporting.jackson.messages.ReportMessageMixIn;
import com.oracle.cie.common.util.reporting.jackson.messages.ReportMixIn;
import com.oracle.cie.common.util.reporting.messages.Completion;
import com.oracle.cie.common.util.reporting.messages.Initiation;
import com.oracle.cie.common.util.reporting.messages.Message;
import com.oracle.cie.common.util.reporting.messages.Progress;
import com.oracle.cie.common.util.reporting.messages.Report;
import com.oracle.cie.common.util.reporting.messages.ReportMessage;

public class ObjectMapperFactory {
    private static ObjectMapper _mapper;

    public static synchronized ObjectMapper getObjectMapper() {
        if (_mapper == null) {
            _mapper = new ObjectMapper();
            _mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            _mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
            _mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            _mapper.registerModule((Module)new SimpleModule(){

                public void setupModule(Module.SetupContext context) {
                    context.setMixInAnnotations(Report.class, ReportMixIn.class);
                    context.setMixInAnnotations(ReportMessage.class, ReportMessageMixIn.class);
                    context.setMixInAnnotations(Initiation.class, InitiationMixIn.class);
                    context.setMixInAnnotations(Message.class, MessageMixIn.class);
                    context.setMixInAnnotations(Progress.class, ProgressMixIn.class);
                    context.setMixInAnnotations(Completion.class, CompletionMixIn.class);
                }
            });
        }
        return _mapper;
    }
}

