/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.reporting;

import com.oracle.cie.common.util.reporting.Receiver;
import com.oracle.cie.common.util.reporting.ReceiverType;
import com.oracle.cie.common.util.reporting.ReportingException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Receiving {
    private static final Logger _log = Logger.getLogger(Receiving.class.getName());
    private static List<Receiver> _receivers = new ArrayList<Receiver>();

    public static Receiver addReceiver(ReceiverType type, InputStream inputStream) throws ReportingException {
        Receiver receiver;
        try {
            Class<? extends Receiver> receiverClass = type.getReceiverClass();
            receiver = receiverClass.getConstructor(InputStream.class).newInstance(inputStream);
            Receiving.addReceiver(receiver);
        }
        catch (Exception e) {
            throw new ReportingException("Failed to load " + type + " receiver.", e);
        }
        return receiver;
    }

    public static Receiver addReceiver(ReceiverType type, InputStream inputStream, String messageIndicator) throws ReportingException {
        Receiver receiver;
        try {
            Class<? extends Receiver> receiverClass = type.getReceiverClass();
            receiver = receiverClass.getConstructor(InputStream.class, String.class).newInstance(inputStream, messageIndicator);
            Receiving.addReceiver(receiver);
        }
        catch (Exception e) {
            throw new ReportingException("Failed to load " + type + " receiver.", e);
        }
        return receiver;
    }

    public static void addReceiver(Receiver receiver) {
        if (_log.isLoggable(Level.FINEST)) {
            _log.finest("Adding receiver " + receiver);
        }
        if (receiver != null) {
            _receivers.add(receiver);
        }
    }

    public static void stopAll() {
        for (Receiver receiver : new ArrayList<Receiver>(_receivers)) {
            Receiving.stop(receiver);
        }
    }

    public static void stop(Receiver receiver) {
        if (receiver != null) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Stopping receiver " + receiver);
            }
            receiver.close();
            _receivers.remove(receiver);
        }
    }
}

