/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.logging;

import com.oracle.cie.common.logging.xml.ConsoleDestinationType;
import com.oracle.cie.common.logging.xml.DefaultConfigurationType;
import com.oracle.cie.common.logging.xml.DestinationRefType;
import com.oracle.cie.common.logging.xml.DestinationType;
import com.oracle.cie.common.logging.xml.FileDestinationType;
import com.oracle.cie.common.logging.xml.LevelType;
import com.oracle.cie.common.logging.xml.LoggerType;
import com.oracle.cie.common.logging.xml.LoggingConfigurationType;
import com.oracle.cie.common.logging.xml.OutputType;
import com.oracle.cie.common.util.logging.AppIDAnalyzer;
import com.oracle.cie.common.util.logging.Destination;
import com.oracle.cie.common.util.logging.EnvironmentUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.common.util.logging.LoggingConfig;
import com.oracle.cie.common.util.logging.OldPropertySubstitutor;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogConfigConverter {
    public static final String SUBSTITUTION_PROPS = "oracle.cie.log.subst.props";
    public static final String SUBSTITUTION_PREFIX = "oracle.cie.log.subst.";
    public static final String SUBST_RESULT_PREFIX = "oracle.cie.log.";
    private boolean _debug;
    private OldPropertySubstitutor _substitutor = new OldPropertySubstitutor();

    public LogConfigConverter() {
        this._debug = EnvironmentUtil.isDebugMode();
    }

    public LoggingConfigurationType convert(LoggingConfig oldConfig) {
        LoggingConfigurationType newConfig = new LoggingConfigurationType();
        DefaultConfigurationType newDefaultConfigType = new DefaultConfigurationType();
        String oldConfigLevelName = oldConfig.getDefaultLevel();
        LevelType defaultLevelType = oldConfigLevelName != null && oldConfigLevelName.length() > 0 ? LevelType.fromValue(oldConfigLevelName.toUpperCase()) : LogFactory.DEFAULT_LEVEL_TYPE;
        newDefaultConfigType.setLevel(defaultLevelType);
        if (oldConfig.getLogFileLocation() != null) {
            String location = this._substitutor.substitute(oldConfig.getLogFileLocation(), System.getProperties());
            DestinationRefType newDestRef = new DestinationRefType(location);
            newDefaultConfigType.addDestinationRef(newDestRef);
            newConfig.addDestination(this.getDestinationType(location, defaultLevelType));
        }
        newConfig.setDefaultConfiguration(newDefaultConfigType);
        List<LoggingConfig.Logger> oldLoggers = oldConfig.getRootLoggers();
        for (LoggingConfig.Logger logger : oldLoggers) {
            LoggerType newLogger = new LoggerType(logger.getName());
            List<LoggingConfig.Destination> destinations = logger.getDestinations();
            for (LoggingConfig.Destination dest : destinations) {
                String destName = this._substitutor.substitute(dest.getDestination(), System.getProperties());
                DestinationRefType destRefType = new DestinationRefType(destName);
                String destLevel = dest.getLevel();
                LevelType destLevelType = destLevel != null && destLevel.length() > 0 ? LevelType.fromValue(destLevel.toUpperCase()) : defaultLevelType;
                DestinationType destType = this.getDestinationType(destName, destLevelType);
                newConfig.addDestination(destType);
                newLogger.addDestinationRef(destRefType);
            }
            newConfig.addLogger(newLogger);
        }
        List<LoggingConfig.Property> oldConfigProperties = oldConfig.getProperties();
        for (LoggingConfig.Property oldConfigProp : oldConfigProperties) {
            String propClassName;
            String oldPropFileName = oldConfigProp.getFileName();
            String oldPropClassName = oldConfigProp.getInvokedByClass();
            if (oldConfigProp.isMain()) {
                propClassName = "oracle.cie.log.internal.appid.main_" + oldPropClassName;
                newConfig.addProperty(propClassName, oldPropFileName);
                continue;
            }
            if (oldConfigProp.isCaller()) {
                propClassName = "oracle.cie.log.internal.appid.caller_" + oldPropClassName;
                newConfig.addProperty(propClassName, oldPropFileName);
                continue;
            }
            if (!oldConfigProp.isDefault()) continue;
            newConfig.addProperty("oracle.cie.log.internal.appid.default", oldPropFileName);
        }
        return newConfig;
    }

    public LoggingConfigurationType convert(Properties logProperties) {
        LoggingConfigurationType newConfig = new LoggingConfigurationType();
        DefaultConfigurationType newDefaultConfigType = new DefaultConfigurationType();
        boolean hasSubstitutableProperties = false;
        for (Map.Entry<Object, Object> entry : logProperties.entrySet()) {
            String propName = String.valueOf(entry.getKey());
            if (propName.equalsIgnoreCase("oracle.cie.log.default.priority")) {
                newDefaultConfigType.setLevel(LevelType.valueOf(String.valueOf(entry.getValue())));
                continue;
            }
            if (propName.startsWith(SUBSTITUTION_PREFIX) && newDefaultConfigType.getDestinationRef() == null) {
                hasSubstitutableProperties = true;
                continue;
            }
            if (propName.equalsIgnoreCase("oracle.cie.log.default.logroots")) {
                String[] loggerNames;
                String loggerProp = String.valueOf(entry.getValue());
                for (String loggerName : loggerNames = loggerProp.split(",")) {
                    LoggerType logger = new LoggerType(loggerName.trim());
                    newConfig.addLogger(logger);
                }
                continue;
            }
            newConfig.addProperty(propName, String.valueOf(entry.getValue()));
        }
        if (hasSubstitutableProperties) {
            AppIDAnalyzer analyzer = new AppIDAnalyzer(newConfig.getProperties());
            String appId = analyzer.getAppId();
            Properties substitutedProps = new Properties();
            substitutedProps.putAll((Map<?, ?>)System.getProperties());
            substitutedProps.put("oracle.cie.log.appid", appId);
            String defaultLocation = this.getDefaultLocation(logProperties, substitutedProps);
            DestinationRefType newDestRef = new DestinationRefType(defaultLocation);
            newDefaultConfigType.addDestinationRef(newDestRef);
            newConfig.addDestination(this.getDestinationType(defaultLocation, newDefaultConfigType.getLevel() != null ? newDefaultConfigType.getLevel() : LogFactory.DEFAULT_LEVEL_TYPE));
        }
        newConfig.setDefaultConfiguration(newDefaultConfigType);
        return newConfig;
    }

    private DestinationType getDestinationType(String location, LevelType level) {
        DestinationType destType = new DestinationType(location);
        if (Destination.isConsoleBased(location)) {
            ConsoleDestinationType cdt = new ConsoleDestinationType(OutputType.fromValue(location.toLowerCase()));
            destType.setConsoleBased(cdt);
        } else {
            destType.setFileBased(new FileDestinationType(location));
        }
        destType.setLevel(level);
        return destType;
    }

    private String getDefaultLocation(Properties logProps, Properties substitutedProps) {
        String subst = logProps.getProperty(SUBSTITUTION_PROPS);
        if (subst != null) {
            String[] substitutableProperties;
            for (String name : substitutableProperties = subst.trim().split("\\s*,\\s*")) {
                String rsltPropName = SUBST_RESULT_PREFIX + name;
                if (logProps.contains(rsltPropName)) continue;
                String substProp = logProps.getProperty(SUBSTITUTION_PREFIX + name);
                if (substProp == null) {
                    LogFactory.addLogRecord(new LogRecord(Level.SEVERE, "Missing substitution property: oracle.cie.log.subst." + name));
                    continue;
                }
                if (this._debug) {
                    LogFactory.addLogRecord(new LogRecord(Level.INFO, "LOG_DEBUG: Substituting property: " + rsltPropName + "=" + substProp));
                }
                String substitutedVal = this._substitutor.substitute(substProp, substitutedProps);
                substitutedProps.put(rsltPropName, substitutedVal);
                if (!this._debug) continue;
                LogFactory.addLogRecord(new LogRecord(Level.INFO, "LOG_DEBUG: Substituted property: " + rsltPropName + "=" + substitutedVal));
            }
            return substitutedProps.getProperty("oracle.cie.log.default.location");
        }
        if (this._debug) {
            LogFactory.addLogRecord(new LogRecord(Level.INFO, "No value defined for the property oracle.cie.log.subst.props"));
        }
        return null;
    }
}

