/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary.systempatch;

import java.io.File;
import java.util.List;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.binary.systempatch.SystemPatchData;

public class SystemPatchStorageHelper {
    public static boolean cleanupSystemPatchEntities(List<SystemPatchData> registeredSystemPatchStorageLocns) {
        boolean all_successful = true;
        for (SystemPatchData data : registeredSystemPatchStorageLocns) {
            String location = data.getBundleXMLLocation();
            OACLogger.info("Deleting location " + location);
            if (OPatchAutoBinaryUtil.deleteFileOrDirectory(location)) continue;
            all_successful = false;
        }
        return all_successful;
    }

    public static boolean storeSystemPatchEntities(String oracleHome, List<SystemPatchData> systemPatchDetails) {
        boolean all_successful = true;
        String sp_storage = SystemPatchStorageHelper.getOPatchAutoStorageLocation(oracleHome);
        for (SystemPatchData systemPatchData : systemPatchDetails) {
            File source = new File(systemPatchData.getBundleXMLLocation(), "bundle.xml");
            if (!source.exists() || !source.canRead()) {
                OACLogger.info("This File does not exist or it cannot be read: " + source.getAbsolutePath());
                all_successful = false;
                continue;
            }
            String systemPatchBackUpDir = sp_storage + File.separator + systemPatchData.getBundlePatchID();
            File destinationDir = new File(systemPatchBackUpDir);
            destinationDir.mkdirs();
            File destination = new File(systemPatchBackUpDir, "bundle.xml");
            if (destination.exists()) {
                OACLogger.info("This File already exists and it will be deleted first: " + destination.getAbsolutePath());
                destination.delete();
            }
            OACLogger.info("Backing up SystemPatch bundle.xml from \"" + systemPatchData.getBundleXMLLocation() + "\" to \"" + systemPatchBackUpDir + "\"");
            if (OPatchAutoBinaryUtil.copyFile(source, destination)) {
                OACLogger.info("Successfully backed up the bundle.xml");
                continue;
            }
            OACLogger.info("Failed to back up the bundle.xml");
            all_successful = false;
        }
        return all_successful;
    }

    public static String getOPatchAutoStorageLocation(String oracleHome) {
        String storage_locn = oracleHome + File.separator;
        String osName = System.getProperty("os.name", "");
        storage_locn = osName.matches("[W|w]indows*.*") ? storage_locn + "opatchauto_storage" : storage_locn + ".opatchauto_storage";
        storage_locn = storage_locn + File.separator + "system_patches";
        return storage_locn;
    }
}

