/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary.action;

import java.util.ArrayList;
import java.util.List;
import oracle.opatch.opatchsdk.OPatchContext;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchNApplyOptions;
import oracle.opatch.opatchsdk.OPatchNRollbackOptions;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.binary.PatchResult;
import oracle.opatchauto.core.binary.PatchingSessionOptions;
import oracle.opatchauto.core.binary.action.ActionResult;
import oracle.opatchauto.core.binary.action.BinaryAction;
import oracle.opatchauto.core.binary.action.PatchParamBag;
import oracle.opatchauto.core.binary.systempatch.SystemPatchInformationLoader;

public class LegacyPatchAction
implements BinaryAction {
    private final boolean isRollback;

    public LegacyPatchAction(boolean isRollback) {
        this.isRollback = isRollback;
    }

    @Override
    public ActionResult execute(PatchParamBag paramBag) {
        OPatchTarget target = paramBag.getTarget();
        OPatchContext context = target.getContext();
        PatchingSessionOptions sessionOptions = paramBag.getSessionOptions();
        List<PatchResult> analyzeResultList = paramBag.getAnalyzedResult();
        ActionResult actionResult = new ActionResult();
        SystemPatchInformationLoader instance = SystemPatchInformationLoader.getInstance();
        ArrayList<OPatchPatch> allPatches = new ArrayList<OPatchPatch>();
        try {
            for (PatchResult patchResult : analyzeResultList) {
                List<OPatchPatch> patches = this.getPatchesFromPR(patchResult, target);
                allPatches.addAll(patches);
            }
            if (this.isRollback) {
                OACLogger.console("Rolling back the patches ...\n");
                OPatchNRollbackOptions nRollbackOptions = new OPatchNRollbackOptions();
                nRollbackOptions.ohInstanceUp(sessionOptions.isOhInstanceRunning()).noRelink(sessionOptions.isNoRelink()).noPatchgen(sessionOptions.isNoPatchgen());
                target.NRollback(allPatches.toArray(new OPatchPatch[allPatches.size()]), nRollbackOptions);
                OACLogger.console("Patches successfully rolled back.\n");
            } else {
                OACLogger.console("Applying the patches ...\n");
                OPatchNApplyOptions nApplyOptions = new OPatchNApplyOptions();
                nApplyOptions.ohInstanceUp(sessionOptions.isOhInstanceRunning()).forceConflict(sessionOptions.isForceConflict()).skipConflict(sessionOptions.isSkipConflict()).noRelink(sessionOptions.isNoRelink()).noPatchgen(sessionOptions.isNoPatchgen());
                target.NApply(allPatches.toArray(new OPatchPatch[allPatches.size()]), nApplyOptions);
                OACLogger.console("Patches successfully applied.\n");
            }
            String log = target.getLastSessionLogFile();
            for (PatchResult patchResult : analyzeResultList) {
                if (patchResult.isPatchIDbased()) {
                    actionResult.addPatchResult(OPatchAutoBinaryUtil.buildSuccessfulPRwithID(patchResult.getPatchID(), log));
                    continue;
                }
                actionResult.addPatchResult(OPatchAutoBinaryUtil.buildSuccessfulPR(patchResult.getPatchLocn(), log));
            }
            String string = instance.getSystemPatchID(allPatches, this.isRollback);
            if (string != null) {
                ArrayList<String> patchIDList = new ArrayList<String>();
                for (OPatchPatch patch : allPatches) {
                    patchIDList.add(patch.getPatchId());
                }
                instance.updateSubpatchInformationStore(sessionOptions.getTarget().getOracleHome(), string, patchIDList, this.isRollback);
            }
        }
        catch (OPatchException e) {
            OACLogger.console("Patching operation failed");
            OACLogger.printStackTrace(e);
            String string = target.getLastSessionLogFile();
            for (PatchResult patchResult : analyzeResultList) {
                PatchResult pr = OPatchAutoBinaryUtil.buildFailedPR(patchResult.getPatchLocn(), patchResult.getPatchID(), "Failed during Patching: ", (Exception)((Object)e), string);
                actionResult.addPatchResult(pr);
            }
            return actionResult;
        }
        return actionResult;
    }

    private List<OPatchPatch> getPatchesFromPR(PatchResult patchResult, OPatchTarget target) throws OPatchException {
        List<OPatchPatch> patches = new ArrayList<OPatchPatch>();
        if (this.isRollback && patchResult.isPatchIDbased()) {
            OPatchPatch patch = target.getContext().getInstalledActivePatch(patchResult.getPatchID());
            patches.add(patch);
        } else {
            String patchLocation = patchResult.getPatchLocn();
            boolean isComposite = OPatchAutoBinaryUtil.isComposite(patchLocation);
            patches = this.isRollback ? OPatchAutoBinaryUtil.getPatchListFromPatchLocnForRollback(target, patchLocation, isComposite) : OPatchAutoBinaryUtil.getPatchListFromPatchLocnForApply(target, patchLocation, isComposite);
        }
        return patches;
    }

    private boolean isPatchResultAvailable(ActionResult actionResult, PatchResult analyzedPatchResult) {
        boolean isAvailable = false;
        if (actionResult.getPatchResultList() != null && !actionResult.getPatchResultList().isEmpty()) {
            isAvailable = actionResult.getPatchResultList().contains(analyzedPatchResult) && (analyzedPatchResult.getResult() == "FAILED" || analyzedPatchResult.getResult() == "SKIPPED");
        }
        return isAvailable;
    }

    private PatchResult buildSkippedPR(String patch, String oracleHome, String targetType) {
        String reason = null;
        reason = targetType == null ? "This patch is not applicable to the oracle home - \"" + oracleHome + "\"" : "This patch is not applicable to this specified target type - \"" + targetType + "\"";
        return OPatchAutoBinaryUtil.buildSkippedPR(patch, reason);
    }
}

