/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary.action;

import com.oracle.cie.common.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.binary.PatchResult;
import oracle.opatchauto.core.binary.action.ActionResult;
import oracle.opatchauto.core.binary.action.BinaryAction;
import oracle.opatchauto.core.binary.action.OnlineAnalyzeAction;
import oracle.opatchauto.core.binary.action.PatchBag;
import oracle.opatchauto.core.binary.action.PatchParamBag;

public class AutoUpdateAnalyzeAction
implements BinaryAction {
    private final boolean isRollback;

    public AutoUpdateAnalyzeAction(boolean isRollback) {
        this.isRollback = isRollback;
    }

    @Override
    public ActionResult execute(PatchParamBag paramBag) {
        PatchBag patchbag = paramBag.getPatchbag();
        ActionResult autoUpdateAnalyzeResult = new ActionResult();
        OnlineAnalyzeAction analyzeAction = new OnlineAnalyzeAction(this.isRollback);
        boolean analysisCompleted = false;
        while (!analysisCompleted) {
            ActionResult analyzeResult = analyzeAction.execute(paramBag);
            List<PatchResult> failedpatchResultList = this.getFailedPatchDetails(analyzeResult);
            if (OPatchAutoBinaryUtil.isCASEnabled() && failedpatchResultList.isEmpty() || !OPatchAutoBinaryUtil.isCASEnabled()) {
                analysisCompleted = true;
                for (PatchResult result : analyzeResult.getPatchResultList()) {
                    autoUpdateAnalyzeResult.addPatchResult(result);
                }
                autoUpdateAnalyzeResult.setAnalysisReport(analyzeResult.getAnalysisReport());
            } else {
                for (PatchResult failedResult : failedpatchResultList) {
                    autoUpdateAnalyzeResult.addPatchResult(failedResult);
                    if (StringUtil.isNullOrEmpty((String)failedResult.getPatchLocn(), (boolean)true)) {
                        patchbag.getPatchIDList().remove(failedResult.getPatchID());
                        continue;
                    }
                    patchbag.getPatchLocationList().remove(failedResult.getPatchLocn());
                }
            }
            if (!patchbag.getPatchLocationList().isEmpty() || !patchbag.getPatchIDList().isEmpty()) continue;
            analysisCompleted = true;
        }
        return autoUpdateAnalyzeResult;
    }

    private List<PatchResult> getFailedPatchDetails(ActionResult analyzeResult) {
        ArrayList<PatchResult> failedpatchList = new ArrayList<PatchResult>();
        for (PatchResult result : analyzeResult.getPatchResultList()) {
            if (!result.getResult().equals("FAILED")) continue;
            failedpatchList.add(result);
        }
        OACLogger.info("Failed patch result list:" + failedpatchList);
        return failedpatchList;
    }
}

