/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary;

import java.io.Serializable;

public class PatchResult
implements Serializable {
    public static final String SUCCESSFUL = "SUCCESSFUL";
    public static final String SKIPPED = "SKIPPED";
    public static final String FAILED = "FAILED";
    private static final long serialVersionUID = 1L;
    private String patchLocation = "";
    private String patchID = "";
    private String logFileLocn = "";
    private String result = "";
    private String reason = "";

    public PatchResult(String patchLocation) {
        this.patchLocation = patchLocation;
    }

    public PatchResult(String patchLocation, String patchID) {
        this.patchID = patchID;
        this.patchLocation = patchLocation;
    }

    public String getPatchLocn() {
        return this.patchLocation;
    }

    public void setPatchID(String patchID) {
        this.patchID = patchID;
    }

    public String getPatchID() {
        return this.patchID;
    }

    public boolean isPatchIDbased() {
        return this.patchLocation.length() < 1 && this.patchID.length() > 0;
    }

    public String getResult() {
        return this.result;
    }

    public void setResultAsSuc() {
        this.result = SUCCESSFUL;
    }

    public void setResultAsFail() {
        this.result = FAILED;
    }

    public void setResultAsSkip() {
        this.result = SKIPPED;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getLogLocn() {
        return this.logFileLocn;
    }

    protected void setLogLocn(String log) {
        this.logFileLocn = log;
    }

    public String toStringShort() {
        StringBuffer result_info = new StringBuffer();
        if (this.patchLocation != null && this.patchLocation.length() > 0) {
            result_info.append("Patch: ").append(this.patchLocation).append("\n");
        } else {
            result_info.append("Patch ID: ").append(this.patchID).append("\n");
        }
        if (!this.result.equals(SKIPPED) || null != this.logFileLocn && !this.logFileLocn.equals("")) {
            result_info.append("Log: ").append(this.getLogLocn()).append("\n");
        }
        if (!this.result.equals(SUCCESSFUL)) {
            result_info.append("Reason: ").append(this.getReason()).append("\n");
        }
        return result_info.toString();
    }

    public String toString() {
        StringBuffer result_info = new StringBuffer();
        result_info.append("Result: ").append(this.result).append("\n");
        result_info.append(this.toStringShort());
        return result_info.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.patchID == null ? 0 : this.patchID.hashCode());
        result = 31 * result + (this.patchLocation == null ? 0 : this.patchLocation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatchResult other = (PatchResult)obj;
        if (this.patchID == null ? other.patchID != null : !this.patchID.equals(other.patchID)) {
            return false;
        }
        return !(this.patchLocation == null ? other.patchLocation != null : !this.patchLocation.equals(other.patchLocation));
    }
}

