/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatchauto.core.binary.OPatchBinarySessionResult;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class PatchLevelReportSessionResult
implements OPatchBinarySessionResult {
    private static final long serialVersionUID = -5964013776019832269L;
    private List<OPatchPatchInfo> homePatchLevel = new ArrayList<OPatchPatchInfo>();

    public void setHomePatchLevel(OPatchPatch[] activePatchList) {
        for (OPatchPatch patch : activePatchList) {
            this.homePatchLevel.add(PatchLevelReportSessionResult.setPatchLevelOnOracleHome(patch));
        }
    }

    public List<OPatchPatchInfo> getHomePatchLevel() {
        return this.homePatchLevel;
    }

    private static OPatchPatchInfo setPatchLevelOnOracleHome(OPatchPatch patch) {
        OPatchPatchInfo patchInfo = new OPatchPatchInfo();
        patchInfo.setPatchID(patch.getPatchId());
        patchInfo.setUniquePatchID(patch.getUniquePatchIdentifier());
        patchInfo.setSQLPatch(patch.isSqlPatch());
        return patchInfo;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.homePatchLevel);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.homePatchLevel = (List)in.readObject();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.homePatchLevel.isEmpty()) {
            sb.append("Found no patches");
        } else {
            for (OPatchPatchInfo info : this.homePatchLevel) {
                sb.append("Patch id: ");
                sb.append(info.getPatchID());
                sb.append("\n");
                sb.append("Unique Patch id: ");
                sb.append(info.getUniquePatchID());
                sb.append("\n");
                sb.append("Sql Patch: ");
                sb.append(String.valueOf(info.isSQLPatch()));
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

