/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary;

import com.oracle.cie.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.opatch.opatchsdk.OPatchContext;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatchauto.core.binary.BinaryPatchFilter;
import oracle.opatchauto.core.binary.BinarySessionErrorID;
import oracle.opatchauto.core.binary.BinarySessionException;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.binary.OPatchBinarySessionResult;
import oracle.opatchauto.core.binary.PatchLevelReportSessionResult;
import oracle.opatchauto.core.binary.PatchResult;
import oracle.opatchauto.core.binary.PatchingSessionOptions;
import oracle.opatchauto.core.binary.SessionPatches;
import oracle.opatchauto.core.binary.SessionResults;
import oracle.opatchauto.core.binary.action.ActionResult;
import oracle.opatchauto.core.binary.action.AutoUpdateAnalyzeAction;
import oracle.opatchauto.core.binary.action.BinaryAction;
import oracle.opatchauto.core.binary.action.CASApplyAction;
import oracle.opatchauto.core.binary.action.CASRollbackAction;
import oracle.opatchauto.core.binary.action.LegacyPatchAction;
import oracle.opatchauto.core.binary.action.OnlineAnalyzeAction;
import oracle.opatchauto.core.binary.action.PatchBag;
import oracle.opatchauto.core.binary.action.PatchParamBag;
import oracle.opatchauto.core.binary.systempatch.SystemPatchData;
import oracle.opatchauto.core.binary.systempatch.SystemPatchInformationLoader;
import oracle.opatchauto.core.binary.systempatch.SystemPatchStorageHelper;
import oracle.opatchauto.core.validator.JdkPatchingValidator;
import oracle.opatchauto.core.validator.JdkValidatorResult;

public class OPatchAutoBinary {
    private PatchingSessionOptions sessionOptions;
    private String targetType;
    private OPatchContext context;
    private OPatchTarget target;
    private final boolean analyze;
    private final String oracleHome;
    private final String invPtrLoc;
    private final boolean isFileBusyPatching;
    private BinaryPatchFilter binaryPatchFilter = new BinaryPatchFilter();

    public OPatchAutoBinary(PatchingSessionOptions options) throws OPatchException {
        this.sessionOptions = options;
        String type = this.sessionOptions.getTarget().getTargetType();
        if (type != null && type.trim().length() >= 1) {
            this.targetType = type;
        }
        this.analyze = this.sessionOptions.getAnalyze();
        this.oracleHome = this.sessionOptions.getTarget().getOracleHome();
        this.invPtrLoc = this.sessionOptions.getInvPtrLocn();
        this.isFileBusyPatching = this.sessionOptions.getIsFileBusyPatchingMode();
        System.setProperty("OPatch.ORACLE_HOME", this.oracleHome);
        OPatchContext.destroyContextReference();
        this.context = OPatchContext.getInstance((String)this.oracleHome, (String)this.invPtrLoc);
        this.context.setCustomScratchWorkingdirectory(OPatchAutoBinaryUtil.getCustomLogDirForCore(this.oracleHome));
        if (this.isFileBusyPatching) {
            this.context.setFileBusyPatchingMode(this.isFileBusyPatching);
        }
        this.target = new OPatchTarget(this.context);
        OACLogger.info("\nSession Options:\n" + options.toString());
    }

    public OPatchBinarySessionResult getHomePatchLevels() throws OPatchException {
        PatchLevelReportSessionResult results = new PatchLevelReportSessionResult();
        OPatchPatch[] activePatchList = this.context.getInstalledActivePatches();
        results.setHomePatchLevel(activePatchList);
        return results;
    }

    public SessionResults analyze(SessionPatches patches, boolean isRollback) throws OPatchException {
        if (isRollback) {
            if (patches.getAllRegisteredPatches().size() < 1 && patches.getRegisteredRollbackPatchIDs().size() < 1) {
                OACLogger.severe("INVALID : No patches have been registered for this session");
                return new SessionResults(this.analyze, true);
            }
        } else if (patches.getAllRegisteredPatches().size() < 1) {
            OACLogger.severe("INVALID : No patches have been registered for this session");
            return new SessionResults(this.analyze, false);
        }
        return this.NAnalyze(patches, isRollback);
    }

    public SessionResults analyzeForApply(SessionPatches patches) throws OPatchException {
        if (patches.getAllRegisteredPatches().size() < 1) {
            OACLogger.severe("INVALID : No patches have been registered for this session");
            return new SessionResults(this.analyze, false);
        }
        return this.NAnalyze(patches, false);
    }

    public SessionResults analyzeForRollback(SessionPatches patches) throws OPatchException {
        if (patches.getAllRegisteredPatches().size() < 1 && patches.getRegisteredRollbackPatchIDs().size() < 1) {
            OACLogger.severe("INVALID : No patches have been registered for this session");
            return new SessionResults(this.analyze, true);
        }
        return this.NAnalyze(patches, true);
    }

    private SessionResults NAnalyze(SessionPatches patches, boolean rollback) throws OPatchException {
        List<String> registeredRollBackIDList;
        SessionResults results = new SessionResults(true, rollback);
        results.setNAnalysis(true);
        BinaryPatchFilter.PatchData patchData = this.binaryPatchFilter.getPatchInfoFromLocation(this.oracleHome, this.targetType, patches, rollback);
        for (String patch : patchData.getSkippedListOfPatches()) {
            results.addPatchResult(OPatchAutoBinaryUtil.buildSkippedPR(patch, patchData.getSkippedReason().get(patch)));
        }
        ArrayList<OPatchPatch> completeList = new ArrayList<OPatchPatch>();
        ArrayList<String> patchLocationList = new ArrayList<String>();
        boolean new_opatch_session_started = false;
        OACLogger.info("Starting Patch Analysis ... ");
        for (String patchLoc : patchData.getCroppedListOfPatches()) {
            try {
                List<OPatchPatch> opatchPatchList;
                boolean isComposite = OPatchAutoBinaryUtil.isComposite(patchLoc);
                if (rollback) {
                    opatchPatchList = OPatchAutoBinaryUtil.getPatchListFromPatchLocnForRollback(this.target, patchLoc, isComposite);
                    if (opatchPatchList.isEmpty()) {
                        results.addPatchResult(OPatchAutoBinaryUtil.buildSkippedPR(patchLoc, "This Patch does not exist in the home, it cannot be rolled back."));
                        continue;
                    }
                    completeList.addAll(opatchPatchList);
                    patchLocationList.add(patchLoc);
                    continue;
                }
                opatchPatchList = OPatchAutoBinaryUtil.getPatchListFromPatchLocnForApply(this.target, patchLoc, isComposite);
                if (opatchPatchList.size() < 1) {
                    results.addPatchResult(OPatchAutoBinaryUtil.buildSkippedPR(patchLoc, "This patch is already been applied, so not going to apply again."));
                    continue;
                }
                if (isComposite) {
                    OPatchPatch[] patchArray = OPatchPatch.getPatches((String)patchLoc);
                    completeList.addAll(Arrays.asList(patchArray));
                } else {
                    OPatchPatch patch = new OPatchPatch(patchLoc);
                    completeList.add(patch);
                }
                patchLocationList.add(patchLoc);
            }
            catch (Throwable t) {
                OACLogger.console("Patch " + patchLoc + "Analysis FAILED.");
                OACLogger.printStackTrace(t);
                String logFile = new_opatch_session_started ? this.target.getLastSessionLogFile() : "";
                results.addPatchResult(OPatchAutoBinaryUtil.buildFailedPR(patchLoc, "Failed during listing in Analysis: ", new Exception(t), logFile));
            }
        }
        ArrayList<OPatchPatch> rollbackList = new ArrayList<OPatchPatch>();
        ArrayList<String> rollbackIDList = new ArrayList<String>();
        if (rollback && !(registeredRollBackIDList = patches.getRegisteredRollbackPatchIDs()).isEmpty()) {
            List<String> validPatchIdList;
            BinaryPatchFilter.PatchData rollBackIDPatchData = this.binaryPatchFilter.getPatchInfoFromID(this.oracleHome, this.targetType, registeredRollBackIDList);
            List<String> skippedIDList = rollBackIDPatchData.getSkippedListOfPatches();
            if (!skippedIDList.isEmpty()) {
                for (String string : skippedIDList) {
                    results.addPatchResult(OPatchAutoBinaryUtil.buildSkippedPRwithID(string, rollBackIDPatchData.getSkippedReason().get(string)));
                }
            }
            if ((validPatchIdList = rollBackIDPatchData.getCroppedListOfPatches()).isEmpty()) {
                return results;
            }
            for (String string : validPatchIdList) {
                OPatchPatch patch = this.context.getInstalledActivePatch(string);
                if (null == patch) {
                    results.addPatchResult(OPatchAutoBinaryUtil.buildSkippedPRwithID(string, "This Patch does not exist in the home, it cannot be rolled back."));
                    continue;
                }
                rollbackList.add(patch);
                rollbackIDList.add(string);
            }
        }
        ArrayList<OPatchPatch> patchList = new ArrayList<OPatchPatch>();
        patchList.addAll(rollbackList);
        patchList.addAll(completeList);
        if (!this.sessionOptions.isIgnoreJdkValidation()) {
            JdkValidatorResult jdkValidationResult = new JdkValidatorResult();
            if (null != patchList && patchList.size() > 0 && null != (jdkValidationResult = JdkPatchingValidator.validate(patchList, this.oracleHome)) && jdkValidationResult.getResult().equals("FAILED")) {
                for (OPatchPatch patch : jdkValidationResult.getInvalidPatches()) {
                    results.addPatchResult(OPatchAutoBinaryUtil.buildFailedPR(patch.getPatchLocation(), patch.getPatchId(), jdkValidationResult.getPatchErrorMessage(patch.getPatchId()), ""));
                    patchList.remove(patch);
                }
            }
        }
        if (patchList.size() == 0) {
            return results;
        }
        OACLogger.console("Analysing this list of patches : \n" + (patchLocationList.size() > 0 ? patchLocationList : "") + (rollbackIDList.size() > 0 ? rollbackIDList : "") + " ...");
        BinaryAction analyzeAction = null;
        analyzeAction = this.sessionOptions.getStopOnPrereqFailure() ? new OnlineAnalyzeAction(rollback) : new AutoUpdateAnalyzeAction(rollback);
        PatchBag patchbag = new PatchBag(patchLocationList, rollbackIDList, patchList);
        PatchParamBag paramBag = new PatchParamBag();
        paramBag.setContext(this.context);
        paramBag.setTarget(this.target);
        paramBag.setPatchbag(patchbag);
        paramBag.setSessionOptions(this.sessionOptions);
        ActionResult actionResult = analyzeAction.execute(paramBag);
        for (PatchResult result : actionResult.getPatchResultList()) {
            results.addPatchResult(result);
        }
        results.setIAnalysisReport(actionResult.getAnalysisReport());
        SystemPatchInformationLoader systemPatchInformationLoader = SystemPatchInformationLoader.getInstance();
        if (rollback) {
            results.setSystemPatchDataToBeRollback(systemPatchInformationLoader.getSystempatchInfoToBeRolledBack());
        } else {
            results.setSystemPatchDataToBeApplied(systemPatchInformationLoader.getSystemPatchInfoToBeApplied());
        }
        OACLogger.info(results.collectSessionSummary());
        OACLogger.info("... Patch Analysis Completed.");
        return results;
    }

    public SessionResults apply(SessionPatches patches) throws OPatchException, BinarySessionException {
        return this.patch(patches, false);
    }

    public SessionResults rollback(SessionPatches patches) throws OPatchException, BinarySessionException {
        return this.patch(patches, true);
    }

    public SessionResults patch(SessionPatches patches, boolean rollback) throws OPatchException, BinarySessionException {
        if (!rollback && patches.getAllRegisteredPatches().size() < 1 || rollback && patches.getAllRegisteredPatches().size() < 1 && patches.getRegisteredRollbackPatchIDs().size() < 1) {
            OACLogger.severe("INVALID : No patches have been registered for this session");
            return new SessionResults(this.analyze, rollback);
        }
        SessionResults analyze_results = this.NAnalyze(patches, rollback);
        if (this.analyze) {
            return analyze_results;
        }
        return this.patchWithoutAnalyze(analyze_results, rollback);
    }

    public SessionResults applyWithoutAnalyze(SessionResults analyzeResults) throws OPatchException, BinarySessionException {
        return this.patchWithoutAnalyze(analyzeResults, false);
    }

    public SessionResults rollbackWithoutAnalyze(SessionResults analyzeResults) throws OPatchException, BinarySessionException {
        return this.patchWithoutAnalyze(analyzeResults, true);
    }

    private SessionResults patchWithoutAnalyze(SessionResults analyzeResults, boolean rollback) throws OPatchException, BinarySessionException {
        if (rollback != analyzeResults.isRollback()) {
            String msg = "ERROR: Analysis was performed in " + (analyzeResults.isRollback() ? "ROLLBACK" : "APPLY") + " mode, whereas, patching is being attempted for " + (rollback ? "ROLLBACK" : "APPLY");
            throw new BinarySessionException(BinarySessionErrorID.INVALID_ANALYZE_RESULT.getValue(), msg);
        }
        SessionResults results = new SessionResults(false, rollback);
        results.addPatchResults(analyzeResults.getSkippedPatches());
        results.addPatchResults(analyzeResults.getFailedPatches());
        ArrayList<PatchResult> successfulAnalyzedResultResults = analyzeResults.getSuccessfulPatches();
        if (this.sessionOptions.getStopOnPrereqFailure() && analyzeResults.getFailedPatches().size() > 0) {
            for (PatchResult pr : successfulAnalyzedResultResults) {
                pr.setResultAsSkip();
                pr.setReason("This patch has succeeded during analysis. However, some other patches failed during analysis and hence, ending the session by skipping this patch.");
                results.addPatchResult(pr);
            }
            OACLogger.info(results.collectSessionSummary());
            return results;
        }
        if (successfulAnalyzedResultResults == null || successfulAnalyzedResultResults.size() == 0) {
            return results;
        }
        PatchBag patchbag = null;
        BinaryAction patchAction = null;
        if (OPatchAutoBinaryUtil.isCASEnabled()) {
            ArrayList<String> patchLocationList = new ArrayList<String>();
            ArrayList<String> rollbackIDList = new ArrayList<String>();
            ArrayList<OPatchPatch> patchList = new ArrayList<OPatchPatch>();
            for (PatchResult result : successfulAnalyzedResultResults) {
                if (StringUtil.isNullOrEmpty((String)result.getPatchLocn(), (boolean)true)) {
                    OPatchPatch patch = this.context.getInstalledActivePatch(result.getPatchID());
                    if (patch == null) continue;
                    patchList.add(patch);
                    rollbackIDList.add(result.getPatchID());
                    continue;
                }
                String patchLoc = result.getPatchLocn();
                boolean isComposite = OPatchAutoBinaryUtil.isComposite(patchLoc);
                if (isComposite) {
                    OPatchPatch[] patchArray = OPatchPatch.getPatches((String)patchLoc);
                    patchList.addAll(Arrays.asList(patchArray));
                } else {
                    OPatchPatch patch = new OPatchPatch(patchLoc);
                    patchList.add(patch);
                }
                patchLocationList.add(result.getPatchLocn());
            }
            patchbag = new PatchBag(patchLocationList, rollbackIDList, patchList);
            patchAction = rollback ? new CASRollbackAction() : new CASApplyAction();
            this.updateAnalyzeData(analyzeResults, rollback);
        } else {
            ArrayList<String> orderedList = analyzeResults.getSortedListofPatchIDs();
            successfulAnalyzedResultResults = this.getSortedListOfPatchResultsFromAnalysisResults(orderedList, successfulAnalyzedResultResults);
            patchAction = new LegacyPatchAction(rollback);
            this.updateAnalyzeData(analyzeResults, rollback);
        }
        OACLogger.info("Started patching operations ...");
        PatchParamBag paramBag = new PatchParamBag();
        paramBag.setContext(this.context);
        paramBag.setTarget(this.target);
        paramBag.setPatchbag(patchbag);
        paramBag.setSessionOptions(this.sessionOptions);
        paramBag.setAnalyzedResult(successfulAnalyzedResultResults);
        ActionResult patchActionResult = patchAction.execute(paramBag);
        for (PatchResult result : patchActionResult.getPatchResultList()) {
            results.addPatchResult(result);
        }
        OACLogger.info(results.collectSessionSummary());
        OACLogger.info("... Patching operations Completed.");
        SystemPatchInformationLoader sysInfoLoader = SystemPatchInformationLoader.getInstance();
        if (rollback) {
            if (results.getFailedPatches().size() == 0) {
                OACLogger.info("Cleaning the SystemPatch metadata ...");
                SystemPatchStorageHelper.cleanupSystemPatchEntities(sysInfoLoader.getSystempatchInfoToBeRolledBack());
            }
        } else if (sysInfoLoader.getSystemPatchInfoToBeApplied().size() > 0) {
            OACLogger.info("Backing up the SystemPatch metadata ...");
            SystemPatchStorageHelper.storeSystemPatchEntities(this.oracleHome, sysInfoLoader.getSystemPatchInfoToBeApplied());
        }
        return results;
    }

    private void updateAnalyzeData(SessionResults analyzeResults, boolean isRollBack) {
        if (isRollBack) {
            List<SystemPatchData> systempatchdata = analyzeResults.getSystemPatchDataToBeRollback();
            for (SystemPatchData data : systempatchdata) {
                SystemPatchInformationLoader.getInstance().setSystempatchInfoToBeRolledBack(data);
            }
        } else {
            List<SystemPatchData> systempatchdata = analyzeResults.getSystemPatchDataToBeApplied();
            for (SystemPatchData data : systempatchdata) {
                SystemPatchInformationLoader.getInstance().setSystemPatchInfoToBeApplied(data);
            }
        }
    }

    private ArrayList<PatchResult> getSortedListOfPatchResultsFromAnalysisResults(List<String> orderedList, ArrayList<PatchResult> patch_results) throws OPatchException {
        ArrayList<PatchResult> sortedResults = new ArrayList();
        if (orderedList == null || orderedList.size() == 0) {
            sortedResults = patch_results;
        } else {
            String patch_locn = null;
            ArrayList<String> tempPatchIDs = new ArrayList<String>();
            block0: for (String patch_id : orderedList) {
                for (PatchResult singlePatchResult : patch_results) {
                    if (sortedResults.contains(singlePatchResult)) continue;
                    tempPatchIDs.clear();
                    patch_locn = singlePatchResult.getPatchLocn();
                    if (patch_locn != null && !patch_locn.trim().equals("")) {
                        boolean isComposite = OPatchAutoBinaryUtil.isComposite(patch_locn);
                        tempPatchIDs.addAll(OPatchAutoBinaryUtil.getAllPatchIds(patch_locn, isComposite));
                    } else {
                        tempPatchIDs.add(singlePatchResult.getPatchID());
                    }
                    if (!tempPatchIDs.contains(patch_id)) continue;
                    OACLogger.info("Adding patch result for " + (patch_locn != null && !patch_locn.trim().equals("") ? patch_locn : singlePatchResult.getPatchID()));
                    sortedResults.add(singlePatchResult);
                    continue block0;
                }
            }
        }
        return sortedResults;
    }
}

