/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.logging.Destination;
import com.oracle.cie.common.util.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;

public class OACLogger {
    public static Logger logger = null;
    public static String binaryLog = null;
    public static String logDir = null;
    private static boolean enableConsole = false;

    public static void setLogFile(String oh) {
        File logDirectory;
        if (binaryLog != null) {
            return;
        }
        if (StringUtil.isNullOrEmpty((String)logDir) && StringUtil.isNullOrEmpty((String)(logDir = System.getenv("CUSTOM_LOG_DIR")))) {
            logDir = oh + File.separator + "cfgtoollogs" + File.separator + "opatchauto";
        }
        if (!(logDirectory = new File(logDir)).exists()) {
            logDirectory.mkdirs();
        }
        Timestamp ts = new Timestamp(new Date().getTime());
        String timeString = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(ts);
        binaryLog = "opatchauto_" + timeString + "_binary.log";
        if (logDirectory.exists()) {
            binaryLog = logDir + File.separator + binaryLog;
        }
    }

    public static boolean setupLogging(String oh) {
        OACLogger.setLogFile(oh);
        if (logger != null) {
            Destination dest = Destination.createFileDestination((String)binaryLog);
            dest.setLevel("ALL");
            LogFactory.getFactory().addDestination(logger, dest);
            OACLogger.info("\nLogger has already been initialized.\n");
            logger.info("\n===============START of Binary Session================\n");
            return true;
        }
        logger = Logger.getLogger("OACLogger");
        LogFactory.getFactory().setupLogging(binaryLog, "ALL", new String[]{logger.getName()});
        logger.info("\n===============START of Binary Session================\n");
        return logger != null;
    }

    public static boolean useLogger(Logger outside_logger) {
        logger = outside_logger;
        return logger != null;
    }

    public static void disableConsoleOutput() {
        enableConsole = false;
    }

    public static void enableConsoleOutput() {
        enableConsole = true;
    }

    public static void setCustomLogDir(String dir) {
        logDir = dir + File.separator + "opatchauto";
    }

    public static void console(String msg) {
        if (enableConsole) {
            System.out.println(msg + "\n");
        }
        if (logger != null) {
            logger.info("\n" + msg);
        }
    }

    public static void info(String msg) {
        if (logger != null) {
            logger.info("\n" + msg);
        }
    }

    public static void warning(String msg) {
        if (logger != null) {
            logger.warning("\n" + msg);
        }
    }

    public static void severe(String msg) {
        if (logger != null) {
            logger.severe("\n" + msg);
        }
        if (enableConsole) {
            System.out.println(msg + "\n");
        }
    }

    protected static void debug(String msg) {
        if (logger != null) {
            logger.info("\nDEBUG :" + msg + "\n");
        }
    }

    public static String getLogFile() {
        return binaryLog;
    }

    public static void closeLogFiles() throws IOException {
    }

    public static void printStackTrace(Throwable t) {
        StackTraceElement[] stackTrace = t.getStackTrace();
        StringBuffer trace = new StringBuffer();
        trace.append(t.toString());
        for (int i = 0; i < stackTrace.length; ++i) {
            trace.append(stackTrace[i].toString()).append("\n");
        }
        OACLogger.info(trace.toString());
    }
}

