/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoException;
import oracle.opatchauto.core.binary.OPatchBinarySessionResult;
import oracle.opatchauto.core.utility.OPatchAutoUtilOptions;
import oracle.opatchauto.core.utility.OPatchCoreUtilParam;
import oracle.opatchauto.core.utility.QueryOperation;
import oracle.opatchauto.core.utility.operation.HomePatchLevelQueryOperation;
import oracle.opatchauto.core.utility.operation.OPatchAutoCoreUtilOperation;
import oracle.opatchauto.core.utility.operation.PatchMetadataQueryOperation;

public class OpatchAutoCoreUtility {
    public static final String QUERY = "query";
    private String command;
    private String operation;
    private List<String> patchLocationList = new ArrayList<String>();
    private String resultLoc;
    private String oracleHome;

    public static void main(String[] args) {
        OpatchAutoCoreUtility coreUtility = new OpatchAutoCoreUtility();
        try {
            coreUtility.parseArgs(args);
            OPatchAutoCoreUtilOperation utilOperation = coreUtility.getOperation();
            OPatchBinarySessionResult result = utilOperation.execute(coreUtility.getParam());
            coreUtility.persistResult(result);
        }
        catch (OPatchAutoException e) {
            coreUtility.printMessage(e.getLocalizedMessage());
            System.exit(-1);
        }
    }

    private void parseArgs(String[] args) {
        this.command = args[0];
        this.operation = args[1];
        if (this.command.equals(QUERY)) {
            for (int i = 2; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase(OPatchAutoUtilOptions.PATCH_LOCATION.getValue())) {
                    String patchLoc = args[++i];
                    this.patchLocationList.addAll(Arrays.asList(patchLoc.split(",")));
                    continue;
                }
                if (args[i].equalsIgnoreCase(OPatchAutoUtilOptions.ORACLE_HOME.getValue())) {
                    this.oracleHome = args[++i];
                    continue;
                }
                if (!args[i].equalsIgnoreCase(OPatchAutoUtilOptions.RESULT.getValue())) continue;
                this.resultLoc = args[++i];
            }
        }
    }

    private OPatchAutoCoreUtilOperation getOperation() {
        OPatchAutoCoreUtilOperation coreUtilOperation = null;
        if (QueryOperation.PATCH_METADATA.getValue().equals(this.operation)) {
            coreUtilOperation = new PatchMetadataQueryOperation();
        } else if (QueryOperation.PATCH_LEVEL.getValue().equals(this.operation)) {
            coreUtilOperation = new HomePatchLevelQueryOperation();
        }
        return coreUtilOperation;
    }

    private OPatchCoreUtilParam getParam() {
        OPatchCoreUtilParam param = new OPatchCoreUtilParam();
        param.setOracleHome(this.oracleHome);
        param.setPatchLocation(this.patchLocationList);
        return param;
    }

    private void printMessage(String msg) {
        System.out.println(msg);
    }

    private void persistResult(OPatchBinarySessionResult result) {
        try {
            FileOutputStream outputStream = new FileOutputStream(this.resultLoc);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            result.writeExternal(objectOutputStream);
            objectOutputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            OACLogger.severe("Failed while persisting result " + e.toString());
        }
    }
}

