/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatchauto.core.binary.BinarySessionErrorID;
import oracle.opatchauto.core.binary.BinarySessionException;
import oracle.opatchauto.core.binary.OACLogger;
import oracle.opatchauto.core.binary.OPatchAutoBinary;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.binary.OracleTarget;
import oracle.opatchauto.core.binary.PatchingSessionOptions;
import oracle.opatchauto.core.binary.SessionPatches;
import oracle.opatchauto.core.binary.SessionResults;

public class OPatchAutoCore {
    private String session = "";
    private String patch_locn = "";
    private String oracle_home = "";
    private String invPtrLoc = "";
    private String target_type = "";
    private String patchBaseDir = "";
    private ArrayList<String> rollbackIDs = new ArrayList();
    private boolean analyze = false;
    private boolean help = false;
    private boolean isFileBusyPatchingMode = false;
    private String persistSessionResultFile = null;
    private String analyzeSessionResult = null;
    private boolean isOhInstanceRunning = false;
    private boolean version;
    private boolean isForceConflict = false;
    private boolean isSkipConflict = false;
    private boolean isNoRelink = false;
    private boolean isNoPatchgen = false;
    private boolean prepareHome = false;
    private boolean ignoreJdkValidation = false;

    public static void main(String[] args) throws BinarySessionException {
        OPatchAutoCore core = new OPatchAutoCore();
        core.runOPatchAutoBinary(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runOPatchAutoBinary(String[] args) throws BinarySessionException {
        int exitCode = 0;
        try {
            SessionResults analyzedResult;
            OACLogger.enableConsoleOutput();
            try {
                this.parseArgs(args);
            }
            catch (BinarySessionException e) {
                exitCode = 2;
                OACLogger.severe(e.getMessage());
                this.help = true;
            }
            if (this.help) {
                OPatchAutoBinaryUtil.printOutFile("binary_help.txt");
                return;
            }
            if (this.isVersionCommand()) {
                this.printSessionInfo(null, args);
                return;
            }
            this.validateParams();
            OracleTarget ot = new OracleTarget(this.oracle_home);
            this.printSessionInfo(this.oracle_home, args);
            System.out.println("opatchauto log file: " + OACLogger.binaryLog + "\n");
            if (this.target_type != null && !this.target_type.equals("")) {
                ot.setTargetType(this.target_type);
            }
            PatchingSessionOptions options = new PatchingSessionOptions(ot);
            if (this.invPtrLoc != null && !this.invPtrLoc.equals("")) {
                options.setInvPtrLocn(this.invPtrLoc);
            }
            if (this.analyze) {
                options.setAnalyze(true);
            }
            options.setStopOnPrereqFailure(true);
            options.setStopOnPatchFailure(true);
            if (this.patch_locn != null && this.patch_locn.length() > 0) {
                options.setHasPatchLocn(true);
            }
            if (this.patchBaseDir != null && this.patchBaseDir.length() > 0) {
                options.setHasPatchDir(true);
            }
            if (this.isFileBusyPatchingMode) {
                options.setIsFileBusyPatchingMode(true);
            }
            options.setOHInstanceRunning(this.isOhInstanceRunning);
            options.setForceConflict(this.isForceConflict);
            options.setSkipConflict(this.isSkipConflict);
            options.setNoRelink(this.isNoRelink);
            options.setNoPatchgen(this.isNoPatchgen);
            options.setPrepareHome(this.prepareHome);
            options.setIgnoreJdkValidation(this.ignoreJdkValidation);
            SessionPatches patches = new SessionPatches();
            patches.registerRollbackPatchIDs(this.rollbackIDs);
            SessionResults result = new SessionResults();
            if (options.getHasPatchLocn()) {
                result = patches.addPatch(this.patch_locn);
            } else if (options.getHasPatchDir()) {
                result = patches.addParentLocn(this.patchBaseDir);
            }
            if (result.getSuccessfulPatches().isEmpty()) {
                if (options.getHasPatchLocn()) {
                    String errorStr = "ERROR: Unable to register this patch " + this.patch_locn;
                    System.out.println(errorStr);
                    throw new BinarySessionException(BinarySessionErrorID.NO_VALID_PATCH_FOR_OH.getValue(), errorStr + ". Selected Patch is not valid.");
                }
                if (options.getHasPatchDir()) {
                    String errorStr = "ERROR: Unable to register the patches in " + this.patchBaseDir;
                    System.out.println(errorStr);
                    throw new BinarySessionException(BinarySessionErrorID.NO_VALID_PATCH_FOR_OH.getValue(), errorStr + ". None of the patches in the patch directory are valid patches.");
                }
            }
            OPatchAutoBinary binaryPatching = new OPatchAutoBinary(options);
            SessionResults results = new SessionResults(false, false);
            if (this.session.equalsIgnoreCase("apply")) {
                results = this.analyze ? binaryPatching.apply(patches) : ((analyzedResult = this.getAnalyzeSessionResult()) == null ? binaryPatching.apply(patches) : binaryPatching.applyWithoutAnalyze(analyzedResult));
            }
            if (this.session.equalsIgnoreCase("rollback")) {
                results = this.analyze ? binaryPatching.rollback(patches) : ((analyzedResult = this.getAnalyzeSessionResult()) == null ? binaryPatching.rollback(patches) : binaryPatching.rollbackWithoutAnalyze(analyzedResult));
            }
            if (this.persistSessionResultFile != null) {
                this.persistResult(results);
            } else {
                if (OLogger.isConsoleOutputDisabled()) {
                    OLogger.enableConsoleOutput();
                }
                System.out.println(results.collectSessionSummary());
            }
            if (results.getFailedPatches().size() > 0) {
                OACLogger.severe("\nopatchauto FAILED on some patches.\n");
                exitCode = 1;
            } else {
                OACLogger.console("\nopatchauto SUCCEEDED.\n");
            }
        }
        catch (BinarySessionException e) {
            OACLogger.severe("OPatchAutoBinary hit Binary Exception: " + e.toString());
            OACLogger.printStackTrace(e);
            OACLogger.console("\nopatchauto FAILED with an Exception.");
            System.err.println(e.getLocalizedMessage());
            exitCode = e.getErrorID();
        }
        catch (Exception e) {
            OACLogger.severe("OPatchAutoBinary hit an Exception: " + e.toString());
            OACLogger.printStackTrace(e);
            OACLogger.console("\nopatchauto FAILED with an Exception.");
            System.err.println(e.getLocalizedMessage());
            exitCode = 2;
        }
        finally {
            try {
                OACLogger.closeLogFiles();
            }
            catch (Exception e) {}
            System.exit(exitCode);
        }
    }

    private SessionResults getAnalyzeSessionResult() {
        SessionResults results = null;
        if (this.analyzeSessionResult != null) {
            File sessionResultFile = new File(this.analyzeSessionResult);
            try {
                FileInputStream inputStream = new FileInputStream(sessionResultFile);
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                results = new SessionResults();
                results.readExternal(objectInputStream);
                objectInputStream.close();
                inputStream.close();
                OACLogger.console("Analyze session result created from file :: " + this.analyzeSessionResult);
            }
            catch (FileNotFoundException e) {
                results = null;
            }
            catch (IOException e) {
                results = null;
            }
            catch (ClassNotFoundException e) {
                results = null;
            }
        }
        return results;
    }

    private void persistResult(SessionResults results) {
        try {
            FileOutputStream outputStream = new FileOutputStream(this.persistSessionResultFile);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            results.writeExternal(objectOutputStream);
            objectOutputStream.flush();
            outputStream.close();
        }
        catch (FileNotFoundException e) {
            OACLogger.severe("Failed while persisting result " + e.toString());
        }
        catch (IOException e) {
            OACLogger.severe("Failed while persisting result " + e.toString());
        }
    }

    private void parseArgs(String[] args) throws BinarySessionException {
        this.session = args[0];
        for (int i = 1; i < args.length; ++i) {
            if (!(args[i].startsWith("-") || args[i].equalsIgnoreCase("help") || args[i].equalsIgnoreCase("version"))) {
                if (this.patch_locn == null || this.patch_locn.equals("")) {
                    this.patch_locn = args[i];
                    continue;
                }
                throw new BinarySessionException(BinarySessionErrorID.UNRECOGNIZED_OPTIONS.getValue(), "ERROR :- Unrecognized option: " + args[i]);
            }
            if (args[i].equalsIgnoreCase("-id")) {
                String id_list = args[++i];
                this.rollbackIDs.addAll(Arrays.asList(id_list.split(",")));
                continue;
            }
            if (args[i].equalsIgnoreCase("-oh")) {
                this.oracle_home = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-invPtrLoc")) {
                this.invPtrLoc = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-target_type")) {
                this.target_type = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-jre")) {
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-analyze")) {
                this.analyze = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-phBaseDir")) {
                this.patchBaseDir = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-customLogDir")) {
                OACLogger.setCustomLogDir(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-binary")) continue;
            if (args[i].equalsIgnoreCase("-filebusypatching")) {
                this.isFileBusyPatchingMode = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-version") || args[i].equalsIgnoreCase("version")) {
                this.version = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("help")) {
                this.help = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-persistresult")) {
                this.persistSessionResultFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-analyzedresult")) {
                this.analyzeSessionResult = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-online")) {
                this.isOhInstanceRunning = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-force_conflict")) {
                this.isForceConflict = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-skip_conflict")) {
                this.isSkipConflict = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-no_relink")) {
                this.isNoRelink = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-no_patchgen")) {
                this.isNoPatchgen = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-prepare_home")) {
                this.prepareHome = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-ignoreJdkValidation")) {
                this.ignoreJdkValidation = true;
                continue;
            }
            throw new BinarySessionException(BinarySessionErrorID.UNRECOGNIZED_OPTIONS.getValue(), "ERROR :- Invalid argument.\n  \t The argument specified is invalid: " + args[i] + "\n \t Verify the arguments provided on the command line.");
        }
    }

    private void validateParams() throws BinarySessionException {
        if (this.help || this.isVersionCommand()) {
            return;
        }
        if (!this.validateSession()) {
            throw new BinarySessionException(BinarySessionErrorID.INVALID_SESSION.getValue(), "ERROR: Invalid session: " + this.session);
        }
        if (!this.validateHome()) {
            throw new BinarySessionException(BinarySessionErrorID.INVALID_HOME.getValue(), "ERROR: Invalid value for ORACLE HOME: " + this.oracle_home);
        }
        if (!this.validateInvPtrLoc()) {
            throw new BinarySessionException(BinarySessionErrorID.INVALID_INVPTR_LOC.getValue(), "ERROR: Invalid value for Inventory Pointer: " + this.invPtrLoc);
        }
        if (!this.validatePatchLocnOrDir()) {
            if (this.patchBaseDir != null && !this.patchBaseDir.equals("")) {
                System.out.println("ERROR: Invalid Patch directory: " + this.patchBaseDir);
                throw new BinarySessionException(BinarySessionErrorID.INVALID_PATCH_LOCATION.getValue(), "ERROR: Invalid Patch directory: " + this.patchBaseDir);
            }
            System.out.println("ERROR: Invalid Patch location: " + this.patch_locn);
            throw new BinarySessionException(BinarySessionErrorID.INVALID_PATCH_LOCATION.getValue(), "ERROR: Invalid Patch location: " + this.patch_locn);
        }
    }

    private boolean validateSession() {
        return this.session.equalsIgnoreCase("apply") || this.session.equalsIgnoreCase("rollback");
    }

    private boolean validateHome() {
        File home;
        if (this.oracle_home == null || this.oracle_home.equals("")) {
            this.oracle_home = System.getProperty("OPatchauto.ORACLE_HOME");
            if (this.oracle_home == null || this.oracle_home.equals("")) {
                System.out.println("ERROR: Need to select an Oracle Home to patch.");
                return false;
            }
        }
        return (home = new File(this.oracle_home)).exists() && home.isDirectory();
    }

    private boolean validateInvPtrLoc() {
        if (this.invPtrLoc != null && !this.invPtrLoc.equals("")) {
            File inv = new File(this.invPtrLoc);
            return inv.exists() && !inv.isDirectory() && inv.getName().equalsIgnoreCase("oraInst.loc");
        }
        return true;
    }

    private boolean validatePatchLocnOrDir() throws BinarySessionException {
        if (this.patchBaseDir != null && !this.patchBaseDir.equals("") && this.patch_locn != null && !this.patch_locn.equals("")) {
            System.out.println("ERROR: Patch location \"" + this.patch_locn + "\" and -phBaseDir \"" + this.patchBaseDir + "\" cannot be used at the same time.");
            throw new BinarySessionException(BinarySessionErrorID.INVALID_PATCH_LOCATION.getValue(), "ERROR: Patch location \"" + this.patch_locn + "\" and -phBaseDir \"" + this.patchBaseDir + "\" cannot be used at the same time.");
        }
        if (this.patchBaseDir != null && !this.patchBaseDir.equals("")) {
            File patchBaseDirFile = new File(this.patchBaseDir);
            boolean validPatch = false;
            if (patchBaseDirFile.exists() && patchBaseDirFile.isDirectory()) {
                File[] patchDirList;
                for (File patchDir : patchDirList = patchBaseDirFile.listFiles()) {
                    if (!patchDir.isDirectory()) {
                        System.out.println("INFO: \"" + patchDir.getName() + "\" under " + this.patchBaseDir + " is not a valid patch location.");
                        continue;
                    }
                    validPatch = true;
                }
            }
            return validPatch;
        }
        if (this.patch_locn != null && !this.patch_locn.equals("")) {
            File patch = new File(this.patch_locn);
            return patch.exists() && patch.isDirectory();
        }
        File patch = new File(".");
        return patch.exists() && patch.isDirectory();
    }

    private void printSessionInfo(String oh, String[] args) {
        StringBuffer info = new StringBuffer();
        info.append("OPatchAuto binary patching Tool\n");
        info.append("Copyright (c)2014, Oracle Corporation. All rights reserved.\n\n");
        info.append("OPatchauto Version : " + OPatchAutoBinaryUtil.getOPatchAutoVersion() + "\n");
        if (oh != null && oh.length() > 0) {
            info.append("Running from       : " + oh + "\n");
        }
        System.out.println(info.toString());
        OACLogger.info(info.toString());
        OACLogger.info("Java Home : " + System.getProperty("java.home"));
        OACLogger.info("Command-line Arguments : " + Arrays.asList(args));
    }

    private boolean isVersionCommand() {
        return this.version || this.session.equalsIgnoreCase("version") || this.session.equalsIgnoreCase("-version");
    }
}

