/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wallet.common;

import com.oracle.cie.common.util.StringUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Util {
    public static final Logger log = Logger.getLogger(Util.class.getName());

    public static boolean isClassAvailable(String className) {
        if (StringUtil.isNullOrEmpty((String)className)) {
            return false;
        }
        boolean available = false;
        try {
            Class<?> c = Class.forName(className);
            if (c != null) {
                available = true;
            }
        }
        catch (NoClassDefFoundError e) {
            log.log(Level.FINE, "Unable to find class " + className, e);
        }
        catch (ClassNotFoundException e) {
            log.log(Level.FINE, "Unable to find class " + className, e);
        }
        return available;
    }

    public static String getHostName() {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.log(Level.WARNING, "Unable to get local host name, defaulting to localhost", e);
            host = "localhost";
        }
        return host;
    }
}

