/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wallet;

import com.oracle.cie.wallet.WalletHandler;
import com.oracle.cie.wallet.WalletHandlerException;
import com.oracle.cie.wallet.common.Util;

public class WalletHandlerFactory {
    public static WalletHandler getWalletHandler() throws WalletHandlerException {
        WalletHandler walletHandler;
        WalletHandlerFactory.checkOracleWalletAvailability();
        try {
            Class<?> handlerImpl = Class.forName("com.oracle.cie.wallet.impl.WalletHandlerImpl");
            Object object = handlerImpl.newInstance();
            walletHandler = (WalletHandler)object;
        }
        catch (ClassNotFoundException e) {
            throw new WalletHandlerException("Unable to create WalletHandler", e);
        }
        catch (InstantiationException e) {
            throw new WalletHandlerException("Unable to create WalletHandler", e);
        }
        catch (IllegalAccessException e) {
            throw new WalletHandlerException("Unable to create WalletHandler", e);
        }
        return walletHandler;
    }

    private static void checkOracleWalletAvailability() throws WalletHandlerException {
        if (!Util.isClassAvailable("oracle.security.pki.OracleWallet")) {
            throw new WalletHandlerException("OracleWallet classes are not available in classpath");
        }
    }
}

