/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml;

import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.Base64;

public class Artifact {
    private byte[] artifactBytes;
    private String artifactString;
    private short typeCode;
    private byte[] sourceID;
    private byte[] assertionHandle;

    public Artifact() {
        this.typeCode = 1;
    }

    public Artifact(byte[] sourceID, byte[] assertionHandle) {
        this(1, sourceID, assertionHandle);
    }

    public Artifact(short typeCode, byte[] sourceID, byte[] assertionHandle) {
        this.setTypeCode(typeCode);
        this.setSourceID(sourceID);
        this.setAssertionHandle(assertionHandle);
    }

    public Artifact(String artifactString) {
        this.setValue(artifactString);
    }

    public Artifact(byte[] artifactBytes) {
        this.setValue(artifactBytes);
    }

    public short getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(short typeCode) {
        this.typeCode = typeCode;
        this.clearCache();
    }

    public byte[] getSourceID() {
        return this.sourceID;
    }

    public void setSourceID(byte[] sourceID) {
        if (sourceID == null || sourceID.length != 20) {
            throw new IllegalArgumentException("Invalid length for SourceID");
        }
        this.sourceID = sourceID;
        this.clearCache();
    }

    public byte[] getAssertionHandle() {
        return this.assertionHandle;
    }

    public void setAssertionHandle(byte[] assertionHandle) {
        if (assertionHandle == null || assertionHandle.length != 20) {
            throw new IllegalArgumentException("Invalid length for AssertionHandle");
        }
        this.assertionHandle = assertionHandle;
        this.clearCache();
    }

    public byte[] getBytes() {
        if (this.artifactBytes == null) {
            int tcLen = 2;
            int sidLen = this.sourceID != null ? this.sourceID.length : 0;
            int ahLen = this.assertionHandle != null ? this.assertionHandle.length : 0;
            int artLen = tcLen + sidLen + ahLen;
            byte[] art = new byte[artLen];
            int i = 0;
            System.arraycopy(Utils.shortToBytes((short)this.typeCode), 0, art, i, tcLen);
            System.arraycopy(this.sourceID, 0, art, i += tcLen, sidLen);
            System.arraycopy(this.assertionHandle, 0, art, i += sidLen, ahLen);
            this.artifactBytes = art;
        }
        return this.artifactBytes;
    }

    public String toString() {
        if (this.artifactString == null) {
            if (this.getBytes() == null) {
                return "";
            }
            this.artifactString = Base64.toBase64((byte[])this.artifactBytes, (boolean)false);
        }
        return this.artifactString;
    }

    public void setValue(byte[] artifactBytes) {
        try {
            this.artifactBytes = artifactBytes;
            this.artifactString = null;
            this.typeCode = Utils.bytesToShort((int)artifactBytes[0], (int)artifactBytes[1]);
            this.sourceID = new byte[20];
            System.arraycopy(artifactBytes, 2, this.sourceID, 0, 20);
            this.assertionHandle = new byte[20];
            System.arraycopy(artifactBytes, 22, this.assertionHandle, 0, 20);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public void setValue(String artifactString) {
        try {
            this.setValue(Base64.fromBase64((String)artifactString));
            this.artifactString = artifactString;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    private void clearCache() {
        this.artifactString = null;
        this.artifactBytes = null;
    }

    static {
        SAMLInitializer.initialize();
    }
}

