/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.transform;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import javax.xml.parsers.DocumentBuilder;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.xmlsec.c14n.StreamingC14NImpl;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.transform.NodeToStreamTransform;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.NodeReader;
import oracle.security.xmlsec.util.NodeReaderException;
import oracle.security.xmlsec.util.NodeReaderForNodeset;
import oracle.security.xmlsec.util.NodeReaderForSubtree;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.util.XPathException;
import oracle.security.xmlsec.wss.WSSEmbedded;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSKeyIdentifier;
import oracle.security.xmlsec.wss.WSSReference;
import oracle.security.xmlsec.wss.WSSecurityToken;
import oracle.security.xmlsec.wss.WSSecurityTokenReference;
import oracle.security.xmlsec.wss.WSSecurityTokenReferenceType;
import oracle.security.xmlsec.wss.saml.SAMLAssertionKeyIdentifier;
import oracle.security.xmlsec.wss.saml.SAMLAssertionToken;
import oracle.security.xmlsec.wss.saml2.SAML2AssertionKeyIdentifier;
import oracle.security.xmlsec.wss.saml2.SAML2AssertionToken;
import oracle.security.xmlsec.wss.x509.X509IssuerSerial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StreamingSTRTransform
extends XSTransformer
implements NodeToStreamTransform {
    private String canonicalMethod;
    boolean exclusiveMode;
    boolean comments;
    private StreamingC14NImpl c14n;
    private String inclusiveNSPrefixes;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StreamingSTRTransform(XSAlgorithmIdentifier trans) {
        super(trans);
        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(trans.getAlgorithm())) {
            throw new IllegalArgumentException("STR-Transform required");
        }
        NodeList params = trans.getParameters();
        if (params.getLength() != 1) throw new IllegalArgumentException("Illegal Transform parameter");
        Element transParams = (Element)params.item(0);
        if (!transParams.getLocalName().equals("TransformationParameters") || !transParams.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) {
            throw new IllegalArgumentException("Illegal wsse Transform parameter");
        }
        NodeList cmList = XMLElement.getChildElementsByTagNameNS((Element)transParams, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"CanonicalizationMethod");
        if (cmList.getLength() != 1) {
            throw new IllegalArgumentException("Cannot find mandatory element ds:CanonicalizationMethod inside wsse:TransformationParameters");
        }
        XSAlgorithmIdentifier c14nMethod = new XSAlgorithmIdentifier((Element)cmList.item(0));
        this.canonicalMethod = c14nMethod.getAlgorithm();
        if (this.canonicalMethod.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            this.exclusiveMode = true;
            this.comments = false;
            this.inclusiveNSPrefixes = StreamingC14NImpl.getInclusiveNamespacesList((XSAlgorithmIdentifier)c14nMethod);
        } else if (this.canonicalMethod.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) {
            this.exclusiveMode = true;
            this.comments = true;
            this.inclusiveNSPrefixes = StreamingC14NImpl.getInclusiveNamespacesList((XSAlgorithmIdentifier)c14nMethod);
        } else if (this.canonicalMethod.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315")) {
            this.exclusiveMode = false;
            this.comments = false;
        } else {
            if (!this.canonicalMethod.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments")) throw new IllegalArgumentException("Illegal Transform parameter");
            this.exclusiveMode = false;
            this.comments = true;
        }
        this.c14n = new StreamingC14NImpl(this.exclusiveMode, this.comments, this.inclusiveNSPrefixes);
    }

    public String getAlgorithmURI() {
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
    }

    public String getCanonicalizationMethod() {
        return this.canonicalMethod;
    }

    public XMLContainer transform(XMLContainer source) throws TransformationException {
        HashMap STRToST = new HashMap();
        return this.transform(source, STRToST);
    }

    public XMLContainer transform(XMLContainer source, Map STRToST) throws TransformationException {
        boolean C14N_NS_FILTERED_OUT = System.getProperty("osdt.c14nNsFilteredOut") != null;
        double C14N_SPARSE_THRESHOLD = Double.parseDouble(System.getProperty("osdt.c14nSparseThreshold", "0.0"));
        byte[] res = null;
        try {
            Object nr;
            if (source.subTreeAvailable()) {
                nr = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(this.getAlgorithmURI()) && !source.getWithComments() ? new NodeReaderForNodeset((Collection)source.getNodeSet(), C14N_NS_FILTERED_OUT, C14N_SPARSE_THRESHOLD >= 1.0) : new NodeReaderForSubtree(source.getSubTree());
            } else if (source.nodeSetAvailable()) {
                nr = new NodeReaderForNodeset((Collection)source.getNodeSet(), C14N_NS_FILTERED_OUT, C14N_SPARSE_THRESHOLD >= 1.0);
            } else {
                DocumentBuilder db = XMLUtils.createDocBuilder();
                Document doc = db.parse(source.getOctetStream(), source.getSystemId());
                nr = new NodeReaderForSubtree((Node)doc);
            }
            InputStream is = this.c14n.canonicalizeToStream((NodeReader)new STRNodeReader((NodeReader)nr, STRToST));
            res = XMLUtils.readBytes((InputStream)is);
        }
        catch (IOException ex) {
            throw new TransformationException((Throwable)ex);
        }
        catch (SAXException ex) {
            throw new TransformationException((Throwable)ex);
        }
        catch (XPathException ex) {
            throw new TransformationException((Throwable)ex);
        }
        catch (NodeReaderException ex) {
            throw new TransformationException((Throwable)ex);
        }
        if (res == null) {
            res = new byte[]{};
        }
        try {
            return new XMLContainer((InputStream)new UnsyncByteArrayInputStream(res));
        }
        catch (IOException ex) {
            throw new TransformationException((Throwable)ex);
        }
    }

    private WSSecurityToken deref(WSSecurityTokenReference str) throws TransformationException {
        WSSecurityToken token;
        block12: {
            token = null;
            WSSecurityTokenReferenceType tokentype = null;
            Node node = null;
            try {
                tokentype = str.getSTReference();
                if (tokentype instanceof WSSEmbedded) {
                    node = ((WSSEmbedded)tokentype).getNode();
                    WSSEmbedded tmp = new WSSEmbedded((Element)node);
                    token = tmp.getSecurityToken();
                    break block12;
                }
                if (tokentype instanceof WSSReference) {
                    node = ((WSSReference)tokentype).getNode();
                    WSSReference tmp = new WSSReference((Element)node);
                    token = tmp.getSecurityToken();
                    break block12;
                }
                if (tokentype instanceof WSSKeyIdentifier) {
                    node = ((WSSKeyIdentifier)tokentype).getNode();
                    if (tokentype instanceof SAMLAssertionKeyIdentifier) {
                        String samlkid = new String(((WSSKeyIdentifier)tokentype).getValue());
                        Element se = XMLUtils.getElementById((Document)node.getOwnerDocument(), (String)samlkid);
                        if (se != null) {
                            token = new SAMLAssertionToken(se);
                        }
                    } else if (tokentype instanceof SAML2AssertionKeyIdentifier) {
                        String samlkid = new String(((WSSKeyIdentifier)tokentype).getValue());
                        Element se = XMLUtils.getElementById((Document)node.getOwnerDocument(), (String)samlkid);
                        if (se != null) {
                            token = new SAML2AssertionToken(se);
                        }
                    }
                    if (token == null) {
                        token = ((WSSKeyIdentifier)tokentype).getSecurityToken();
                    }
                    break block12;
                }
                if (tokentype instanceof X509IssuerSerial) {
                    token = ((X509IssuerSerial)tokentype).getSecurityToken();
                    break block12;
                }
                throw new TransformationException("Unsupported Reference Mechanism");
            }
            catch (WSSException ex) {
                throw new TransformationException((Throwable)((Object)ex));
            }
        }
        return token;
    }

    public InputStream transformToStream(NodeReader source) throws TransformationException {
        try {
            HashMap<WSSecurityTokenReference, WSSecurityToken> STRToST = new HashMap<WSSecurityTokenReference, WSSecurityToken>();
            STRNodeReader nr = new STRNodeReader(source, STRToST);
            return this.c14n.canonicalizeToStream((NodeReader)nr);
        }
        catch (NodeReaderException ex) {
            throw new TransformationException((Throwable)ex);
        }
    }

    public class STRNodeReader
    extends NodeReader {
        NodeReader nr;
        WSSecurityTokenReference str;
        WSSecurityToken token;
        NodeReaderForSubtree nr2;
        Map<WSSecurityTokenReference, WSSecurityToken> STRToST;

        public STRNodeReader(NodeReader nr, Map<WSSecurityTokenReference, WSSecurityToken> STRToST) throws NodeReaderException {
            this.nr = nr;
            this.STRToST = STRToST;
            this.checkForSTR();
        }

        private int checkForSTR() throws NodeReaderException {
            int eType = this.nr.getEventType();
            if (eType == 1 && this.nr.getLocalName().equals("SecurityTokenReference") && this.nr.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") && this.nr.isElementIncluded()) {
                this.str = new WSSecurityTokenReference((Element)this.nr.getNode());
                try {
                    this.token = StreamingSTRTransform.this.deref(this.str);
                    this.STRToST.put(this.str, this.token);
                }
                catch (TransformationException ex) {
                    throw new NodeReaderException((Throwable)ex);
                }
                this.nr2 = new NodeReaderForSubtree(this.token.getNode());
                return this.nr2.getEventType();
            }
            return eType;
        }

        public int next() throws NodeReaderException {
            if (this.nr2 != null) {
                if (this.nr2.hasNext()) {
                    int eType = this.nr2.next();
                    if (!this.nr2.hasNext()) {
                        int elemCount = 1;
                        while (elemCount > 0) {
                            int eType2 = this.nr.next();
                            if (eType2 == 1) {
                                ++elemCount;
                                continue;
                            }
                            if (eType2 != 2) continue;
                            --elemCount;
                        }
                    }
                    return eType;
                }
                this.str = null;
                this.token = null;
                this.nr2 = null;
            }
            this.nr.next();
            int eType = this.checkForSTR();
            return eType;
        }

        public Collection getAncestorXmlAttributes(boolean c14n11) throws NodeReaderException {
            return this.nr2 != null ? this.nr2.getAncestorXmlAttributes(c14n11) : this.nr.getAncestorXmlAttributes(c14n11);
        }

        public Iterator getAttributes() {
            return this.nr2 != null ? this.nr2.getAttributes() : this.nr.getAttributes();
        }

        public int getEventType() {
            return this.nr2 != null ? this.nr2.getEventType() : this.nr.getEventType();
        }

        public String getLocalName() {
            return this.nr2 != null ? this.nr2.getLocalName() : this.nr.getLocalName();
        }

        public Map getNamespaces() {
            return this.nr2 != null ? this.nr2.getNamespaces() : this.nr.getNamespaces();
        }

        public String getNamespaceURI() {
            return this.nr2 != null ? this.nr2.getNamespaceURI() : this.nr.getNamespaceURI();
        }

        public Node getNode() {
            return this.nr2 != null ? this.nr2.getNode() : this.nr.getNode();
        }

        public String getPIData() {
            return this.nr2 != null ? this.nr2.getPIData() : this.nr.getPIData();
        }

        public String getPITarget() {
            return this.nr2 != null ? this.nr2.getPITarget() : this.nr.getPITarget();
        }

        public String getPrefix() {
            return this.nr2 != null ? this.nr2.getPrefix() : this.nr.getPrefix();
        }

        public SortedMap getSortedAttributes() {
            return this.nr2 != null ? this.nr2.getSortedAttributes() : this.nr.getSortedAttributes();
        }

        public char[] getText() {
            return this.nr2 != null ? this.nr2.getText() : this.nr.getText();
        }

        public int getTextLength() {
            return this.nr2 != null ? this.nr2.getTextLength() : this.nr.getTextLength();
        }

        public int getTextStart() {
            return this.nr2 != null ? this.nr2.getTextStart() : this.nr.getTextStart();
        }

        public boolean hasNext() throws NodeReaderException {
            if (this.nr2 != null && this.nr2.hasNext()) {
                return true;
            }
            return this.nr.hasNext();
        }

        public boolean isElementAnOrphan() {
            return this.nr2 != null ? this.nr2.isElementAnOrphan() : this.nr.isElementAnOrphan();
        }

        public boolean isElementIncluded() {
            return this.nr2 != null ? this.nr2.isElementIncluded() : this.nr.isElementIncluded();
        }

        public boolean isElementInheritingNamespaces() {
            return this.nr2 != null ? this.nr2.isElementInheritingNamespaces() : this.nr.isElementInheritingNamespaces();
        }

        public boolean isUnnecessaryEmptyDefaultNsRequired() {
            return this.nr2 != null && this.nr2.getNode() == this.token.getNode();
        }
    }
}

