/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.transform;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.wss.swa.SWAUtil;

public class AttachmentCiphertextTransform
extends XSTransformer {
    public AttachmentCiphertextTransform(XSAlgorithmIdentifier trans) throws IllegalArgumentException {
        super(trans);
    }

    public String getAlgorithmURI() {
        return "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Ciphertext-Transform";
    }

    public XMLContainer transform(XMLContainer source) throws TransformationException {
        try {
            AttachmentPart ap = (AttachmentPart)source.getUserData();
            InputStream is = SWAUtil.getInputStream(ap);
            return new XMLContainer(is);
        }
        catch (ClassCastException ex) {
            throw new TransformationException("Expecting an AttachmentmentPart object", (Throwable)ex);
        }
        catch (NullPointerException ex) {
            throw new TransformationException("Expecting an AttachmentmentPart object", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new TransformationException("Can't retrieve attachment input stream", (Throwable)ex);
        }
        catch (SOAPException ex) {
            throw new TransformationException("Can't retrieve attachment input stream", (Throwable)ex);
        }
    }
}

