/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.wallet.commandline;

import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.logging.Jdk14LogLevelMapper;
import com.oracle.glcm.patch.wallet.commandline.CommandLineHolder;
import com.oracle.glcm.patch.wallet.commandline.CommandLineParser;
import com.oracle.glcm.patch.wallet.commandline.ConfigurationOption;
import com.oracle.glcm.patch.wallet.commandline.OperationArgumentException;
import com.oracle.glcm.patch.wallet.commandline.OperationConfigurationOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public abstract class Operation {
    public static final String OPERATION_NAMESPACE = "operation";
    private static final String[] OPERATION_BUNDLE = new String[]{"resources/patch-wallet/wallet_message"};

    public CommandLineHolder parse(String[] args) throws OperationArgumentException {
        CommandLineHolder holder = new CommandLineParser().parseCommandLineArgs(args);
        this.validateHolder(holder);
        return holder;
    }

    public CommandLineHolder parse(String[] args, List<ConfigurationOption> supportedOptions) throws OperationArgumentException {
        CommandLineHolder holder = new CommandLineParser().parseCommandLineArg(args, supportedOptions);
        this.validateHolder(holder);
        return holder;
    }

    protected boolean isHelpRequested(String[] args) {
        return args.length == 0 || args[0].equals("-help") || args[0].equals("--help");
    }

    protected String getUsage() {
        StringBuilder sb = new StringBuilder(700);
        sb.append(this.getHelpMessageTitle()).append(System.getProperty("line.separator"));
        int maxLen = 0;
        List<ConfigurationOption> options = this.getHelpDisplayOptions();
        for (ConfigurationOption option : options) {
            maxLen = Math.max(maxLen, option.getName().length());
        }
        for (ConfigurationOption option : options) {
            StringBuilder values = new StringBuilder();
            if (option.getAllowedValues() != null) {
                for (String v : option.getAllowedValues()) {
                    if (values.length() > 0) {
                        values.append(", ");
                    }
                    values.append(v);
                }
            }
            String descr = option instanceof OperationConfigurationOption ? MessageFormat.format(option.getDescr(), ((OperationConfigurationOption)option).getMessageParams()) : String.format("%s%s%s", "<", MessageFormat.format(option.getDescr(), values, option.getDefaultValue()), ">");
            sb.append(option.isRequired() ? String.format("%" + (5 + maxLen) + "s - %s%n", "-" + option.getName(), descr) : String.format("%" + (5 + maxLen) + "s - %s%s%n", "[-" + option.getName(), descr, "]"));
        }
        return sb.toString();
    }

    protected static String getI18nString(String key, Object ... params) {
        String value = ResourceBundleManager.getString((String)OPERATION_NAMESPACE, (String)key);
        return value == null ? key : MessageFormat.format(value, params);
    }

    protected static String getI18nString(String key) {
        String value = ResourceBundleManager.getString((String)OPERATION_NAMESPACE, (String)key);
        return value == null ? key : value;
    }

    protected abstract String getHelpMessageTitle();

    protected abstract List<ConfigurationOption> getHelpDisplayOptions();

    protected String getSingleValue(List<String> values) {
        if (values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    protected void validateHolder(CommandLineHolder holder) throws OperationArgumentException {
        Map<String, String> invalidOptions = holder.getInvalidOptions();
        List<String> unattachedValues = holder.getUnattachedValues();
        if (!invalidOptions.isEmpty() || !unattachedValues.isEmpty()) {
            ArrayList<String> invalidArgs = new ArrayList<String>();
            invalidArgs.addAll(invalidOptions.keySet());
            invalidArgs.addAll(unattachedValues);
            throw new OperationArgumentException(invalidArgs);
        }
    }

    protected boolean isJDKSupportedLogLevel(String logLevel) {
        Level level = null;
        return (level = Jdk14LogLevelMapper.mapToJdkLevel((String)logLevel, level)) != null;
    }

    static {
        ResourceBundleManager.manageBundles((String)OPERATION_NAMESPACE, (String[])OPERATION_BUNDLE);
    }
}

