/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.util;

import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.dsig.XSReference;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.dsig.XSSignedInfo;
import oracle.security.xmlsec.saml2.profiles.attribute.GenericAttribute;
import oracle.security.xmlsec.saml2.profiles.attribute.basic.BasicAttribute;
import oracle.security.xmlsec.saml2.profiles.attribute.dce.DCEForeignGroupsAttribute;
import oracle.security.xmlsec.saml2.profiles.attribute.dce.DCEGroupsAttribute;
import oracle.security.xmlsec.saml2.profiles.attribute.dce.DCEPrimaryGroupAttribute;
import oracle.security.xmlsec.saml2.profiles.attribute.dce.DCEPrincipalAttribute;
import oracle.security.xmlsec.saml2.profiles.attribute.dce.DCERealmAttribute;
import oracle.security.xmlsec.saml2.profiles.attribute.uuid.UUIDAttribute;
import oracle.security.xmlsec.saml2.profiles.attribute.x500.X500Attribute;
import oracle.security.xmlsec.saml2.profiles.attribute.xacml.XACMLAttribute;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SAML2Utils {
    public static String collectTextFromChild(XMLElement contextElement, String namespaceURI, String localName) {
        NodeList list = XMLElement.getChildElementsByTagNameNS((Element)((Element)contextElement.getNode()), (String)namespaceURI, (String)localName);
        if (list.getLength() > 0) {
            return XMLUtils.collectText((Node)list.item(0));
        }
        return null;
    }

    public static List collectTextFromChildren(XMLElement contextElement, String namespaceURI, String localName) {
        NodeList list = XMLElement.getChildElementsByTagNameNS((Element)((Element)contextElement.getNode()), (String)namespaceURI, (String)localName);
        ArrayList<String> result = new ArrayList<String>(list.getLength());
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            result.add(XMLUtils.collectText((Node)list.item(i)));
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }

    public static void insertChildElementWithText(XMLElement contextElement, String namespaceURI, String localName, String[] namespaceURIs, String[] localNames, String text, boolean replaceExisting) throws DOMException {
        Document doc = contextElement.getOwnerDocument();
        Element child = doc.createElementNS(namespaceURI, localName);
        child.appendChild(doc.createTextNode(text));
        XMLUtils.copyNSPrefix((Element)((Element)contextElement.getNode()), (Element)child);
        if (child.getPrefix() == null) {
            String prefix = XMLElement.getDefaultNSPrefix((String)namespaceURI);
            if (prefix != null) {
                XMLElement.addNSPrefixAttr((Element)child, (String)prefix, (String)namespaceURI);
                child.setPrefix(prefix);
            } else {
                child.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceURI);
            }
        }
        if (replaceExisting) {
            XMLUtils.removeChildren((Element)((Element)contextElement.getNode()), (String)namespaceURI, (String)localName);
        }
        XMLUtils.insertChild((Element)((Element)contextElement.getNode()), (Element)child, (String[])namespaceURIs, (String[])localNames);
    }

    public static void insertChildElementWithNode(XMLElement contextElement, String namespaceURI, String localName, String[] namespaceURIs, String[] localNames, Node node, boolean replaceExisting) throws DOMException {
        Document doc = contextElement.getOwnerDocument();
        Element child = doc.createElementNS(namespaceURI, localName);
        child.appendChild(node);
        XMLUtils.copyNSPrefix((Element)((Element)contextElement.getNode()), (Element)child);
        if (child.getPrefix() == null) {
            String prefix = XMLElement.getDefaultNSPrefix((String)namespaceURI);
            if (prefix != null) {
                XMLElement.addNSPrefixAttr((Element)child, (String)prefix, (String)namespaceURI);
                child.setPrefix(prefix);
            } else {
                child.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceURI);
            }
        }
        if (replaceExisting) {
            XMLUtils.removeChildren((Element)((Element)contextElement.getNode()), (String)namespaceURI, (String)localName);
        }
        XMLUtils.insertChild((Element)((Element)contextElement.getNode()), (Element)child, (String[])namespaceURIs, (String[])localNames);
    }

    public static void appendChildElementWithText(XMLElement contextElement, String namespaceURI, String localName, String text) throws DOMException {
        Document doc = contextElement.getOwnerDocument();
        Element child = doc.createElementNS(namespaceURI, localName);
        child.appendChild(doc.createTextNode(text));
        XMLUtils.copyNSPrefix((Element)((Element)contextElement.getNode()), (Element)child);
        contextElement.appendChild((Node)child);
    }

    public static void appendChildElementWithNode(XMLElement contextElement, String namespaceURI, String localName, Node node) throws DOMException {
        Document doc = contextElement.getOwnerDocument();
        Element child = doc.createElementNS(namespaceURI, localName);
        child.appendChild(node);
        XMLUtils.copyNSPrefix((Element)((Element)contextElement.getNode()), (Element)child);
        contextElement.appendChild((Node)child);
    }

    public static void setChildElement(XMLElement contextElement, XMLElement element, String[] nsURIs, String[] localNames) {
        XMLUtils.removeChildren((Element)((Element)contextElement.getNode()), (String)element.getNamespaceURI(), (String)element.getLocalName());
        XMLUtils.insertChild((XMLElement)contextElement, (XMLElement)element, (String[])nsURIs, (String[])localNames);
    }

    public static XMLElement getChildElement(XMLElement contextElement, String nsURI, String localName) {
        XMLElement element = null;
        NodeList nList = contextElement.getChildElementsByTagNameNS(nsURI, localName);
        if (nList.getLength() != 0 && (element = SAML2Utils.getInstance((Element)nList.item(0), null, null)) != null) {
            element.setSystemId(contextElement.getSystemId());
        }
        return element;
    }

    public static List getChildElements(XMLElement contextElement, String nsURI, String localName) {
        NodeList nList = contextElement.getChildElementsByTagNameNS(nsURI, localName);
        if (nList.getLength() > 0) {
            ArrayList<XMLElement> result = new ArrayList<XMLElement>(nList.getLength());
            int n = nList.getLength();
            for (int i = 0; i < n; ++i) {
                XMLElement element = SAML2Utils.getInstance((Element)nList.item(i), null, null);
                if (element == null) continue;
                element.setSystemId(contextElement.getSystemId());
                result.add(element);
            }
            if (result.size() > 0) {
                return result;
            }
        }
        return null;
    }

    public static List getChildren(XMLElement contextElement, String nsURI, String localName) {
        NodeList nList = contextElement.getChildElementsByTagNameNS(nsURI, localName);
        if (nList.getLength() > 0) {
            ArrayList<Node> result = new ArrayList<Node>(nList.getLength());
            int n = nList.getLength();
            for (int i = 0; i < n; ++i) {
                result.add(nList.item(i));
            }
            return result;
        }
        return null;
    }

    public static void insertChild(XMLElement contextElement, XMLElement element, String nsURI, String[] tagList) {
        int l = tagList.length;
        String[] nsList = new String[l];
        for (int i = 0; i < l; ++i) {
            nsList[i] = nsURI;
        }
        XMLUtils.insertChild((XMLElement)contextElement, (XMLElement)element, (String[])nsList, (String[])tagList);
    }

    public static XMLElement getInstance(Element element, String tag, String ns) {
        String dt;
        ns = null;
        tag = null;
        String nodeName = element.getNodeName();
        String tagLocal = QName.getLocalPart((String)nodeName);
        String tagNS = XMLUtils.getNamespaceURI((Node)element);
        XMLElement result = XMLUtils.getInstance((Element)element, (String)tag, (String)ns);
        if (result != null) {
            return result;
        }
        if (!tagLocal.equals("Attribute") || !tagNS.equals("urn:oasis:names:tc:SAML:2.0:assertion")) {
            return null;
        }
        String nf = element.getAttribute("NameFormat");
        if (nf != null && nf.equals("urn:oasis:names:tc:SAML:2.0:attrname-format:basic")) {
            return new BasicAttribute(element);
        }
        if (nf != null && nf.equals("urn:oasis:names:tc:SAML:2.0:attrname-format:uri")) {
            String name = element.getAttribute("Name");
            if (name.startsWith("urn:oid:")) {
                return new X500Attribute(element);
            }
            if (name.startsWith("urn:uuid:")) {
                return new UUIDAttribute(element);
            }
            if (name.equals("urn:oasis:names:tc:SAML:2.0:profiles:attribute:DCE:realm")) {
                return new DCERealmAttribute(element);
            }
            if (name.equals("urn:oasis:names:tc:SAML:2.0:profiles:attribute:DCE:principal")) {
                return new DCEPrincipalAttribute(element);
            }
            if (name.equals("urn:oasis:names:tc:SAML:2.0:profiles:attribute:DCE:primary-group")) {
                return new DCEPrimaryGroupAttribute(element);
            }
            if (name.equals("urn:oasis:names:tc:SAML:2.0:profiles:attribute:DCE:groups")) {
                return new DCEGroupsAttribute(element);
            }
            if (name.equals("urn:oasis:names:tc:SAML:2.0:profiles:attribute:DCE:foreign-group")) {
                return new DCEForeignGroupsAttribute(element);
            }
        }
        if ((dt = element.getAttributeNS("urn:oasis:names:tc:SAML:2.0:profiles:attribute:XACML", "DataType")) != null && dt.length() > 0) {
            return new XACMLAttribute(element);
        }
        return new GenericAttribute(element);
    }

    public static XSSignature createSignature(XMLElement tbs, String tbsID, String signatureMethod, String c14nMethod, String digestMethod) {
        XSSignature sig = XSSignature.newInstance((Document)tbs.getOwnerDocument(), null);
        XSSignedInfo si = sig.createSignedInfo(c14nMethod, signatureMethod, null);
        sig.setSignedInfo(si);
        XSReference ref = sig.createReference();
        ref.setDigestMethod(digestMethod);
        ref.setURI("#" + tbsID);
        si.addReference(ref);
        if (tbsID == null || tbsID.length() == 0) {
            String nsURI = tbs.getNamespaceURI();
            String prefix = tbs.getPrefix();
            if (prefix == null && nsURI != null) {
                prefix = XMLElement.getDefaultNSPrefix((String)nsURI);
            }
            String elemName = (prefix != null ? prefix + ":" : "") + tbs.getLocalName();
            String expr = "count(ancestor-or-self::" + elemName + " | here()/ancestor::" + elemName + "[1]) = count(ancestor-or-self::" + elemName + ")";
            XSAlgorithmIdentifier xpath = sig.createXPathTransform(prefix, nsURI, expr);
            ref.addTransform(xpath);
        }
        XSAlgorithmIdentifier est = sig.createTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        ref.addTransform(est);
        if (!"http://www.w3.org/TR/2001/REC-xml-c14n-20010315".equals(c14nMethod)) {
            XSAlgorithmIdentifier c14nTrans = sig.createTransform(c14nMethod);
            ref.addTransform(c14nTrans);
        }
        return sig;
    }

    static {
        SAML2Initializer.initialize();
    }
}

